/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.components;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import nl.b3p.viewer.components.ComponentRegistryInitializer;
import nl.b3p.viewer.components.ViewerComponent;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ComponentRegistry {
    private static final Log log = LogFactory.getLog(ComponentRegistry.class);
    private final Map<String, ViewerComponent> components = new HashMap<String, ViewerComponent>();
    private final List<File> componentPaths = new ArrayList<File>();

    boolean loadFromPath(ServletContext sc, String p) {
        String[] files;
        File path = this.resolvePath(sc, p);
        if (path == null) {
            return false;
        }
        log.info((Object)("Loading component metadata from path " + path));
        for (String file : files = path.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase("components.json");
            }
        })) {
            String filename = path + File.separator + file;
            try {
                String contents = "";
                Compiler compiler = new Compiler();
                CompilerOptions options = new CompilerOptions();
                CompilationLevel.WHITESPACE_ONLY.setOptionsForCompilationLevel(options);
                options.setOutputCharset("UTF-8");
                compiler.compile((SourceFile)JSSourceFile.fromCode((String)"dummy.js", (String)""), (SourceFile)JSSourceFile.fromFile((String)filename, (Charset)Charset.forName("UTF-8")), options);
                if (compiler.hasErrors()) {
                    log.warn((Object)(compiler.getErrorCount() + " error(s) minifying source file " + filename + "; using original source"));
                    contents = IOUtils.toString((InputStream)new FileInputStream(filename), (String)"UTF-8");
                    for (int i = 0; i < compiler.getErrorCount(); ++i) {
                        JSError error = compiler.getErrors()[i];
                        String er = String.format("#%d line %d,%d: %s: %s", i + 1, error.lineNumber, error.getCharno(), error.level.toString(), error.description);
                        log.warn((Object)er);
                    }
                } else {
                    contents = compiler.toSource();
                }
                try {
                    JSONObject componentMetadata = new JSONObject(contents);
                    this.loadComponentMetadata(path, componentMetadata);
                }
                catch (JSONException e) {
                    try {
                        JSONArray components = new JSONArray(contents);
                        for (int i = 0; i < components.length(); ++i) {
                            this.loadComponentMetadata(path, components.getJSONObject(i));
                        }
                    }
                    catch (JSONException e2) {
                        log.error((Object)("Exception parsing file " + file), (Throwable)e2);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Exception reading file " + file), (Throwable)e);
            }
        }
        return true;
    }

    private void loadComponentMetadata(File path, JSONObject metadata) throws IOException {
        log.debug((Object)("Load component: " + metadata));
        try {
            File[] configSourceFiles;
            File[] sourceFiles;
            String className = metadata.getString("className");
            if (this.components.containsKey(className)) {
                log.error((Object)String.format("Ignoring duplicate component classname \"%s\" in when loading from path \"%s\"", className, path.toString()));
                return;
            }
            String group = "Rest";
            if (metadata.has("group")) {
                group = metadata.getString("group");
            } else {
                metadata.put("group", (Object)group);
            }
            try {
                sourceFiles = this.getFiles(path, metadata.optJSONArray("sources"));
                configSourceFiles = this.getFiles(path, metadata.optJSONArray("configSource"));
            }
            catch (FileNotFoundException e) {
                log.error((Object)String.format("Error reading file in component class \"%s\": \"%s\"", className, e.getMessage()));
                return;
            }
            this.components.put(className, new ViewerComponent(path.getCanonicalPath(), className, sourceFiles, configSourceFiles, metadata, group));
            log.debug((Object)("Registered component " + className));
        }
        catch (JSONException e) {
            log.error((Object)("Invalid component metadata in directory " + path + ": " + e.getMessage()));
        }
    }

    public static ComponentRegistry getInstance() {
        return ComponentRegistryInitializer.getInstance();
    }

    public List<String> getSortedComponentClassNameList() {
        ArrayList<String> names = new ArrayList<String>(this.components.keySet());
        Collections.sort(names);
        return names;
    }

    public List<String> getClassNameListSortedByDisplayName() {
        ArrayList<String> names = new ArrayList<String>(this.components.keySet());
        Collections.sort(names, new Comparator<String>(){

            @Override
            public int compare(String lhs, String rhs) {
                ViewerComponent vcLhs = (ViewerComponent)ComponentRegistry.this.components.get(lhs);
                ViewerComponent vcRhs = (ViewerComponent)ComponentRegistry.this.components.get(rhs);
                lhs = vcLhs.getMetadata().optString("name", lhs);
                rhs = vcRhs.getMetadata().optString("name", rhs);
                return lhs.compareTo(rhs);
            }
        });
        return names;
    }

    private File[] getFiles(File path, JSONArray sources) throws IOException, JSONException {
        File[] sourceFiles = new File[]{};
        if (sources != null) {
            sourceFiles = new File[sources.length()];
            for (int i = 0; i < sources.length(); ++i) {
                File sourceFile = new File(path.getCanonicalPath() + File.separator + sources.getString(i));
                if (!sourceFile.canRead() && (sourceFile = this.getFileFromComponentPaths(sources.getString(i))) == null) {
                    throw new FileNotFoundException(String.format("Cannot read sourcefile \"%s\"", sources.getString(i)));
                }
                sourceFiles[i] = sourceFile;
            }
        }
        return sourceFiles;
    }

    private File resolvePath(ServletContext sc, String p) {
        File path = new File(sc.getRealPath(p));
        log.debug((Object)String.format("Real path for \"%s\": %s", p, path));
        if (!path.exists() || !path.canRead()) {
            log.debug((Object)String.format("Cannot load component metadata from context path converted to real path: \"%s\", trying as file path.", path));
            path = new File(p);
        }
        if (!path.exists() || !path.canRead()) {
            log.error((Object)String.format("Cannot load component metadata from file path \"%s\"", path));
            return null;
        }
        return path;
    }

    private File getFileFromComponentPaths(String source) throws IOException {
        for (File path : this.componentPaths) {
            File file = new File(path.getCanonicalPath() + File.separator + source);
            if (!file.canRead()) continue;
            return file;
        }
        return null;
    }

    public ViewerComponent getViewerComponent(String className) {
        return this.components.get(className);
    }

    public void setComponentPaths(ServletContext sc, String[] componentPaths) {
        this.componentPaths.clear();
        for (String componentPath : componentPaths) {
            File f = this.resolvePath(sc, componentPath);
            if (f == null) continue;
            this.componentPaths.add(f);
        }
    }
}

