/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.components;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import nl.b3p.viewer.components.ComponentRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComponentRegistryInitializer
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(ComponentRegistryInitializer.class);
    private static final String DEFAULT_COMPONENT_PATH = "/viewer-html/components";
    private static final String PARAM_CROSS_CONTEXT = "componentregistry.crosscontext";
    private static final String PARAM_PATH = "componentregistry.path";
    private static final String PARAM_PATH_OLD = "component-path";
    private static ComponentRegistry registry;
    private static ServletContext servletContext;
    private static String crossContextName;
    private static boolean retryLoading;
    private static String componentPath;

    public void contextInitialized(ServletContextEvent sce) {
        servletContext = sce.getServletContext();
        registry = new ComponentRegistry();
        crossContextName = servletContext.getInitParameter(PARAM_CROSS_CONTEXT);
        componentPath = servletContext.getInitParameter(PARAM_PATH);
        if (componentPath == null) {
            componentPath = servletContext.getInitParameter(PARAM_PATH_OLD);
        }
        if (componentPath == null) {
            componentPath = DEFAULT_COMPONENT_PATH;
        }
        ServletContext pathContext = servletContext;
        if (crossContextName != null) {
            log.info((Object)("Looking at cross context \"" + crossContextName + "\" for component paths..."));
            ServletContext crossContext = servletContext.getContext(crossContextName);
            if (crossContext != null) {
                pathContext = crossContext;
            }
        }
        registry.setComponentPaths(pathContext, componentPath.split(","));
        ComponentRegistryInitializer.tryComponentLoading();
    }

    private static synchronized void tryComponentLoading() {
        if (!retryLoading) {
            return;
        }
        if (crossContextName != null) {
            ComponentRegistryInitializer.tryLoadCrossContextComponents();
        } else {
            retryLoading = false;
            ComponentRegistryInitializer.loadLocalComponents();
        }
    }

    private static void loadLocalComponents() {
        for (String p : componentPath.split(",")) {
            try {
                registry.loadFromPath(servletContext, p);
            }
            catch (Exception e) {
                log.error((Object)("Error loading components from path \"" + p + "\""), (Throwable)e);
            }
        }
    }

    private static void tryLoadCrossContextComponents() {
        assert (crossContextName != null);
        log.info((Object)("Looking at cross context \"" + crossContextName + "\" for components..."));
        ServletContext crossContext = servletContext.getContext(crossContextName);
        if (crossContext == null) {
            log.error((Object)("Cannot get cross context for name \"" + crossContextName + "\", is it deployed? Can't load components from it!"));
            retryLoading = true;
        } else {
            log.debug((Object)"Context found, checking context parameters for paths...");
            String crossContextComponentPath = crossContext.getInitParameter(PARAM_PATH);
            if (crossContextComponentPath == null) {
                crossContextComponentPath = crossContext.getInitParameter(PARAM_PATH_OLD);
            }
            if (crossContextComponentPath == null) {
                crossContextComponentPath = DEFAULT_COMPONENT_PATH;
            }
            log.info((Object)("Cross context component path: \"" + crossContextComponentPath + "\""));
            for (String p : crossContextComponentPath.split(",")) {
                try {
                    log.info((Object)String.format("Loading component metadata from cross context \"%s\" path \"%s\"", crossContextName, p));
                    registry.loadFromPath(crossContext, p);
                }
                catch (Exception e) {
                    log.error((Object)String.format("Error loading components from cross context \"%s\", path \"%s\"", crossContextName, p), (Throwable)e);
                }
            }
            if (!registry.getSortedComponentClassNameList().isEmpty()) {
                retryLoading = false;
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    public static ComponentRegistry getInstance() {
        ComponentRegistryInitializer.tryComponentLoading();
        return registry;
    }

    static {
        retryLoading = true;
    }
}

