/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.arcgis;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opengis.geometry.BoundingBox;

public class ArcGISUtils {
    private static final Log log = LogFactory.getLog(ArcGISUtils.class);

    public static Class getBinding(String esriType) {
        if (esriType.equals("esriFieldTypeGeometry")) {
            return Geometry.class;
        }
        if (esriType.equals("esriFieldTypeDate")) {
            return Date.class;
        }
        if (esriType.equals("esriFieldTypeDouble")) {
            return Double.class;
        }
        if (esriType.equals("esriFieldTypeGUID")) {
            return String.class;
        }
        if (esriType.equals("esriFieldTypeGlobalID")) {
            return String.class;
        }
        if (esriType.equals("esriFieldTypeInteger")) {
            return Integer.class;
        }
        if (esriType.equals("esriFieldTypeOID")) {
            return Integer.class;
        }
        if (esriType.equals("esriFieldTypeSingle")) {
            return Float.class;
        }
        if (esriType.equals("esriFieldTypeSmallInteger")) {
            return Integer.class;
        }
        if (esriType.equals("esriFieldTypeString")) {
            return String.class;
        }
        return String.class;
    }

    public static Class getGeometryBinding(String esriGeometryType) {
        if ("esriGeometryPolyline".equals(esriGeometryType)) {
            return MultiLineString.class;
        }
        if ("esriGeometryMultipoint".equals(esriGeometryType)) {
            return MultiPoint.class;
        }
        if ("esriGeometryPoint".equals(esriGeometryType)) {
            return Point.class;
        }
        if ("esriGeometryPolygon".equals(esriGeometryType)) {
            return MultiPolygon.class;
        }
        log.warn((Object)("ArcGIS layer geometryType not supported: \"" + esriGeometryType + "\", using generic Geometry"));
        return Geometry.class;
    }

    public static String getGeometryType(Geometry geometry) {
        if (geometry instanceof LineString || geometry instanceof MultiLineString) {
            return "esriGeometryPolyline";
        }
        if (geometry instanceof MultiPoint) {
            return "esriGeometryMultipoint";
        }
        if (geometry instanceof Point) {
            return "esriGeometryPoint";
        }
        if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            return "esriGeometryPolygon";
        }
        throw new IllegalArgumentException("geometry class not supported: " + geometry.getClass());
    }

    public static Geometry convertToJTSGeometry(JSONObject j, Class binding, GeometryFactory gf) {
        if (binding.equals(Point.class)) {
            Object jx = j.get((Object)"x");
            Object jy = j.get((Object)"y");
            double x = jx instanceof Long ? ((Long)jx).doubleValue() : ((Double)jx).doubleValue();
            double y = jy instanceof Long ? ((Long)jy).doubleValue() : ((Double)jy).doubleValue();
            return gf.createPoint(new Coordinate(x, y));
        }
        if (binding.equals(MultiPoint.class)) {
            Coordinate[] coordinates = ArcGISUtils.JSONtoCoordinates((JSONArray)j.get((Object)"points"));
            return gf.createMultiPoint(coordinates);
        }
        if (binding.equals(MultiLineString.class)) {
            JSONArray paths = (JSONArray)j.get((Object)"paths");
            LineString[] lines = new LineString[paths.size()];
            for (int i = 0; i < paths.size(); ++i) {
                JSONArray jcoords = (JSONArray)paths.get(i);
                Coordinate[] coordinates = ArcGISUtils.JSONtoCoordinates(jcoords);
                lines[i] = gf.createLineString(coordinates);
            }
            return gf.createMultiLineString(lines);
        }
        if (binding.equals(MultiPolygon.class)) {
            JSONArray rings = (JSONArray)j.get((Object)"rings");
            Polygon[] polygons = new Polygon[rings.size()];
            for (int i = 0; i < rings.size(); ++i) {
                JSONArray jcoords = (JSONArray)rings.get(i);
                Coordinate[] coordinates = ArcGISUtils.JSONtoCoordinates(jcoords);
                polygons[i] = gf.createPolygon(gf.createLinearRing(coordinates), null);
            }
            return gf.createMultiPolygon(polygons);
        }
        throw new IllegalArgumentException("Don't know how to convert ArcGIS JSON geometry to JTS class " + binding.getName());
    }

    private static Coordinate[] JSONtoCoordinates(JSONArray jcoords) {
        Coordinate[] coordinates = new Coordinate[jcoords.size()];
        for (int i = 0; i < coordinates.length; ++i) {
            JSONArray xy = (JSONArray)jcoords.get(i);
            Object jx = xy.get(0);
            Object jy = xy.get(1);
            double x = jx instanceof Long ? ((Long)jx).doubleValue() : ((Double)jx).doubleValue();
            double y = jy instanceof Long ? ((Long)jy).doubleValue() : ((Double)jy).doubleValue();
            coordinates[i] = new Coordinate(x, y);
        }
        return coordinates;
    }

    private static JSONArray coordinatesToJSON(Coordinate[] coordinates) {
        JSONArray jcoords = new JSONArray();
        for (int i = 0; i < coordinates.length; ++i) {
            JSONArray xy = new JSONArray();
            xy.add((Object)coordinates[i].x);
            xy.add((Object)coordinates[i].y);
            jcoords.add((Object)xy);
        }
        return jcoords;
    }

    public static JSONObject convertToArcJSONEnvelope(BoundingBox bbox) {
        JSONObject j = new JSONObject();
        j.put((Object)"xmin", (Object)bbox.getMinX());
        j.put((Object)"ymin", (Object)bbox.getMinY());
        j.put((Object)"xmax", (Object)bbox.getMaxX());
        j.put((Object)"ymax", (Object)bbox.getMaxY());
        return j;
    }

    public static JSONObject convertToArcJSONEnvelope(Polygon bbox) {
        Coordinate c1 = bbox.getExteriorRing().getCoordinateN(0);
        Coordinate c2 = bbox.getExteriorRing().getCoordinateN(2);
        JSONObject j = new JSONObject();
        j.put((Object)"xmin", (Object)c1.x);
        j.put((Object)"ymin", (Object)c1.y);
        j.put((Object)"xmax", (Object)c2.x);
        j.put((Object)"ymax", (Object)c2.y);
        return j;
    }

    public static JSONObject convertToArcJSONGeometry(Geometry g) {
        JSONObject j = new JSONObject();
        if (g instanceof Point) {
            j.put((Object)"x", (Object)g.getCoordinate().x);
            j.put((Object)"y", (Object)g.getCoordinate().y);
        } else if (g instanceof MultiPoint) {
            j.put((Object)"points", (Object)ArcGISUtils.coordinatesToJSON(g.getCoordinates()));
        } else if (g instanceof LineString) {
            JSONArray paths = new JSONArray();
            paths.add((Object)ArcGISUtils.coordinatesToJSON(g.getCoordinates()));
            j.put((Object)"paths", (Object)paths);
        } else if (g instanceof MultiLineString) {
            JSONArray paths = new JSONArray();
            for (int i = 0; i < g.getNumGeometries(); ++i) {
                LineString ls = (LineString)g.getGeometryN(i);
                paths.add((Object)ArcGISUtils.coordinatesToJSON(ls.getCoordinates()));
            }
            j.put((Object)"paths", (Object)paths);
        } else if (g instanceof Polygon) {
            JSONArray rings = new JSONArray();
            rings.add((Object)ArcGISUtils.coordinatesToJSON(g.getCoordinates()));
            j.put((Object)"rings", (Object)rings);
        } else if (g instanceof MultiPolygon) {
            JSONArray rings = new JSONArray();
            for (int i = 0; i < g.getNumGeometries(); ++i) {
                Polygon p = (Polygon)g.getGeometryN(i);
                rings.add((Object)p.getExteriorRing().getCoordinates());
            }
            j.put((Object)"rings", (Object)rings);
        } else {
            return null;
        }
        return j;
    }
}

