/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.arcims;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import nl.b3p.geotools.data.arcims.ArcXMLRequest;
import nl.b3p.geotools.data.arcims.axl.AxlException;
import nl.b3p.geotools.data.arcims.axl.AxlFeatures;
import nl.b3p.geotools.data.arcims.axl.AxlGetFeatures;
import nl.b3p.geotools.data.arcims.axl.AxlGetServiceInfo;
import nl.b3p.geotools.data.arcims.axl.AxlRequest;
import nl.b3p.geotools.data.arcims.axl.AxlResponse;
import nl.b3p.geotools.data.arcims.axl.AxlServiceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.SimpleHttpClient;

public class ArcIMSServer {
    private final URL serverURL;
    private final String serviceName;
    private HTTPClient httpClient;
    private AxlServiceInfo axlServiceInfo;
    private ServiceInfo info = new ArcIMSInfo();

    public String getServiceName() {
        return this.serviceName;
    }

    public ArcIMSServer(URL serverURL, String serviceName) throws Exception {
        this(serverURL, serviceName, (HTTPClient)new SimpleHttpClient());
    }

    private static HTTPClient buildHttpClient(int timeout) throws Exception {
        SimpleHttpClient client = new SimpleHttpClient();
        client.setConnectTimeout(timeout);
        client.setReadTimeout(timeout);
        return client;
    }

    public ArcIMSServer(URL serverURL, String serviceName, int timeout) throws Exception {
        this(serverURL, serviceName, ArcIMSServer.buildHttpClient(timeout));
    }

    public ArcIMSServer(URL serverURL, String serviceName, HTTPClient httpClient) throws Exception {
        String q;
        if (serverURL == null) {
            throw new NullPointerException("serverURL");
        }
        if (serviceName == null && (q = serverURL.getQuery()) != null) {
            String needle = "servicename=";
            int i = q.toLowerCase().indexOf(needle);
            if (i != -1) {
                serviceName = (i = (q = q.substring(i + needle.length())).indexOf("&")) != -1 ? q.substring(0, i) : q;
            }
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("ServiceName staat niet in URL en is niet apart opgegeven");
        }
        if (httpClient == null) {
            throw new NullPointerException("httpClient");
        }
        this.serverURL = serverURL;
        this.serviceName = serviceName;
        this.httpClient = httpClient;
        this.loadServiceInfo();
    }

    public ServiceInfo getInfo() {
        return this.info;
    }

    public AxlServiceInfo getAxlServiceInfo() {
        return this.axlServiceInfo;
    }

    protected ArcXMLRequest createRequest(AxlRequest req) {
        return new ArcXMLRequest(this.serverURL, this.serviceName, req);
    }

    private void loadServiceInfo() throws Exception {
        AxlResponse response = this.internalIssueRequest(this.createRequest(new AxlGetServiceInfo()));
        if (response.getError() != null) {
            throw new AxlException(response.getError());
        }
        this.axlServiceInfo = response.getServiceInfo();
    }

    public AxlFeatures getFeatures(AxlGetFeatures request) throws Exception {
        request.setGeometry(true);
        request.setAttributes(true);
        ArcXMLRequest req = this.createRequest(request);
        req.setProperty("CustomService", "Query");
        AxlResponse response = this.internalIssueRequest(req);
        if (response.getError() != null) {
            throw new AxlException(response.getError());
        }
        return response.getFeatures();
    }

    protected AxlResponse internalIssueRequest(ArcXMLRequest request) throws Exception {
        URL finalURL = request.getFinalURL();
        String postContentType = request.getPostContentType();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        request.performPostOutput(out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        HTTPResponse httpResponse = this.httpClient.post(finalURL, (InputStream)in, postContentType);
        return request.parseResponse(httpResponse);
    }

    protected class ArcIMSInfo
    implements ServiceInfo {
        protected ArcIMSInfo() {
        }

        public String getTitle() {
            return ArcIMSServer.this.serviceName;
        }

        public Set<String> getKeywords() {
            return Collections.EMPTY_SET;
        }

        public String getDescription() {
            return this.getTitle();
        }

        public URI getPublisher() {
            return null;
        }

        public URI getSchema() {
            return null;
        }

        public URI getSource() {
            return null;
        }
    }
}

