/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.arcims;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import nl.b3p.geotools.data.arcims.axl.AxlCoords;
import nl.b3p.geotools.data.arcims.axl.AxlEnvelope;
import nl.b3p.geotools.data.arcims.axl.AxlGeometry;
import nl.b3p.geotools.data.arcims.axl.AxlMultiPoint;
import nl.b3p.geotools.data.arcims.axl.AxlPolygon;
import nl.b3p.geotools.data.arcims.axl.AxlPolyline;
import nl.b3p.geotools.data.arcims.axl.AxlRing;
import org.opengis.geometry.BoundingBox;

public class ArcXMLUtils {
    public static Geometry convertToJTSGeometry(AxlGeometry axlg, GeometryFactory gf) throws IOException {
        if (axlg instanceof AxlMultiPoint) {
            return gf.createMultiPoint(ArcXMLUtils.parseAxlCoords(((AxlMultiPoint)axlg).getCoords()));
        }
        if (axlg instanceof AxlPolyline) {
            ArrayList<LineString> lines = new ArrayList<LineString>();
            for (AxlCoords axlc : ((AxlPolyline)axlg).getPaths()) {
                Coordinate[] coords = ArcXMLUtils.parseAxlCoords(axlc.getCoords());
                lines.add(gf.createLineString(coords));
            }
            return gf.createMultiLineString(lines.toArray(new LineString[0]));
        }
        if (axlg instanceof AxlPolygon) {
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            for (AxlRing axlr : ((AxlPolygon)axlg).getRings()) {
                LinearRing shell = gf.createLinearRing(ArcXMLUtils.parseAxlCoords(axlr.getCoords()));
                ArrayList<LinearRing> holes = null;
                if (axlr.getHoles() != null) {
                    holes = new ArrayList<LinearRing>();
                    for (AxlCoords hole : axlr.getHoles()) {
                        holes.add(gf.createLinearRing(ArcXMLUtils.parseAxlCoords(hole.getCoords())));
                    }
                }
                polygons.add(gf.createPolygon(shell, holes == null ? null : holes.toArray(new LinearRing[0])));
            }
            return gf.createMultiPolygon(polygons.toArray(new Polygon[0]));
        }
        return null;
    }

    public static Coordinate[] parseAxlCoords(String coords) throws IOException {
        ArrayList<Coordinate> c = new ArrayList<Coordinate>();
        StringTokenizer tok = new StringTokenizer(coords, " ;");
        while (tok.hasMoreTokens()) {
            String sx = tok.nextToken();
            if (!tok.hasMoreTokens()) break;
            String sy = tok.nextToken();
            sx = sx.replace(',', '.');
            sy = sy.replace(',', '.');
            try {
                Coordinate coordinate = new Coordinate(Double.parseDouble(sx), Double.parseDouble(sy));
                c.add(coordinate);
            }
            catch (NumberFormatException nfe) {
                throw new IOException("Cannot parse ArcXML coordinate (" + sx + "," + sy + ")", nfe);
            }
        }
        return c.toArray(new Coordinate[0]);
    }

    public static String toAxlCoords(Coordinate[] coords) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Coordinate c : coords) {
            if (first) {
                first = false;
            } else {
                sb.append(";");
            }
            sb.append(c.x);
            sb.append(" ");
            sb.append(c.y);
        }
        return sb.toString();
    }

    public static AxlEnvelope convertToAxlEnvelope(BoundingBox bbox) {
        AxlEnvelope e = new AxlEnvelope();
        e.setMinx(bbox.getMinX() + "");
        e.setMaxx(bbox.getMaxX() + "");
        e.setMiny(bbox.getMinY() + "");
        e.setMaxy(bbox.getMaxY() + "");
        return e;
    }

    public static AxlEnvelope convertToAxlEnvelope(Polygon bbox) {
        Coordinate c1 = bbox.getExteriorRing().getCoordinateN(0);
        Coordinate c2 = bbox.getExteriorRing().getCoordinateN(2);
        AxlEnvelope e = new AxlEnvelope();
        e.setMinx(c1.x + "");
        e.setMaxx(c2.x + "");
        e.setMiny(c1.y + "");
        e.setMaxy(c2.y + "");
        return e;
    }

    public static AxlGeometry convertToAxlGeometry(Geometry g) {
        if (g instanceof Point || g instanceof MultiPoint) {
            AxlMultiPoint ag = new AxlMultiPoint();
            ag.setCoords(ArcXMLUtils.toAxlCoords(g.getCoordinates()));
            return ag;
        }
        if (g instanceof LineString || g instanceof MultiLineString) {
            AxlPolyline ag = new AxlPolyline();
            ag.setPaths(new ArrayList<AxlCoords>());
            if (g instanceof LineString) {
                ag.getPaths().add(new AxlCoords(ArcXMLUtils.toAxlCoords(g.getCoordinates())));
            } else {
                for (int i = 0; i < g.getNumGeometries(); ++i) {
                    LineString ls = (LineString)g.getGeometryN(i);
                    ag.getPaths().add(new AxlCoords(ArcXMLUtils.toAxlCoords(ls.getCoordinates())));
                }
            }
            return ag;
        }
        if (g instanceof Polygon || g instanceof MultiPolygon) {
            AxlPolygon ag = new AxlPolygon();
            ag.setRings(new ArrayList<AxlRing>());
            if (g instanceof Polygon) {
                ag.getRings().add(ArcXMLUtils.polygonToAxlRing((Polygon)g));
            } else {
                for (int i = 0; i < g.getNumGeometries(); ++i) {
                    Polygon p = (Polygon)g.getGeometryN(i);
                    ag.getRings().add(ArcXMLUtils.polygonToAxlRing(p));
                }
            }
            return ag;
        }
        return null;
    }

    public static AxlRing polygonToAxlRing(Polygon p) {
        AxlRing r = new AxlRing();
        r.setCoords(ArcXMLUtils.toAxlCoords(p.getExteriorRing().getCoordinates()));
        if (p.getNumInteriorRing() > 0) {
            r.setHoles(new ArrayList<AxlCoords>());
            for (int i = 0; i < p.getNumInteriorRing(); ++i) {
                LineString hole = p.getInteriorRingN(i);
                r.getHoles().add(new AxlCoords(ArcXMLUtils.toAxlCoords(hole.getCoordinates())));
            }
        }
        return r;
    }
}

