/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.arcims;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import nl.b3p.geotools.data.arcims.ArcIMSFeatureSource;
import nl.b3p.geotools.data.arcims.ArcIMSServer;
import nl.b3p.geotools.data.arcims.axl.AxlLayerInfo;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.SimpleHttpClient;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ArcIMSDataStore
extends ContentDataStore {
    private URL url;
    private String serviceName;
    private String user;
    private String passwd;
    private Integer timeout;
    private CoordinateReferenceSystem crs;
    private ArcIMSServer arcims;
    private List<Name> typeNames;

    public ArcIMSDataStore(URL url, String serviceName) {
        this(url, serviceName, null, null, null, null);
    }

    public ArcIMSDataStore(URL url, String serviceName, String user, String passwd, Integer timeout, CoordinateReferenceSystem crs) {
        this.url = url;
        this.serviceName = serviceName;
        this.user = user;
        this.passwd = passwd;
        this.timeout = timeout;
        this.crs = crs;
    }

    public ArcIMSServer getArcIMSServer() throws IOException {
        if (this.arcims == null) {
            SimpleHttpClient client = new SimpleHttpClient();
            client.setUser(this.user);
            client.setPassword(this.passwd);
            if (this.timeout != null) {
                client.setConnectTimeout(this.timeout.intValue());
                client.setReadTimeout(this.timeout.intValue());
            }
            try {
                this.arcims = new ArcIMSServer(this.url, this.serviceName, (HTTPClient)client);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return this.arcims;
    }

    protected List<Name> createTypeNames() throws IOException {
        if (this.typeNames == null) {
            this.getArcIMSServer();
            this.typeNames = new ArrayList<Name>();
            for (AxlLayerInfo l : this.arcims.getAxlServiceInfo().getLayers()) {
                if (!"featureclass".equals(l.getType())) continue;
                this.typeNames.add((Name)new NameImpl(l.getId()));
            }
        }
        return this.typeNames;
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry ce) throws IOException {
        return new ArcIMSFeatureSource(ce);
    }

    public AxlLayerInfo getAxlLayerInfo(String layer) throws IOException {
        this.getArcIMSServer();
        for (AxlLayerInfo l : this.arcims.getAxlServiceInfo().getLayers()) {
            if (!layer.equals(l.getId())) continue;
            return l;
        }
        return null;
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public String toString() {
        return "ArcIMSDataStore URL=" + this.url.toString() + " ServiceName=" + this.serviceName;
    }
}

