/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.arcims;

import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import nl.b3p.geotools.data.arcims.ArcIMSDataStore;
import nl.b3p.geotools.data.arcims.ArcIMSFeatureSource;
import nl.b3p.geotools.data.arcims.FilterToArcXMLSQL;
import nl.b3p.geotools.data.arcims.axl.AxlFeature;
import nl.b3p.geotools.data.arcims.axl.AxlFeatures;
import nl.b3p.geotools.data.arcims.axl.AxlField;
import nl.b3p.geotools.data.arcims.axl.AxlGetFeatures;
import nl.b3p.geotools.data.arcims.axl.AxlLayerInfo;
import nl.b3p.geotools.data.arcims.axl.AxlSpatialQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.Query;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

class ArcIMSFeatureReader
implements SimpleFeatureReader {
    private static final Log log = LogFactory.getLog(ArcIMSFeatureReader.class);
    private ArcIMSFeatureSource fs;
    private Query query;
    private String[] internedPropertyNames;
    private boolean initBeforeRequestDone = false;
    private SimpleFeatureBuilder builder;
    private SimpleFeatureType featureType;
    private GeometryFactory geometryFactory = new GeometryFactory();
    private AxlGetFeatures request;
    private AxlFeatures response;
    private int startIndex = 0;
    private Integer maxFeatures;
    private int index;
    private Integer totalCount;
    private String rowIdAttribute;

    public ArcIMSFeatureReader(ArcIMSFeatureSource fs, Query query) {
        this.fs = fs;
        this.query = query;
        if (query.getStartIndex() != null) {
            this.startIndex = query.getStartIndex();
        }
        if (!query.isMaxFeaturesUnlimited()) {
            this.maxFeatures = query.getMaxFeatures();
        }
        if (!query.retrieveAllProperties() && query.getPropertyNames().length > 0) {
            String[] propertyNames = query.getPropertyNames();
            this.internedPropertyNames = new String[propertyNames.length];
            for (int i = 0; i < propertyNames.length; ++i) {
                this.internedPropertyNames[i] = propertyNames[i].intern();
            }
            Arrays.sort(this.internedPropertyNames);
        }
        if (log.isDebugEnabled()) {
            String qryString = null;
            if (query != null) {
                try {
                    qryString = query.toString();
                }
                catch (Exception e) {
                    qryString = "<exception>";
                }
            }
            log.debug((Object)String.format("%s init reader, startindex=%d maxfeatures=%d query %s", fs.getDataStore().toString(), this.startIndex, this.maxFeatures, qryString));
        }
    }

    public int getCount() throws IOException {
        if (this.totalCount != null) {
            return this.totalCount;
        }
        AxlGetFeatures r = new AxlGetFeatures();
        r.setLayer(new AxlLayerInfo(this.fs.getEntry().getTypeName()));
        try {
            this.buildAxlQuery(r);
        }
        catch (Exception e) {
            throw new IOException("Error processing filter: " + e.toString(), e);
        }
        r.setSkipfeatures(true);
        log.debug((Object)String.format("%s get feature count for layer %s", this.fs.getDataStore().toString(), r.getLayer().getId()));
        try {
            AxlFeatures resp = ((ArcIMSDataStore)this.fs.getDataStore()).getArcIMSServer().getFeatures(r);
            this.totalCount = resp.getFeatureCount().getCount();
            int countMax = this.totalCount;
            if (this.query.getStartIndex() != null) {
                countMax = Math.max(0, this.totalCount - this.query.getStartIndex());
            }
            if (this.maxFeatures != null) {
                countMax = Math.min(countMax, this.maxFeatures);
            }
            log.debug((Object)String.format("Total feature count for layer %s: %d (with start index and max features: %d)", r.getLayer().getId(), this.totalCount, countMax));
            return countMax;
        }
        catch (Exception e) {
            throw new IOException("Error retrieving feature count from ArcIMS: " + e.toString(), e);
        }
    }

    public int getTotalCount() throws IOException {
        if (this.totalCount == null) {
            this.getCount();
        }
        return this.totalCount;
    }

    private void buildAxlQuery(AxlGetFeatures gf) throws FilterToSQLException {
        AxlSpatialQuery aq = new AxlSpatialQuery();
        gf.setQuery(aq);
        if (this.query.getPropertyNames() != null && this.query.getPropertyNames().length > 0) {
            aq.setSubfields(Arrays.asList(this.query.getPropertyNames()));
        }
        if (this.query.getFilter() != null) {
            FilterToArcXMLSQL visitor = new FilterToArcXMLSQL(aq);
            visitor.setFeatureType(this.getFeatureType());
            String where = visitor.encodeToString(this.query.getFilter());
            if (where.trim().length() > 0 && !where.trim().equals("1=1")) {
                aq.setWhere(where);
            }
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.fs.getSchema();
    }

    private void performNewRequest() throws IOException {
        this.request = null;
        this.performRequest();
    }

    private void initBeforeRequest() throws IOException {
        if (this.initBeforeRequestDone) {
            return;
        }
        this.featureType = this.getFeatureType();
        this.builder = new SimpleFeatureBuilder(this.featureType);
        this.rowIdAttribute = this.fs.findRowIdAttribute();
        this.initBeforeRequestDone = true;
    }

    protected void performRequest() throws IOException {
        if (this.request != null) {
            return;
        }
        this.initBeforeRequest();
        this.request = new AxlGetFeatures();
        this.request.setLayer(new AxlLayerInfo(this.fs.getEntry().getTypeName()));
        try {
            this.buildAxlQuery(this.request);
        }
        catch (Exception e) {
            throw new IOException("Error processing filter: " + e.toString(), e);
        }
        if (this.maxFeatures != null) {
            this.request.setFeaturelimit(this.maxFeatures);
        }
        this.request.setBeginrecord(this.startIndex + 1);
        log.debug((Object)String.format("%s get features for layer %s, beginrecord=%d featurelimit=%d", this.fs.getDataStore().toString(), this.request.getLayer().getId(), this.request.getBeginrecord(), this.request.getFeaturelimit()));
        try {
            this.response = ((ArcIMSDataStore)this.fs.getDataStore()).getArcIMSServer().getFeatures(this.request);
        }
        catch (Exception e) {
            throw new IOException("Error retrieving features from ArcIMS: " + e.toString(), e);
        }
    }

    protected SimpleFeature buildFeature(AxlFeature axlf) throws IOException {
        String id = null;
        for (AxlField f : axlf.getFields()) {
            if (this.rowIdAttribute != null && this.rowIdAttribute.equals(f.getName())) {
                id = f.getValue();
            }
            if (!this.query.retrieveAllProperties() && (this.internedPropertyNames == null || Arrays.binarySearch(this.internedPropertyNames, f.getName().intern()) < 0)) continue;
            Class binding = null;
            try {
                binding = this.featureType.getType(f.getName()).getBinding();
                this.builder.set(f.getName(), f.getConvertedValue(binding, this.geometryFactory));
            }
            catch (Exception e) {
                throw new IOException(String.format("Error converting field \"%s\" value \"%s\" to type %s: %s", f.getName(), f.getValue(), binding, e.toString()), e);
            }
        }
        return this.builder.buildFeature(id);
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        this.performRequest();
        try {
            return this.buildFeature(this.response.getFeatures().get(this.index++));
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    public boolean hasNext() throws IOException {
        this.performRequest();
        if (this.response == null || this.response.getFeatures() == null || this.response.getFeatures().isEmpty()) {
            return false;
        }
        if (this.index < this.response.getFeatures().size()) {
            return true;
        }
        if (this.response.getFeatureCount().isHasmore()) {
            this.startIndex += this.response.getFeatures().size();
            this.index = 0;
            if (this.maxFeatures != null) {
                this.maxFeatures = this.maxFeatures - this.response.getFeatures().size();
                if (this.maxFeatures <= 0) {
                    return false;
                }
            }
            this.performNewRequest();
            return this.response.getFeatures() != null && !this.response.getFeatures().isEmpty();
        }
        return false;
    }

    public boolean hasMore() throws IOException {
        this.performRequest();
        return this.response.getFeatureCount().isHasmore();
    }

    public void close() throws IOException {
    }
}

