/*
 * Decompiled with CFR 0.152.
 */
package org.opensphere.geometry.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.triangulate.ConformingDelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeTriangle;
import org.locationtech.jts.triangulate.quadedge.Vertex;
import org.locationtech.jts.util.UniqueCoordinateArrayFilter;
import org.opensphere.geometry.triangulation.DoubleComparator;
import org.opensphere.geometry.triangulation.model.Edge;
import org.opensphere.geometry.triangulation.model.Triangle;

public class ConcaveHull {
    private GeometryFactory geomFactory;
    private GeometryCollection geometries;
    private double threshold;
    public HashMap<LineSegment, Integer> segments = new HashMap();
    public HashMap<Integer, Edge> edges = new HashMap();
    public HashMap<Integer, Triangle> triangles = new HashMap();
    public TreeMap<Integer, Edge> lengths = new TreeMap();
    public HashMap<Integer, Edge> shortLengths = new HashMap();
    public HashMap<Coordinate, Integer> coordinates = new HashMap();
    public HashMap<Integer, org.opensphere.geometry.triangulation.model.Vertex> vertices = new HashMap();

    public ConcaveHull(Geometry geometry, double threshold) {
        this.geometries = ConcaveHull.transformIntoPointGeometryCollection(geometry);
        this.threshold = threshold;
        this.geomFactory = geometry.getFactory();
    }

    public ConcaveHull(GeometryCollection geometries, double threshold) {
        this.geometries = ConcaveHull.transformIntoPointGeometryCollection(geometries);
        this.threshold = threshold;
        this.geomFactory = geometries.getFactory();
    }

    private static GeometryCollection transformIntoPointGeometryCollection(Geometry geom) {
        UniqueCoordinateArrayFilter filter = new UniqueCoordinateArrayFilter();
        geom.apply((CoordinateFilter)filter);
        Coordinate[] coord = filter.getCoordinates();
        Geometry[] geometries = new Geometry[coord.length];
        for (int i = 0; i < coord.length; ++i) {
            Coordinate[] c = new Coordinate[]{coord[i]};
            CoordinateArraySequence cs = new CoordinateArraySequence(c);
            geometries[i] = new Point((CoordinateSequence)cs, geom.getFactory());
        }
        return new GeometryCollection(geometries, geom.getFactory());
    }

    private static GeometryCollection transformIntoPointGeometryCollection(GeometryCollection gc) {
        UniqueCoordinateArrayFilter filter = new UniqueCoordinateArrayFilter();
        gc.apply((CoordinateFilter)filter);
        Coordinate[] coord = filter.getCoordinates();
        Geometry[] geometries = new Geometry[coord.length];
        for (int i = 0; i < coord.length; ++i) {
            Coordinate[] c = new Coordinate[]{coord[i]};
            CoordinateArraySequence cs = new CoordinateArraySequence(c);
            geometries[i] = new Point((CoordinateSequence)cs, gc.getFactory());
        }
        return new GeometryCollection(geometries, gc.getFactory());
    }

    public Geometry getConcaveHull() {
        if (this.geometries.getNumGeometries() == 0) {
            return this.geomFactory.createGeometryCollection(null);
        }
        if (this.geometries.getNumGeometries() == 1) {
            return this.geometries.getGeometryN(0);
        }
        if (this.geometries.getNumGeometries() == 2) {
            return this.geomFactory.createLineString(this.geometries.getCoordinates());
        }
        return this.concaveHull();
    }

    private Geometry concaveHull() {
        ConformingDelaunayTriangulationBuilder cdtb = new ConformingDelaunayTriangulationBuilder();
        cdtb.setSites((Geometry)this.geometries);
        QuadEdgeSubdivision qes = cdtb.getSubdivision();
        Collection quadEdges = qes.getEdges();
        List qeTriangles = QuadEdgeTriangle.createOn((QuadEdgeSubdivision)qes);
        Collection qeVertices = qes.getVertices(false);
        int iV = 0;
        for (Vertex v : qeVertices) {
            this.coordinates.put(v.getCoordinate(), iV);
            this.vertices.put(iV, new org.opensphere.geometry.triangulation.model.Vertex(iV, v.getCoordinate()));
            ++iV;
        }
        ArrayList<QuadEdge> qeFrameBorder = new ArrayList<QuadEdge>();
        ArrayList<QuadEdge> qeFrame = new ArrayList<QuadEdge>();
        ArrayList<QuadEdge> qeBorder = new ArrayList<QuadEdge>();
        for (QuadEdge quadEdge : quadEdges) {
            if (qes.isFrameBorderEdge(quadEdge)) {
                qeFrameBorder.add(quadEdge);
            }
            if (!qes.isFrameEdge(quadEdge)) continue;
            qeFrame.add(quadEdge);
        }
        for (int j = 0; j < qeFrameBorder.size(); ++j) {
            QuadEdge quadEdge = (QuadEdge)qeFrameBorder.get(j);
            if (qeFrame.contains(quadEdge)) continue;
            qeBorder.add(quadEdge);
        }
        for (QuadEdge quadEdge : qeFrame) {
            qes.delete(quadEdge);
        }
        HashMap<QuadEdge, Double> qeDistances = new HashMap<QuadEdge, Double>();
        for (QuadEdge qe : quadEdges) {
            qeDistances.put(qe, qe.toLineSegment().getLength());
        }
        DoubleComparator doubleComparator = new DoubleComparator(qeDistances);
        TreeMap<QuadEdge, Double> qeSorted = new TreeMap<QuadEdge, Double>(doubleComparator);
        qeSorted.putAll(qeDistances);
        int i = 0;
        for (QuadEdge qe : qeSorted.keySet()) {
            Edge edge;
            LineSegment s = qe.toLineSegment();
            s.normalize();
            Integer idS = this.coordinates.get(s.p0);
            Integer idD = this.coordinates.get(s.p1);
            org.opensphere.geometry.triangulation.model.Vertex oV = this.vertices.get(idS);
            org.opensphere.geometry.triangulation.model.Vertex eV = this.vertices.get(idD);
            if (qeBorder.contains(qe)) {
                oV.setBorder(true);
                eV.setBorder(true);
                edge = new Edge(i, s, oV, eV, true);
                if (s.getLength() < this.threshold) {
                    this.shortLengths.put(i, edge);
                } else {
                    this.lengths.put(i, edge);
                }
            } else {
                edge = new Edge(i, s, oV, eV, false);
            }
            this.edges.put(i, edge);
            this.segments.put(s, i);
            ++i;
        }
        i = 0;
        for (QuadEdgeTriangle qet : qeTriangles) {
            LineSegment sA = qet.getEdge(0).toLineSegment();
            LineSegment sB = qet.getEdge(1).toLineSegment();
            LineSegment sC = qet.getEdge(2).toLineSegment();
            sA.normalize();
            sB.normalize();
            sC.normalize();
            Edge edgeA = this.edges.get(this.segments.get(sA));
            Edge edgeB = this.edges.get(this.segments.get(sB));
            Edge edgeC = this.edges.get(this.segments.get(sC));
            Triangle triangle = new Triangle(i, qet.isBorder());
            triangle.addEdge(edgeA);
            triangle.addEdge(edgeB);
            triangle.addEdge(edgeC);
            edgeA.addTriangle(triangle);
            edgeB.addTriangle(triangle);
            edgeC.addTriangle(triangle);
            this.triangles.put(i, triangle);
            ++i;
        }
        for (Edge edge : this.edges.values()) {
            if (edge.getTriangles().size() == 1) continue;
            Triangle tA = edge.getTriangles().get(0);
            Triangle tB = edge.getTriangles().get(1);
            tA.addNeighbour(tB);
            tB.addNeighbour(tA);
        }
        int index = 0;
        while (index != -1) {
            index = -1;
            Edge e = null;
            int si = this.lengths.size();
            if (si != 0) {
                Map.Entry<Integer, Edge> entry = this.lengths.firstEntry();
                int ind = entry.getKey();
                if (entry.getValue().getGeometry().getLength() > this.threshold) {
                    index = ind;
                    e = entry.getValue();
                }
            }
            if (index == -1) continue;
            Triangle triangle = e.getTriangles().get(0);
            List<Triangle> neighbours = triangle.getNeighbours();
            if (neighbours.size() == 1) {
                this.shortLengths.put(e.getId(), e);
                this.lengths.remove(e.getId());
                continue;
            }
            Edge e0 = triangle.getEdges().get(0);
            Edge e1 = triangle.getEdges().get(1);
            if (e0.getOV().isBorder() && e0.getEV().isBorder() && e1.getOV().isBorder() && e1.getEV().isBorder()) {
                this.shortLengths.put(e.getId(), e);
                this.lengths.remove(e.getId());
                continue;
            }
            Triangle tA = neighbours.get(0);
            Triangle tB = neighbours.get(1);
            tA.setBorder(true);
            tB.setBorder(true);
            this.triangles.remove(triangle.getId());
            tA.removeNeighbour(triangle);
            tB.removeNeighbour(triangle);
            List<Edge> ee = triangle.getEdges();
            Edge eA = ee.get(0);
            Edge eB = ee.get(1);
            Edge eC = ee.get(2);
            if (eA.isBorder()) {
                this.edges.remove(eA.getId());
                eB.setBorder(true);
                eB.getOV().setBorder(true);
                eB.getEV().setBorder(true);
                eC.setBorder(true);
                eC.getOV().setBorder(true);
                eC.getEV().setBorder(true);
                eB.removeTriangle(triangle);
                eC.removeTriangle(triangle);
                if (eB.getGeometry().getLength() < this.threshold) {
                    this.shortLengths.put(eB.getId(), eB);
                } else {
                    this.lengths.put(eB.getId(), eB);
                }
                if (eC.getGeometry().getLength() < this.threshold) {
                    this.shortLengths.put(eC.getId(), eC);
                } else {
                    this.lengths.put(eC.getId(), eC);
                }
                this.lengths.remove(eA.getId());
                continue;
            }
            if (eB.isBorder()) {
                this.edges.remove(eB.getId());
                eA.setBorder(true);
                eA.getOV().setBorder(true);
                eA.getEV().setBorder(true);
                eC.setBorder(true);
                eC.getOV().setBorder(true);
                eC.getEV().setBorder(true);
                eA.removeTriangle(triangle);
                eC.removeTriangle(triangle);
                if (eA.getGeometry().getLength() < this.threshold) {
                    this.shortLengths.put(eA.getId(), eA);
                } else {
                    this.lengths.put(eA.getId(), eA);
                }
                if (eC.getGeometry().getLength() < this.threshold) {
                    this.shortLengths.put(eC.getId(), eC);
                } else {
                    this.lengths.put(eC.getId(), eC);
                }
                this.lengths.remove(eB.getId());
                continue;
            }
            this.edges.remove(eC.getId());
            eA.setBorder(true);
            eA.getOV().setBorder(true);
            eA.getEV().setBorder(true);
            eB.setBorder(true);
            eB.getOV().setBorder(true);
            eB.getEV().setBorder(true);
            eA.removeTriangle(triangle);
            eB.removeTriangle(triangle);
            if (eA.getGeometry().getLength() < this.threshold) {
                this.shortLengths.put(eA.getId(), eA);
            } else {
                this.lengths.put(eA.getId(), eA);
            }
            if (eB.getGeometry().getLength() < this.threshold) {
                this.shortLengths.put(eB.getId(), eB);
            } else {
                this.lengths.put(eB.getId(), eB);
            }
            this.lengths.remove(eC.getId());
        }
        ArrayList<LineString> edges = new ArrayList<LineString>();
        for (Edge e : this.lengths.values()) {
            LineString l = e.getGeometry().toGeometry(this.geomFactory);
            edges.add(l);
        }
        for (Edge e : this.shortLengths.values()) {
            LineString l = e.getGeometry().toGeometry(this.geomFactory);
            edges.add(l);
        }
        LineMerger lineMerger = new LineMerger();
        lineMerger.add(edges);
        LineString merge = (LineString)lineMerger.getMergedLineStrings().iterator().next();
        if (merge.isRing()) {
            LinearRing lr = new LinearRing(merge.getCoordinateSequence(), this.geomFactory);
            Polygon concaveHull = new Polygon(lr, null, this.geomFactory);
            return concaveHull;
        }
        return merge;
    }
}

