/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.arcgis;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.arcgis.ArcGISException;
import nl.b3p.geotools.data.arcgis.ArcGISFeatureSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.geotools.http.SimpleHttpClient;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ArcGISDataStore
extends ContentDataStore {
    private static final Log log = LogFactory.getLog(ArcGISDataStore.class);
    private URL url;
    private ServerType serverType;
    private CoordinateReferenceSystem crs;
    private List<Name> typeNames = null;
    private Map<String, JSONObject> layersById = new HashMap<String, JSONObject>();
    private HTTPClient client;
    private String currentVersion;
    private Integer currentMajorVersion;

    public ArcGISDataStore(URL url) {
        this(url, null, null, null, null, null, null, null);
    }

    public ArcGISDataStore(URL url, String user, String passwd, Integer timeout, Boolean gzip, CoordinateReferenceSystem crs, Object httpCache, String currentVersion) {
        String urlString;
        this.url = url;
        this.crs = crs;
        this.currentVersion = currentVersion;
        if (currentVersion != null) {
            try {
                this.currentMajorVersion = Integer.parseInt(currentVersion.split("\\.")[0]);
            }
            catch (Exception e) {
                log.warn((Object)String.format("Invalid currentVersion specified to ArcGISDataStore: \"%s\", will ask server instead", currentVersion));
                this.currentVersion = null;
            }
        }
        if ((urlString = url.toString()).endsWith("/MapServer")) {
            this.serverType = ServerType.MapServer;
        } else if (urlString.endsWith("/FeatureServer")) {
            this.serverType = ServerType.FeatureServer;
        } else {
            throw new IllegalArgumentException("URL must end in \"/MapServer\" or \"/FeatureServer\"");
        }
        if (urlString.indexOf("/rest/") == -1) {
            throw new IllegalArgumentException("URL must contain \"/rest/\"");
        }
        this.client = new SimpleHttpClient();
        this.client.setUser(user);
        this.client.setPassword(passwd);
        if (timeout != null) {
            this.client.setConnectTimeout(timeout.intValue());
            this.client.setReadTimeout(timeout.intValue());
        }
    }

    public String getCurrentVersion() throws IOException {
        if (this.currentVersion == null) {
            log.debug((Object)"Determining currentVersion of ArcGIS service to check for 9.x (to prevent this request, provide CURRENT_VERSION parameter to DataStore)");
            URL originalUrl = this.url;
            try {
                int i = originalUrl.toString().indexOf("/rest/services");
                String servicesUrl = originalUrl.toString().substring(0, i) + "/rest/services";
                this.url = new URL(servicesUrl);
                JSONObject servicesInfo = this.getServerJSONResponse("?f=json");
                Object vObject = servicesInfo.get((Object)"currentVersion");
                this.currentVersion = vObject.toString();
                this.currentMajorVersion = vObject instanceof Long && (Long)vObject >= 1000L ? Integer.valueOf(10) : Integer.valueOf(Integer.parseInt(this.currentVersion.split("\\.")[0]));
            }
            catch (Exception e) {
                throw new IOException("Error finding out the currentVersion of ArcGIS REST service at " + this.url.toString(), e);
            }
            finally {
                this.url = originalUrl;
            }
        }
        return this.currentVersion;
    }

    public int getCurrentMajorVersion() throws IOException {
        if (this.currentVersion == null) {
            this.getCurrentVersion();
        }
        return this.currentMajorVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getServerJSONResponse(String extraUrl) throws IOException {
        String requestUrl = this.url + (extraUrl.startsWith("/") ? "" : "/") + extraUrl;
        log.debug((Object)("request: " + requestUrl));
        HTTPResponse response = this.client.get(new URL(requestUrl));
        try {
            String json = IOUtils.toString((InputStream)response.getResponseStream(), (String)"UTF-8");
            JSONObject j = (JSONObject)JSONValue.parse((String)json);
            if (j == null) {
                int endIndex = Math.min(json.length(), 30);
                throw new IOException("ArcGIS server returned invalid JSON response: " + json.substring(0, endIndex));
            }
            if (j.containsKey((Object)"error")) {
                throw new ArcGISException(requestUrl, j);
            }
            JSONObject jSONObject = j;
            return jSONObject;
        }
        finally {
            response.dispose();
        }
    }

    public static String appendUrlParameters(String url, Map<String, String> params) {
        StringBuilder sb = new StringBuilder(url);
        if (!params.isEmpty()) {
            if (url.indexOf("?") == -1) {
                sb.append("?");
            } else {
                sb.append("&");
            }
            boolean first = true;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append("&");
                }
                try {
                    sb.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                    sb.append("=");
                    sb.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        return sb.toString();
    }

    public JSONObject getServerJSONResponse(String extraUrl, Map<String, String> params) throws IOException {
        return this.getServerJSONResponse(ArcGISDataStore.appendUrlParameters(extraUrl, params));
    }

    private JSONObject requestLayerJSON(String id) throws IOException {
        JSONObject layer = this.getServerJSONResponse(id + "?f=json");
        return layer;
    }

    public JSONObject getLayerJSON(String id) throws IOException {
        if (this.layersById.containsKey(id)) {
            if (this.getCurrentMajorVersion() > 9) {
                return this.layersById.get(id);
            }
            JSONObject layer = this.layersById.get(id);
            if (!layer.containsKey((Object)"type")) {
                layer = this.requestLayerJSON(id);
                this.layersById.put(id, layer);
            }
            return layer;
        }
        return this.requestLayerJSON(id);
    }

    private JSONObject checkLayerJSON(String id, JSONObject layer) throws IOException {
        String capabilities;
        if (this.getCurrentMajorVersion() > 9 && ((capabilities = (String)layer.get((Object)"capabilities")) == null || Arrays.asList(capabilities.split(",")).indexOf("Query") == -1)) {
            throw new IOException("ArcGIS layer " + id + " has no Query capabilities");
        }
        this.layersById.put(id, layer);
        return layer;
    }

    protected List<Name> createTypeNames() throws IOException {
        try {
            if (this.typeNames == null) {
                this.typeNames = new ArrayList<Name>();
                JSONObject info = this.getCurrentMajorVersion() >= 10 ? this.getServerJSONResponse("/layers?f=json") : this.getServerJSONResponse("?f=json");
                JSONArray layers = (JSONArray)info.get((Object)"layers");
                for (Object o : layers) {
                    String id;
                    JSONObject layer;
                    if (!(o instanceof JSONObject) || (layer = (JSONObject)o).get((Object)"id") == null || this.checkLayerJSON(id = layer.get((Object)"id").toString(), layer) == null) continue;
                    this.layersById.put(id, layer);
                    this.typeNames.add((Name)new NameImpl(id));
                }
            }
            return this.typeNames;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry ce) throws IOException {
        return new ArcGISFeatureSource(ce);
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public String toString() {
        return "ArcGISDataStore URL=" + this.url.toString();
    }

    private static enum ServerType {
        MapServer,
        FeatureServer;

    }
}

