/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.arcgis;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import nl.b3p.geotools.data.arcgis.ArcGISDataStore;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ArcGISDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param URL = new DataAccessFactory.Param("url", URL.class, "ArcGIS Server REST URL ending in /MapServer or /FeatureServer");
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param("user", String.class, "Username", false);
    public static final DataAccessFactory.Param PASSWD = new DataAccessFactory.Param("passwd", String.class, "Password", false);
    public static final DataAccessFactory.Param TIMEOUT = new DataAccessFactory.Param("timeout", Integer.class, "Timeout in ms; default 30000", false);
    public static final DataAccessFactory.Param TRY_GZIP = new DataAccessFactory.Param("try_gzip", Boolean.class, "Request server to use gzip compression", false);
    public static final DataAccessFactory.Param CRS = new DataAccessFactory.Param("crs", CoordinateReferenceSystem.class, "Coordinate reference system", false);
    public static final DataAccessFactory.Param AGS_ASSUME_VERSION = new DataAccessFactory.Param("ags_assume_version", String.class, "Assume this ArcGIS Server version (e.g. 10.x, 9.x)", false);

    public DataStore createDataStore(Map<String, ?> params) throws IOException {
        return this.createNewDataStore(params);
    }

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        return new ArcGISDataStore((URL)params.get(ArcGISDataStoreFactory.URL.key), (String)params.get(ArcGISDataStoreFactory.USER.key), (String)params.get(ArcGISDataStoreFactory.PASSWD.key), (Integer)params.get(ArcGISDataStoreFactory.TIMEOUT.key), (Boolean)params.get(ArcGISDataStoreFactory.TRY_GZIP.key), (CoordinateReferenceSystem)params.get(ArcGISDataStoreFactory.CRS.key), null, (String)params.get(ArcGISDataStoreFactory.AGS_ASSUME_VERSION.key));
    }

    public String getDescription() {
        return "ArcGIS Server REST data store";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{URL, USER, PASSWD, TIMEOUT, TRY_GZIP, CRS, AGS_ASSUME_VERSION};
    }

    public String getDisplayName() {
        return "ArcGISDataStore";
    }

    public boolean isAvailable() {
        return true;
    }
}

