/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.arcgis;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nl.b3p.geotools.data.arcgis.ArcGISUtils;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.IsNullImpl;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class FilterToArcGISSQL
extends FilterToSQL {
    protected Map spatialParams = new HashMap();
    boolean spatialOperatorAllowed = true;
    private static final Map<Class, String> spatialOperators;

    public FilterToArcGISSQL() {
        this(null);
    }

    public FilterToArcGISSQL(Writer w) {
        super(w);
        this.setInline(true);
    }

    public Map getSpatialParams() {
        return this.spatialParams;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = new FilterCapabilities();
        caps.addAll(FilterCapabilities.LOGICAL_OPENGIS);
        caps.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        caps.addType(IsNullImpl.class);
        caps.addType(PropertyIsBetween.class);
        caps.addType(PropertyIsLike.class);
        caps.addType(Id.class);
        for (Class clazz : spatialOperators.keySet()) {
            caps.addType(clazz);
        }
        caps.addType(16384L);
        return caps;
    }

    protected Object visit(BinaryLogicOperator filter, Object extraData) {
        String op = (String)extraData;
        boolean saveSpatialOpAllowed = this.spatialOperatorAllowed;
        if ("OR".equals(op)) {
            this.spatialOperatorAllowed = false;
        }
        Object r = super.visit(filter, extraData);
        this.spatialOperatorAllowed = saveSpatialOpAllowed;
        return r;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        if (!this.spatialParams.isEmpty()) {
            throw new RuntimeException("Only a single spatial operator is supported");
        }
        if (!this.spatialOperatorAllowed) {
            throw new RuntimeException("Spatial operator not allowed in this position in filter");
        }
        if (this.featureType != null && property.getPropertyName() != null && !this.featureType.getGeometryDescriptor().getLocalName().equals(property.getPropertyName())) {
            throw new RuntimeException("Spatial operator only supported on default geometry property");
        }
        Geometry geom = (Geometry)geometry.getValue();
        for (Map.Entry<Class, String> spatialOp : spatialOperators.entrySet()) {
            if (!spatialOp.getKey().isAssignableFrom(filter.getClass())) continue;
            this.spatialParams.put("spatialRel", spatialOp.getValue());
            break;
        }
        this.spatialParams.put("geometryType", ArcGISUtils.getGeometryType(geom));
        if (filter instanceof BBOX) {
            this.spatialParams.put("geometry", ArcGISUtils.convertToArcJSONEnvelope((Polygon)geom).toJSONString());
        } else if (filter instanceof DWithin) {
            Geometry buffered = geom.buffer(((DWithin)filter).getDistance());
            this.spatialParams.put("geometryType", ArcGISUtils.getGeometryType(buffered));
            this.spatialParams.put("geometry", ArcGISUtils.convertToArcJSONGeometry(buffered).toJSONString());
        } else {
            this.spatialParams.put("geometry", ArcGISUtils.convertToArcJSONGeometry(geom).toJSONString());
        }
        try {
            this.out.write("1 = 1");
        }
        catch (IOException ex) {
            throw new RuntimeException("io problem writing filter", ex);
        }
        return null;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        throw new RuntimeException("ArcGIS spatial operators only supported for default geometry and a literal operand");
    }

    static {
        HashMap<Class<DWithin>, String> sops = new HashMap<Class<DWithin>, String>();
        sops.put(Intersects.class, "esriSpatialRelIntersects");
        sops.put(Contains.class, "esriSpatialRelContains");
        sops.put(BBOX.class, "esriSpatialRelEnvelopeIntersects");
        sops.put(Overlaps.class, "esriSpatialRelOverlaps");
        sops.put(Touches.class, "esriSpatialRelTouches");
        sops.put(Within.class, "esriSpatialRelWithin");
        sops.put(DWithin.class, "esriSpatialRelIntersects");
        spatialOperators = Collections.unmodifiableMap(sops);
    }
}

