/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.app;

import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.Level;
import nl.b3p.viewer.config.app.StartLevel;
import nl.b3p.viewer.util.TestUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public class StartLevelTest
extends TestUtil {
    private static final Log log = LogFactory.getLog(StartLevelTest.class);

    @Test
    public void persistLevel() {
        StartLevel sl = new StartLevel();
        sl.setSelectedIndex(Integer.valueOf(16));
        this.persistEntityTest(sl, StartLevel.class, true);
        entityManager.refresh((Object)sl);
        StartLevel test = (StartLevel)entityManager.find(StartLevel.class, (Object)sl.getId());
        Assert.assertNotNull((Object)test);
        Assert.assertEquals((Object)new Integer(16), (Object)test.getSelectedIndex());
        Assert.assertEquals((long)6L, (long)entityManager.createQuery("FROM Level").getResultList().size());
    }

    @Test
    public void deleteStartLevel() throws URISyntaxException, SQLException, IOException {
        Application app = (Application)entityManager.find(Application.class, (Object)this.applicationId);
        Level level = (Level)entityManager.find(Level.class, (Object)5L);
        StartLevel sl = new StartLevel();
        sl.setLevel(level);
        sl.setApplication(app);
        sl.setSelectedIndex(Integer.valueOf(16));
        this.persistAndDeleteEntityTest(sl, StartLevel.class);
        Level levelExists = (Level)entityManager.find(Level.class, (Object)5L);
        Application appExists = (Application)entityManager.find(Application.class, (Object)this.applicationId);
        Assert.assertNotNull((Object)levelExists);
        Assert.assertNotNull((Object)appExists);
        Assert.assertEquals((long)6L, (long)entityManager.createQuery("FROM Level").getResultList().size());
    }

    @Test
    public void deleteLevel() throws URISyntaxException, SQLException, IOException {
        this.initData(false);
        Assert.assertNotNull((Object)this.testLevel);
        Assert.assertNotNull((Object)this.testStartLevel);
        long lid = this.testLevel.getId();
        Level l = (Level)entityManager.find(Level.class, (Object)lid);
        try {
            entityManager.remove((Object)l);
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            log.error((Object)"Fout", (Throwable)e);
        }
        entityManager.getTransaction().begin();
        Level shouldBeNull = (Level)entityManager.find(Level.class, (Object)lid);
        StartLevel startLevelShouldBeNull = (StartLevel)entityManager.find(StartLevel.class, (Object)this.testStartLevel.getId());
        Assert.assertNull((Object)shouldBeNull);
        Assert.assertNull((Object)startLevelShouldBeNull);
        objectsToRemove.add(this.app);
    }
}

