/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.ConfiguredComponent;
import nl.b3p.viewer.config.app.Level;
import nl.b3p.viewer.config.app.StartLayer;
import nl.b3p.viewer.config.app.StartLevel;
import nl.b3p.viewer.config.metadata.Metadata;
import nl.b3p.viewer.util.databaseupdate.ScriptRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class TestUtil {
    protected static EntityManager entityManager;
    private static boolean testdataLoaded;
    protected static int TEST_VERSION_NUMBER;
    public Long applicationId = 1L;
    public static String originalVersion;
    public ApplicationLayer testAppLayer;
    public Level testLevel;
    public StartLayer testStartLayer;
    public StartLevel testStartLevel;
    public ConfiguredComponent testComponent;
    public Application app;
    protected static List<Object> objectsToRemove;
    private static final Log log;

    @BeforeClass
    public static void createEntityManager() {
        String persistenceUnit = System.getProperty("test.persistence.unit");
        entityManager = Persistence.createEntityManagerFactory((String)persistenceUnit).createEntityManager();
    }

    @Before
    public void setUp() throws Exception {
        if (!entityManager.getTransaction().isActive()) {
            entityManager.getTransaction().begin();
        }
        this.loadTestData();
        if (!entityManager.getTransaction().isActive()) {
            entityManager.getTransaction().begin();
        }
    }

    @AfterClass
    public static void close() throws Exception {
        if (entityManager.isOpen()) {
            entityManager.close();
        }
    }

    @After
    public void closeTransaction() {
        if (entityManager.getTransaction().isActive()) {
            entityManager.getTransaction().commit();
        }
    }

    @After
    public void stuffToRemove() {
        block4: {
            for (Object obj : objectsToRemove) {
                log.debug((Object)("Removing obj" + obj.toString()));
                if (!entityManager.contains(obj)) continue;
                entityManager.remove(obj);
            }
            if (!entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().begin();
            }
            try {
                entityManager.getTransaction().commit();
                objectsToRemove = new ArrayList<Object>();
            }
            catch (Exception e) {
                log.error((Object)"Error committing transaction: ", (Throwable)e);
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public <T> void persistEntityTest(T entity, Class<T> clazz, boolean removeLater) {
        entityManager.persist(entity);
        entityManager.getTransaction().commit();
        entityManager.getTransaction().begin();
        if (removeLater) {
            objectsToRemove.add(entity);
        }
    }

    public <T> void persistAndDeleteEntityTest(T entity, Class<T> clazz) {
        this.persistEntityTest(entity, clazz, false);
        entityManager.remove(entity);
        entityManager.getTransaction().commit();
        entityManager.getTransaction().begin();
    }

    public void loadTestData() throws URISyntaxException, IOException, SQLException {
        if (testdataLoaded) {
            return;
        }
        Application app = (Application)entityManager.find(Application.class, (Object)this.applicationId);
        if (app == null) {
            InputStreamReader f = new InputStreamReader(TestUtil.class.getResourceAsStream("testdata.sql"));
            this.executeScript(f);
            testdataLoaded = true;
        }
        Metadata version = (Metadata)entityManager.createQuery("From Metadata where configKey = :v", Metadata.class).setParameter("v", (Object)"database_version").getSingleResult();
        originalVersion = version.getConfigValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeScript(Reader f) throws IOException, SQLException {
        try (Connection conn = null;){
            Session session = (Session)entityManager.getDelegate();
            conn = session.connection();
            ScriptRunner sr = new ScriptRunner(conn, true, true);
            sr.runScript(f);
            conn.commit();
            entityManager.flush();
        }
    }

    public void initData(boolean deleteAfterwards) {
        this.app = new Application();
        this.app.setName("testapp");
        this.app.setVersion("154");
        this.persistEntityTest(this.app, Application.class, deleteAfterwards);
        this.testLevel = new Level();
        this.testLevel.setName("testLevel");
        this.app.setRoot(this.testLevel);
        entityManager.persist((Object)this.app);
        this.persistEntityTest(this.testLevel, Level.class, false);
        this.testAppLayer = new ApplicationLayer();
        this.testAppLayer.setLayerName("testApplayer");
        this.testLevel.getLayers().add(this.testAppLayer);
        this.persistEntityTest(this.testAppLayer, ApplicationLayer.class, false);
        this.testStartLayer = new StartLayer();
        this.testStartLayer.setApplicationLayer(this.testAppLayer);
        this.testStartLayer.setApplication(this.app);
        this.testStartLayer.setSelectedIndex(Integer.valueOf(16));
        this.app.getStartLayers().add(this.testStartLayer);
        this.testAppLayer.getStartLayers().put(this.app, this.testStartLayer);
        this.testStartLevel = new StartLevel();
        this.testStartLevel.setApplication(this.app);
        this.testStartLevel.setLevel(this.testLevel);
        this.testStartLevel.setSelectedIndex(Integer.valueOf(9));
        this.testLevel.getStartLevels().put(this.app, this.testStartLevel);
        this.app.getStartLevels().add(this.testStartLevel);
        this.persistEntityTest(this.testStartLevel, StartLevel.class, false);
        entityManager.persist((Object)this.testAppLayer);
        entityManager.persist((Object)this.app);
        this.persistEntityTest(this.testStartLayer, StartLayer.class, false);
        this.testComponent = new ConfiguredComponent();
        this.testComponent.setApplication(this.app);
        this.testComponent.setClassName("viewer.components.Bookmark");
        this.testComponent.setConfig("{value: 'aapnootmies'}");
        this.testComponent.setName("testClassName1");
        this.app.getComponents().add(this.testComponent);
        this.persistEntityTest(this.testComponent, ConfiguredComponent.class, false);
        entityManager.getTransaction().commit();
        entityManager.getTransaction().begin();
    }

    static {
        testdataLoaded = false;
        TEST_VERSION_NUMBER = 666;
        originalVersion = null;
        objectsToRemove = new ArrayList<Object>();
        log = LogFactory.getLog(TestUtil.class);
    }
}

