/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.app;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import net.sourceforge.stripes.action.ActionBeanContext;
import nl.b3p.viewer.config.app.Application;
import org.hibernate.annotations.Type;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"code", "application"})})
public class Bookmark {
    @Id
    private Long id;
    private String code;
    @Lob
    @Basic(optional=false)
    @Type(type="org.hibernate.type.StringClobType")
    private String params;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdAt;
    private String createdBy;
    @ManyToOne(fetch=FetchType.LAZY)
    private Application application;

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Bookmark clone() {
        Bookmark clone = new Bookmark();
        clone.setCode(this.code);
        clone.setCreatedAt(new Date());
        clone.setParams(this.params);
        return clone;
    }

    public static String createCreatedBy(ActionBeanContext context) {
        String createdBy = "IP: " + context.getRequest().getRemoteAddr();
        if (context.getRequest().getHeader("x-forwarded-for") != null) {
            createdBy = "IP: " + context.getRequest().getHeader("x-forwarded-for") + "(proxy " + createdBy + ")";
        }
        if (context.getRequest().getRemoteUser() != null) {
            createdBy = createdBy + ", user: " + context.getRequest().getRemoteUser();
        }
        return createdBy;
    }
}

