/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.app;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.StartLevel;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.Document;
import org.apache.commons.beanutils.BeanUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Type;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
@Table(name="level_")
public class Level
implements Comparable {
    @Id
    private Long id;
    @ManyToOne
    private Level parent;
    @Basic(optional=false)
    private String name;
    private Integer selectedIndex;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="level_children", inverseJoinColumns={@JoinColumn(name="child")})
    @OrderColumn(name="list_index")
    private List<Level> children = new ArrayList<Level>();
    private boolean background;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="level_layers", inverseJoinColumns={@JoinColumn(name="layer")})
    @OrderColumn(name="list_index")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private List<ApplicationLayer> layers = new ArrayList<ApplicationLayer>();
    @ManyToMany
    @JoinTable(name="level_documents", inverseJoinColumns={@JoinColumn(name="document")})
    @OrderColumn(name="list_index")
    private List<Document> documents = new ArrayList<Document>();
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String info;
    @ElementCollection
    @JoinTable(joinColumns={@JoinColumn(name="level_")})
    @Column(name="role_name")
    private Set<String> readers = new HashSet<String>();
    private String url;
    @OneToMany(mappedBy="level", orphanRemoval=true, cascade={CascadeType.ALL})
    @MapKey(name="application")
    private Map<Application, StartLevel> startLevels = new HashMap<Application, StartLevel>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(Integer selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    public List<Level> getChildren() {
        return this.children;
    }

    public void setChildren(List<Level> children) {
        this.children = children;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public List<ApplicationLayer> getLayers() {
        return this.layers;
    }

    public void setLayers(List<ApplicationLayer> layers) {
        this.layers = layers;
    }

    public Level getParent() {
        return this.parent;
    }

    public void setParent(Level parent) {
        this.parent = parent;
    }

    public Set<String> getReaders() {
        return this.readers;
    }

    public void setReaders(Set<String> readers) {
        this.readers = readers;
    }

    public boolean isBackground() {
        return this.background;
    }

    public void setBackground(boolean background) {
        this.background = background;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<Application, StartLevel> getStartLevels() {
        return this.startLevels;
    }

    public void setStartLevels(Map<Application, StartLevel> startLevels) {
        this.startLevels = startLevels;
    }

    public JSONObject toJSONObject(boolean includeChildrenIds, Application app, HttpServletRequest request, EntityManager em) throws JSONException {
        JSONObject o = new JSONObject();
        o.put("id", (Object)this.id);
        o.put("name", (Object)this.name);
        o.put("selectedIndex", (Object)this.selectedIndex);
        o.put("background", this.background);
        o.put("info", (Object)this.info);
        o.put("url", (Object)this.url);
        if (!this.documents.isEmpty()) {
            JSONArray docs = new JSONArray();
            o.put("documents", (Object)docs);
            for (Document document : this.documents) {
                docs.put((Object)document.toJSONObject());
            }
        }
        if (!this.layers.isEmpty()) {
            JSONArray ls = new JSONArray();
            o.put("layers", (Object)ls);
            for (ApplicationLayer applicationLayer : this.layers) {
                if (request != null && !Authorizations.isAppLayerReadAuthorized(app, applicationLayer, request, em)) continue;
                ls.put((Object)applicationLayer.getId().toString());
            }
        }
        if (includeChildrenIds && !this.children.isEmpty()) {
            JSONArray cs = new JSONArray();
            o.put("children", (Object)cs);
            for (Level level : this.children) {
                if (request != null && !Authorizations.isLevelReadAuthorized(app, level, request, em)) continue;
                cs.put((Object)level.getId().toString());
            }
        }
        return o;
    }

    public Set<Application> findApplications(EntityManager em) {
        Level l = this;
        while (l.getParent() != null) {
            l = l.getParent();
        }
        HashSet<Application> apps = new HashSet<Application>();
        apps.addAll(em.createQuery("from Application where root = :level").setParameter("level", (Object)l).getResultList());
        return apps;
    }

    public String getPath() {
        Level l = this;
        String s = "";
        do {
            s = l.getName() + (s.length() == 0 ? "" : "/" + s);
        } while ((l = l.getParent()) != null);
        return s;
    }

    public Level getParentInSubtree(ApplicationLayer appLayer) {
        for (ApplicationLayer al : this.layers) {
            if (!al.equals(appLayer)) continue;
            return this;
        }
        for (Level child : this.children) {
            Level parent = child.getParentInSubtree(appLayer);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    public Level getParentInSubtree(Level level) {
        for (Level child : this.children) {
            if (child.equals(level)) {
                return this;
            }
            Level parent = child.getParentInSubtree(level);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    public boolean containsLayerInSubtree(ApplicationLayer appLayer) {
        return this.getParentInSubtree(appLayer) != null;
    }

    public boolean containsLevelInSubtree(Level level) {
        return this.getParentInSubtree(level) != null;
    }

    public boolean isInSubtreeOf(Level level) {
        Level parentLevel = this.parent;
        do {
            if (!parentLevel.equals(level)) continue;
            return true;
        } while ((parentLevel = parentLevel.getParent()) != null);
        return false;
    }

    public void processForMashup(Application app) throws Exception {
        for (Level child : this.children) {
            child.processForMashup(app);
        }
        for (ApplicationLayer layer : this.layers) {
            layer.processStartLayers(app, layer);
        }
        this.processStartLevels(app, this);
    }

    private void processStartLevels(Application app, Level original) throws Exception {
        ArrayList<StartLevel> sls = new ArrayList<StartLevel>(original.startLevels.values());
        for (int i = 0; i < sls.size(); ++i) {
            StartLevel value = (StartLevel)sls.get(i);
            this.getStartLevels().put(app, value.deepCopy(app, this));
        }
    }

    Level deepCopy(Level parent, Map originalToCopy, Application app) throws Exception {
        Level copy = (Level)BeanUtils.cloneBean((Object)this);
        originalToCopy.put(this, copy);
        copy.setId(null);
        copy.setParent(parent);
        copy.setChildren(new ArrayList<Level>());
        for (Level child : this.children) {
            copy.getChildren().add(child.deepCopy(copy, originalToCopy, app));
        }
        copy.setLayers(new ArrayList<ApplicationLayer>());
        for (ApplicationLayer appLayer : this.layers) {
            copy.getLayers().add(appLayer.deepCopy(originalToCopy, app));
        }
        copy.setStartLevels(new HashMap<Application, StartLevel>());
        copy.processStartLevels(app, this);
        copy.setDocuments(new ArrayList<Document>(this.documents));
        copy.setReaders(new HashSet<String>(this.readers));
        copy.setInfo(this.info);
        copy.setUrl(this.url);
        return copy;
    }

    public String toString() {
        return String.format("Level [id=%d, name=%s, parent=%d]", this.id, this.name, this.parent == null ? null : this.parent.getId());
    }

    public int compareTo(Object o) {
        Level rhs = (Level)o;
        return this.getName().compareTo(rhs.getName());
    }
}

