/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Transient;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.RemoveEmptyMapValuesUtil;
import nl.b3p.viewer.config.services.ArcGISFeatureSource;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.BoundingBox;
import nl.b3p.viewer.config.services.CoordinateReferenceSystem;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.Updatable;
import nl.b3p.viewer.config.services.UpdateResult;
import nl.b3p.web.WaitPageStatus;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.SimpleHttpClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@Entity
@DiscriminatorValue(value="arcgis")
public class ArcGISService
extends GeoService
implements Updatable {
    private static final Log log = LogFactory.getLog(ArcGISService.class);
    public static final String PROTOCOL = "arcgis";
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_ASSUME_VERSION = "assumeVersion";
    public static final String DETAIL_CURRENT_VERSION = "arcgis_currentVersion";
    public static final String DETAIL_ASSUME_VERSION = "arcgis_assumeVersion";
    public static final String DETAIL_TYPE = "arcgis_type";
    public static final String DETAIL_DESCRIPTION = "arcgis_description";
    public static final String DETAIL_GEOMETRY_TYPE = "arcgis_geometryType";
    public static final String DETAIL_CAPABILITIES = "arcgis_capabilities";
    public static final String DETAIL_DEFAULT_VISIBILITY = "arcgis_defaultVisibility";
    public static final String DETAIL_DEFINITION_EXPRESSION = "arcgis_definitionExpression";
    private static final String TOPLAYER_ID = "-1";
    public static final Set<String> NON_VIRTUAL_LAYER_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Feature Layer", "Raster Layer", "Annotation Layer")));
    private static Set<String> additionalUpdatableDetails = new HashSet<String>(Arrays.asList("arcgis_type", "arcgis_description", "arcgis_geometryType", "arcgis_capabilities", "arcgis_defaultVisibility", "arcgis_definitionExpression", "arcgis_currentVersion"));
    @Transient
    private JSONObject serviceInfo;
    @Transient
    private String currentVersion;
    @Transient
    private int currentVersionMajor;
    @Transient
    private SortedMap<String, Layer> layersById;
    @Transient
    private Map<String, List<String>> childrenByLayerId;

    private static JSONObject issueRequest(String url, HTTPClient client) throws Exception {
        return new JSONObject(IOUtils.toString((InputStream)client.get(new URL(url)).getResponseStream(), (String)"UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArcGISService loadFromUrl(String url, Map params, WaitPageStatus status, EntityManager em) throws Exception {
        try {
            status.setCurrentAction("Ophalen informatie...");
            if (!url.endsWith("/MapServer")) {
                throw new IllegalArgumentException("URL moet eindigen in \"/MapServer\"");
            }
            if (url.indexOf("/rest/services") == -1) {
                throw new IllegalArgumentException("URL moet \"/rest/\" bevatten");
            }
            SimpleHttpClient client = new SimpleHttpClient();
            client.setUser((String)params.get(PARAM_USERNAME));
            client.setPassword((String)params.get(PARAM_PASSWORD));
            ArcGISService s = new ArcGISService();
            s.setUrl(url);
            s.loadServiceInfo((HTTPClient)client, (String)params.get(PARAM_ASSUME_VERSION));
            if (Boolean.TRUE.equals(params.get("onlineCheckOnly"))) {
                ArcGISService arcGISService = null;
                return arcGISService;
            }
            int i = url.lastIndexOf("/MapServer");
            String temp = url.substring(0, i);
            i = temp.lastIndexOf("/");
            String name = temp.substring(i + 1);
            s.setName(name);
            s.load((HTTPClient)client, status, em);
            ArcGISService arcGISService = s;
            return arcGISService;
        }
        finally {
            status.setProgress(100);
            status.setCurrentAction("Service ingeladen");
            status.setFinished(true);
        }
    }

    private void loadServiceInfo(HTTPClient client, String assumeVersion) throws Exception {
        if ("9.x".equals(assumeVersion)) {
            this.currentVersion = "9.x";
            this.currentVersionMajor = 9;
            this.getDetails().put(DETAIL_ASSUME_VERSION, new ClobElement("9.x"));
        } else if ("10.x".equals(assumeVersion)) {
            this.currentVersion = "10.x";
            this.currentVersionMajor = 10;
            this.getDetails().put(DETAIL_ASSUME_VERSION, new ClobElement("10.x"));
        } else {
            int i = this.getUrl().indexOf("/rest/services");
            String servicesUrl = this.getUrl().substring(0, i) + "/rest/services";
            this.serviceInfo = ArcGISService.issueRequest(servicesUrl + "?f=json", client);
            this.currentVersion = this.serviceInfo.getString("currentVersion");
            this.currentVersionMajor = Integer.parseInt(this.currentVersion.split("\\.")[0]);
        }
        this.serviceInfo = this.currentVersionMajor >= 10 ? ArcGISService.issueRequest(this.getUrl() + "/layers?f=json", client) : ArcGISService.issueRequest(this.getUrl() + "?f=json", client);
        this.getDetails().put(DETAIL_CURRENT_VERSION, new ClobElement(this.currentVersion));
    }

    private void load(HTTPClient client, WaitPageStatus status, EntityManager em) throws Exception {
        int layerCount = this.serviceInfo.getJSONArray("layers").length();
        status.setProgress((int)Math.round(100.0 / (double)(layerCount + 1)));
        status.setCurrentAction("Inladen layers...");
        ArcGISFeatureSource fs = new ArcGISFeatureSource();
        fs.setLinkedService(this);
        fs.setUrl(this.getUrl());
        fs.setUsername(client.getUser());
        fs.setPassword(client.getPassword());
        Layer top = new Layer();
        top.setVirtual(true);
        top.setName(TOPLAYER_ID);
        top.setTitle(this.getName());
        top.setService(this);
        this.setTopLayer(top);
        this.layersById = new TreeMap<String, Layer>();
        this.childrenByLayerId = new HashMap<String, List<String>>();
        this.layersById.put(top.getName(), top);
        if (this.currentVersionMajor >= 10) {
            JSONArray layers = this.serviceInfo.getJSONArray("layers");
            for (int i = 0; i < layers.length(); ++i) {
                JSONObject layer = layers.getJSONObject(i);
                Layer l = this.parseArcGISLayer(layer, this, fs, this.childrenByLayerId);
                this.layersById.put(l.getName(), l);
            }
        } else {
            JSONArray layers = this.serviceInfo.getJSONArray("layers");
            for (int i = 0; i < layers.length(); ++i) {
                JSONObject layer = layers.getJSONObject(i);
                String id = layer.getString("id");
                status.setCurrentAction("Inladen laag \"" + layer.optString("name", id) + "\"");
                layer = ArcGISService.issueRequest(this.getUrl() + "/" + id + "?f=json", client);
                Layer l = this.parseArcGISLayer(layer, this, fs, this.childrenByLayerId);
                this.layersById.put(l.getName(), l);
                status.setProgress((int)Math.round(100.0 / (double)(layerCount + 1) * (double)i + 2.0));
            }
        }
        ArcGISService.setLayerTree(this.getTopLayer(), this.layersById, this.childrenByLayerId, em);
        ArcGISService.setAllChildrenDetail(this.getTopLayer(), em);
        if (!fs.getFeatureTypes().isEmpty()) {
            fs.setName(this.getName());
        }
    }

    private static void setLayerTree(Layer topLayer, Map<String, Layer> layersById, Map<String, List<String>> childrenByLayerId, EntityManager em) {
        topLayer.getChildren().clear();
        em.flush();
        for (Layer l : layersById.values()) {
            List<String> childrenIds = childrenByLayerId.get(l.getName());
            if (childrenIds == null) continue;
            for (String childId : childrenIds) {
                Layer child = layersById.get(childId);
                if (child == null) continue;
                l.getChildren().add(child);
                child.setParent(l);
            }
        }
        for (Layer l : layersById.values()) {
            if (l.getParent() != null || TOPLAYER_ID.equals(l.getName())) continue;
            topLayer.getChildren().add(l);
            l.setParent(topLayer);
        }
        Collections.sort(topLayer.getChildren(), new Comparator<Layer>(){

            @Override
            public int compare(Layer lhs, Layer rhs) {
                return lhs.getName().compareTo(rhs.getName());
            }
        });
    }

    private Layer parseArcGISLayer(JSONObject agsl, GeoService service, ArcGISFeatureSource fs, Map<String, List<String>> childrenByLayerId) throws JSONException {
        JSONArray fields;
        Layer l = new Layer();
        l.setService(service);
        l.setName(agsl.getString("id"));
        l.setTitle(agsl.getString("name"));
        JSONArray subLayerIds = agsl.optJSONArray("subLayers");
        if (subLayerIds != null) {
            ArrayList<String> childrenIds = new ArrayList<String>();
            for (int i = 0; i < subLayerIds.length(); ++i) {
                JSONObject subLayer = subLayerIds.getJSONObject(i);
                String subLayerId = subLayer.getInt("id") + "";
                childrenIds.add(subLayerId);
            }
            childrenByLayerId.put(l.getName(), childrenIds);
        }
        l.getDetails().put(DETAIL_TYPE, new ClobElement(agsl.getString("type")));
        l.getDetails().put(DETAIL_CURRENT_VERSION, new ClobElement(agsl.optString("currentVersion", this.currentVersion)));
        l.getDetails().put(DETAIL_DESCRIPTION, new ClobElement((String)StringUtils.defaultIfBlank((CharSequence)agsl.getString("description"), null)));
        l.getDetails().put(DETAIL_GEOMETRY_TYPE, new ClobElement(agsl.getString("geometryType")));
        l.getDetails().put(DETAIL_CAPABILITIES, new ClobElement(agsl.optString("capabilities")));
        l.getDetails().put(DETAIL_DEFAULT_VISIBILITY, new ClobElement(agsl.optBoolean("defaultVisibility", false) ? "true" : "false"));
        l.getDetails().put(DETAIL_DEFINITION_EXPRESSION, new ClobElement((String)StringUtils.defaultIfBlank((CharSequence)agsl.optString("definitionExpression"), null)));
        RemoveEmptyMapValuesUtil.removeEmptyMapValues(l.getDetails());
        try {
            l.setMinScale(agsl.getDouble("minScale"));
            l.setMaxScale(agsl.getDouble("maxScale"));
        }
        catch (JSONException childrenIds) {
            // empty catch block
        }
        try {
            JSONObject extent = agsl.getJSONObject("extent");
            BoundingBox bbox = new BoundingBox();
            bbox.setMinx(extent.getDouble("xmin"));
            bbox.setMaxx(extent.getDouble("xmax"));
            bbox.setMiny(extent.getDouble("ymin"));
            bbox.setMaxy(extent.getDouble("ymax"));
            bbox.setCrs(new CoordinateReferenceSystem("EPSG:" + extent.getJSONObject("spatialReference").getInt("wkid")));
            l.getBoundingBoxes().put(bbox.getCrs(), bbox);
        }
        catch (JSONException extent) {
            // empty catch block
        }
        boolean hasFields = false;
        if (!agsl.isNull("fields") && (fields = agsl.getJSONArray("fields")).length() > 0) {
            SimpleFeatureType sft = new SimpleFeatureType();
            sft.setFeatureSource(fs);
            sft.setTypeName(l.getName());
            sft.setDescription(l.getTitle());
            sft.setWriteable(false);
            for (int i = 0; i < fields.length(); ++i) {
                JSONObject field = fields.getJSONObject(i);
                AttributeDescriptor att = new AttributeDescriptor();
                sft.getAttributes().add(att);
                att.setName(field.getString("name"));
                att.setAlias(field.getString("alias"));
                String et = field.getString("type");
                String type = "string";
                if ("esriFieldTypeOID".equals(et)) {
                    type = "integer";
                } else if ("esriFieldTypeGeometry".equals(et)) {
                    String gtype;
                    if (sft.getGeometryAttribute() == null) {
                        sft.setGeometryAttribute(att.getName());
                    }
                    type = "esriGeometryPoint".equals(gtype = agsl.getString("geometryType")) ? "point" : ("esriGeometryMultipoint".equals(gtype) ? "multipoint" : ("esriGeometryLine".equals(gtype) || "esriGeometryPolyline".equals(gtype) ? "linestring" : ("esriGeometryPolygon".equals(gtype) ? "polygon" : "geometry")));
                } else if ("esriFieldTypeDouble".equals(et)) {
                    type = "double";
                } else if ("esriFieldTypeInteger".equals(et) || "esriFieldTypeSmallInteger".equals(et)) {
                    type = "integer";
                } else if ("esriFieldTypeDate".equals(et)) {
                    type = "date";
                }
                att.setType(type);
            }
            fs.getFeatureTypes().add(sft);
            l.setFeatureType(sft);
            hasFields = true;
        }
        l.setQueryable(hasFields);
        l.setFilterable(hasFields);
        l.setVirtual(!NON_VIRTUAL_LAYER_TYPES.contains(l.getDetails().get(DETAIL_TYPE).getValue()));
        return l;
    }

    @Override
    public UpdateResult update(EntityManager em) {
        this.initLayerCollectionsForUpdate();
        UpdateResult result = new UpdateResult(this, em);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(PARAM_USERNAME, this.getUsername());
            params.put(PARAM_PASSWORD, this.getPassword());
            ArcGISService update = this.loadFromUrl(this.getUrl(), params, result.getWaitPageStatus().subtask("", 80.0f), em);
            this.getDetails().put(DETAIL_CURRENT_VERSION, update.getDetails().get(DETAIL_CURRENT_VERSION));
            this.getTopLayer().getDetails().remove(DETAIL_CURRENT_VERSION);
            this.getTopLayer().setName(TOPLAYER_ID);
            result.getLayerStatus().put(this.getTopLayer().getName(), (MutablePair<Layer, UpdateResult.Status>)new MutablePair((Object)this.getTopLayer(), (Object)UpdateResult.Status.UNMODIFIED));
            ArcGISFeatureSource linkedFS = null;
            try {
                linkedFS = (ArcGISFeatureSource)Stripersist.getEntityManager().createQuery("from FeatureSource where linkedService = :this").setParameter("this", (Object)this).getSingleResult();
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
            this.updateLayers(update, linkedFS, result, em);
            this.removeOrphanLayersAfterUpdate(result);
            if (linkedFS != null && linkedFS.getFeatureTypes().isEmpty()) {
                log.debug((Object)"Linked ArcGISFeatureSource has no type names anymore, removing it");
                Stripersist.getEntityManager().remove((Object)linkedFS);
            }
            result.setStatus(UpdateResult.Status.UPDATED);
        }
        catch (Exception e) {
            result.failedWithException(e);
        }
        return result;
    }

    private void updateLayers(ArcGISService update, ArcGISFeatureSource linkedFS, UpdateResult result, EntityManager em) {
        HashMap<String, Layer> updatedLayersById = new HashMap<String, Layer>();
        for (Layer updateLayer : update.layersById.values()) {
            SimpleFeatureType ft;
            MutablePair layerStatus = (MutablePair)result.getLayerStatus().get(updateLayer.getName());
            Layer updatedLayer = null;
            if (layerStatus == null) {
                ft = updateLayer.getFeatureType();
                if (updateLayer.getFeatureType() != null) {
                    if (linkedFS != null) {
                        updateLayer.setFeatureType(linkedFS.addOrUpdateFeatureType(updateLayer.getName(), ft, new MutableBoolean()));
                    } else {
                        ft.getFeatureSource().setLinkedService(this);
                    }
                }
                result.getLayerStatus().put(updateLayer.getName(), (MutablePair<Layer, UpdateResult.Status>)new MutablePair((Object)updateLayer, (Object)UpdateResult.Status.NEW));
                updatedLayer = updateLayer;
            } else {
                assert (layerStatus.getRight() == UpdateResult.Status.MISSING);
                Layer old = (Layer)layerStatus.getLeft();
                old.setParent(null);
                old.update(updateLayer, additionalUpdatableDetails);
                layerStatus.setRight((Object)UpdateResult.Status.UNMODIFIED);
                if (old.getFeatureType() == null || old.getFeatureType().getFeatureSource().getLinkedService() == this) {
                    if (updateLayer.getFeatureType() == null) {
                        if (old.getFeatureType() != null) {
                            layerStatus.setRight((Object)UpdateResult.Status.UPDATED);
                        }
                        old.setFeatureType(null);
                    } else {
                        if (linkedFS != null) {
                            MutableBoolean updated = new MutableBoolean(false);
                            ft = linkedFS.addOrUpdateFeatureType(updateLayer.getName(), updateLayer.getFeatureType(), updated);
                            if (old.getFeatureType() == null || updated.isTrue()) {
                                layerStatus.setRight((Object)UpdateResult.Status.UPDATED);
                            }
                        } else {
                            ft = updateLayer.getFeatureType();
                            ft.getFeatureSource().setLinkedService(this);
                            layerStatus.setRight((Object)UpdateResult.Status.UPDATED);
                        }
                        old.setFeatureType(ft);
                    }
                }
                updatedLayer = old;
            }
            updatedLayer.getChildren().clear();
            updatedLayer.setParent(null);
            updatedLayer.setService(this);
            updatedLayersById.put(updateLayer.getName(), updatedLayer);
        }
        ArcGISService.setLayerTree(this.getTopLayer(), updatedLayersById, update.childrenByLayerId, em);
    }

    private void removeOrphanLayersAfterUpdate(UpdateResult result) {
        assert (result.getDuplicateOrNoNameLayers().size() == 1);
        assert (result.getDuplicateOrNoNameLayers().get(0) == this.getTopLayer());
        HashSet<Layer> layerFeatureTypesToRemove = new HashSet<Layer>();
        for (Pair pair : result.getLayerStatus().values()) {
            if (pair.getRight() != UpdateResult.Status.MISSING) continue;
            Layer removed = (Layer)pair.getLeft();
            if (removed.getFeatureType() != null && removed.getFeatureType().getFeatureSource().getLinkedService().equals(removed.getService())) {
                layerFeatureTypesToRemove.add(removed);
            }
            Stripersist.getEntityManager().remove((Object)removed);
        }
        for (Layer layer : layerFeatureTypesToRemove) {
            SimpleFeatureType ft = layer.getFeatureType();
            Stripersist.getEntityManager().createQuery("update ConfiguredAttribute set featureType = null where featureType = :ft").setParameter("ft", (Object)ft).executeUpdate();
            Stripersist.getEntityManager().createQuery("update Layer set featureType = null where featureType = :ft").setParameter("ft", (Object)ft).executeUpdate();
            Stripersist.getEntityManager().createQuery("update LayarSource set featureType = null where featureType = :ft").setParameter("ft", (Object)ft).executeUpdate();
            Stripersist.getEntityManager().createQuery("update SolrConf set simpleFeatureType = null where simpleFeatureType = :ft").setParameter("ft", (Object)ft).executeUpdate();
            Stripersist.getEntityManager().createQuery("update FeatureTypeRelation set foreignFeatureType = null where foreignFeatureType = :ft").setParameter("ft", (Object)ft).executeUpdate();
            layer.getFeatureType().getFeatureSource().removeFeatureType(layer.getFeatureType());
        }
    }

    public String getCurrentVersion() {
        String cv;
        ClobElement ce = this.getDetails().get(DETAIL_CURRENT_VERSION);
        String string = cv = ce != null ? ce.getValue() : null;
        if (cv == null && this.getTopLayer() != null) {
            ce = this.getTopLayer().getDetails().get(DETAIL_CURRENT_VERSION);
            String string2 = cv = ce != null ? ce.getValue() : null;
            if (cv == null && !this.getTopLayer().getChildren().isEmpty()) {
                ce = this.getTopLayer().getChildren().get(0).getDetails().get(DETAIL_CURRENT_VERSION);
                cv = ce != null ? ce.getValue() : null;
            }
        }
        return cv;
    }

    @Override
    public JSONObject toJSONObject(boolean flatten, Set<String> layersToInclude, boolean validXmlTags, EntityManager em) throws JSONException {
        return this.toJSONObject(validXmlTags, layersToInclude, validXmlTags, false, em);
    }

    @Override
    public JSONObject toJSONObject(boolean flatten, Set<String> layersToInclude, boolean validXmlTags, boolean includeAuthorizations, EntityManager em) throws JSONException {
        JSONObject o = super.toJSONObject(flatten, layersToInclude, validXmlTags, includeAuthorizations, em);
        JSONObject json = new JSONObject();
        o.put("arcGISVersion", (Object)json);
        json.put("s", (Object)"9.x");
        json.put("major", 9L);
        json.put("number", 9.0);
        String cv = this.getCurrentVersion();
        if (cv != null) {
            json.put("s", (Object)cv);
            try {
                String[] parts = cv.split("\\.");
                json.put("major", Integer.parseInt(parts[0]));
                json.put("number", Double.parseDouble(cv));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return o;
    }

    @Override
    public JSONObject toJSONObject(boolean flatten, EntityManager em) throws JSONException {
        return this.toJSONObject(flatten, null, false, em);
    }
}

