/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import nl.b3p.geotools.data.arcims.ArcIMSServer;
import nl.b3p.geotools.data.arcims.axl.AxlFieldInfo;
import nl.b3p.geotools.data.arcims.axl.AxlLayerInfo;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.services.ArcXMLFeatureSource;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.Updatable;
import nl.b3p.viewer.config.services.UpdateResult;
import nl.b3p.web.WaitPageStatus;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.ServiceInfo;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.SimpleHttpClient;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@Entity
@DiscriminatorValue(value="arcims")
public class ArcIMSService
extends GeoService
implements Updatable {
    private static final Log log = LogFactory.getLog(ArcIMSService.class);
    public static final String PROTOCOL = "arcims";
    public static final String PARAM_SERVICENAME = "ServiceName";
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_PASSWORD = "password";
    private static final String TOPLAYER_ID = "-1";
    @Basic
    private String serviceName;

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public void checkOnline(EntityManager em) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("onlineCheckOnly", Boolean.TRUE);
        if (this.getServiceName() != null) {
            params.put(PARAM_SERVICENAME, this.getServiceName());
        }
        this.loadFromUrl(this.getUrl(), params, new WaitPageStatus(){

            public void setCurrentAction(String currentAction) {
                this.currentAction.set(currentAction);
            }

            public void addLog(String message) {
                this.logs.add(message);
            }
        }, em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArcIMSService loadFromUrl(String url, Map params, WaitPageStatus status, EntityManager em) throws Exception {
        try {
            status.setCurrentAction("Ophalen informatie...");
            ArcIMSService ims = new ArcIMSService();
            ims.setUsername((String)params.get(PARAM_USERNAME));
            ims.setPassword((String)params.get(PARAM_PASSWORD));
            SimpleHttpClient client = new SimpleHttpClient();
            client.setUser(ims.getUsername());
            client.setPassword(ims.getPassword());
            this.serviceName = (String)params.get(PARAM_SERVICENAME);
            ArcIMSServer gtims = new ArcIMSServer(new URL(url), this.serviceName, (HTTPClient)client);
            if (Boolean.TRUE.equals(params.get("onlineCheckOnly"))) {
                ArcIMSService arcIMSService = null;
                return arcIMSService;
            }
            ServiceInfo si = gtims.getInfo();
            ims.setName(si.getTitle());
            ims.setServiceName(gtims.getServiceName());
            ims.setUrl(url);
            status.setProgress(50);
            status.setCurrentAction("Inladen layers...");
            ArcXMLFeatureSource fs = new ArcXMLFeatureSource();
            fs.setLinkedService(ims);
            fs.setName(ims.getName());
            fs.setServiceName(ims.getServiceName());
            fs.setUsername(ims.getUsername());
            fs.setPassword(ims.getPassword());
            fs.setUrl(url);
            Layer top = new Layer();
            top.setVirtual(true);
            top.setTitle("Layers");
            top.setService(ims);
            for (AxlLayerInfo axlLayerInfo : gtims.getAxlServiceInfo().getLayers()) {
                top.getChildren().add(this.parseAxlLayerInfo(axlLayerInfo, ims, fs, top));
            }
            ims.setTopLayer(top);
            ArcIMSService arcIMSService = ims;
            return arcIMSService;
        }
        finally {
            status.setCurrentAction("");
            status.setProgress(100);
            status.setFinished(true);
        }
    }

    private Layer parseAxlLayerInfo(AxlLayerInfo axl, GeoService service, ArcXMLFeatureSource fs, Layer parent) {
        Layer l = new Layer();
        l.setParent(parent);
        l.setService(service);
        l.setFilterable("featureclass".equals(axl.getType()));
        l.setQueryable(true);
        l.setName(axl.getId());
        l.setTitle(axl.getName());
        l.getDetails().put("axl_type", new ClobElement(axl.getType()));
        String s = axl.getMinscale();
        if (s != null) {
            try {
                l.setMinScale(Double.parseDouble(s.replace(',', '.')));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((s = axl.getMaxscale()) != null) {
            try {
                l.setMaxScale(Double.parseDouble(s.replace(',', '.')));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (axl.getFclass() != null) {
            SimpleFeatureType sft = new SimpleFeatureType();
            sft.setFeatureSource(fs);
            sft.setTypeName(axl.getId());
            sft.setWriteable(false);
            sft.setDescription(axl.getName());
            for (AxlFieldInfo axlField : axl.getFclass().getFields()) {
                String type;
                AttributeDescriptor att = new AttributeDescriptor();
                sft.getAttributes().add(att);
                att.setName(axlField.getName());
                switch (axlField.getType()) {
                    case -98: {
                        if (sft.getGeometryAttribute() == null) {
                            sft.setGeometryAttribute(att.getName());
                        }
                        type = "geometry";
                        break;
                    }
                    case -7: {
                        type = "boolean";
                        break;
                    }
                    case -99: 
                    case -5: 
                    case 4: 
                    case 5: {
                        type = "integer";
                        break;
                    }
                    case 6: 
                    case 8: {
                        type = "double";
                        break;
                    }
                    case 91: {
                        type = "date";
                        break;
                    }
                    default: {
                        type = "string";
                    }
                }
                att.setType(type);
            }
            fs.getFeatureTypes().add(sft);
            l.setFeatureType(sft);
        }
        return l;
    }

    @Override
    public UpdateResult update(EntityManager em) {
        this.initLayerCollectionsForUpdate();
        UpdateResult result = new UpdateResult(this, em);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(PARAM_USERNAME, this.getUsername());
            params.put(PARAM_PASSWORD, this.getPassword());
            if (this.getServiceName() != null) {
                params.put(PARAM_SERVICENAME, this.getServiceName());
            }
            ArcIMSService update = this.loadFromUrl(this.getUrl(), params, result.getWaitPageStatus().subtask("", 80.0f), em);
            ArcXMLFeatureSource linkedFS = null;
            try {
                linkedFS = (ArcXMLFeatureSource)Stripersist.getEntityManager().createQuery("from FeatureSource where linkedService = :this").setParameter("this", (Object)this).getSingleResult();
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
            this.updateLayers(update, linkedFS, result);
            this.removeOrphanLayersAfterUpdate(result);
            if (linkedFS != null && linkedFS.getFeatureTypes().isEmpty()) {
                log.debug((Object)"Linked ArcGISFeatureSource has no type names anymore, removing it");
                Stripersist.getEntityManager().remove((Object)linkedFS);
            }
            result.setStatus(UpdateResult.Status.UPDATED);
        }
        catch (Exception e) {
            result.failedWithException(e);
        }
        return result;
    }

    private void updateLayers(ArcIMSService update, ArcXMLFeatureSource linkedFS, UpdateResult result) {
        this.getTopLayer().getChildren().clear();
        for (Layer updateLayer : update.getTopLayer().getChildren()) {
            Layer updatedLayer;
            SimpleFeatureType ft;
            MutablePair layerStatus = (MutablePair)result.getLayerStatus().get(updateLayer.getName());
            if (layerStatus == null) {
                ft = updateLayer.getFeatureType();
                if (updateLayer.getFeatureType() != null) {
                    if (linkedFS != null) {
                        linkedFS.addOrUpdateFeatureType(updateLayer.getName(), ft, new MutableBoolean());
                    } else {
                        ft.getFeatureSource().setLinkedService(this);
                    }
                }
                result.getLayerStatus().put(updateLayer.getName(), (MutablePair<Layer, UpdateResult.Status>)new MutablePair((Object)updateLayer, (Object)UpdateResult.Status.NEW));
                updatedLayer = updateLayer;
            } else {
                assert (layerStatus.getRight() == UpdateResult.Status.MISSING);
                Layer old = (Layer)layerStatus.getLeft();
                old.update(updateLayer);
                layerStatus.setRight((Object)UpdateResult.Status.UNMODIFIED);
                if (old.getFeatureType() == null || old.getFeatureType().getFeatureSource().getLinkedService() == this) {
                    if (updateLayer.getFeatureType() == null) {
                        if (old.getFeatureType() != null) {
                            layerStatus.setRight((Object)UpdateResult.Status.UPDATED);
                        }
                        old.setFeatureType(null);
                    } else {
                        if (linkedFS != null) {
                            MutableBoolean updated = new MutableBoolean(false);
                            ft = linkedFS.addOrUpdateFeatureType(updateLayer.getName(), updateLayer.getFeatureType(), updated);
                            if (old.getFeatureType() == null || updated.isTrue()) {
                                layerStatus.setRight((Object)UpdateResult.Status.UPDATED);
                            }
                        } else {
                            ft = updateLayer.getFeatureType();
                            ft.getFeatureSource().setLinkedService(this);
                            layerStatus.setRight((Object)UpdateResult.Status.UPDATED);
                        }
                        old.setFeatureType(ft);
                    }
                }
                updatedLayer = old;
            }
            assert (updatedLayer.getChildren().isEmpty());
            updatedLayer.setService(this);
            updatedLayer.setParent(this.getTopLayer());
            this.getTopLayer().getChildren().add(updatedLayer);
        }
    }

    private void removeOrphanLayersAfterUpdate(UpdateResult result) {
        assert (result.getDuplicateOrNoNameLayers().size() == 1);
        assert (result.getDuplicateOrNoNameLayers().get(0) == this.getTopLayer());
        for (Pair pair : result.getLayerStatus().values()) {
            if (pair.getRight() != UpdateResult.Status.MISSING) continue;
            Layer removed = (Layer)pair.getLeft();
            if (removed.getFeatureType() != null) {
                removed.getFeatureType().getFeatureSource().removeFeatureType(removed.getFeatureType());
            }
            Stripersist.getEntityManager().remove((Object)removed);
        }
    }

    @Override
    public JSONObject toJSONObject(boolean flatten, Set<String> layersToInclude, boolean validXmlTags, EntityManager em) throws JSONException {
        return this.toJSONObject(flatten, layersToInclude, validXmlTags, false, em);
    }

    @Override
    public JSONObject toJSONObject(boolean flatten, Set<String> layersToInclude, boolean validXmlTags, boolean includeAuthorizations, EntityManager em) throws JSONException {
        JSONObject o = super.toJSONObject(flatten, layersToInclude, validXmlTags, includeAuthorizations, em);
        if (this.serviceName != null) {
            o.put("serviceName", (Object)this.serviceName);
        }
        return o;
    }

    @Override
    public JSONObject toJSONObject(boolean flatten, EntityManager em) throws JSONException {
        return this.toJSONObject(flatten, null, false, em);
    }
}

