/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.NoResultException;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.PreRemove;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.Category;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.StyleLibrary;
import nl.b3p.viewer.config.services.WMSExceptionType;
import nl.b3p.viewer.config.services.WMSService;
import nl.b3p.web.WaitPageStatus;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@Entity
@DiscriminatorColumn(name="protocol")
public abstract class GeoService {
    public static final String PARAM_ONLINE_CHECK_ONLY = "onlineCheckOnly";
    public static final String PARAM_MUST_LOGIN = "mustLogin";
    public static final String DETAIL_OVERRIDDEN_URL = "overridenUrl";
    public static final String DETAIL_ORIGINAL_NAME = "originalName";
    public static final String DETAIL_USE_INTERSECT = "useIntersect";
    public static final String DETAIL_USE_PROXY = "useProxy";
    @Id
    private Long id;
    @Basic(optional=false)
    private String name;
    @ManyToOne(fetch=FetchType.LAZY)
    private Category category;
    @Basic(optional=false)
    private String url;
    private String username;
    private String password;
    private boolean monitoringEnabled;
    private boolean monitoringStatusOK = true;
    @OneToOne(cascade={CascadeType.PERSIST})
    private Layer topLayer;
    @ElementCollection
    @Column(name="keyword")
    private Set<String> keywords = new HashSet<String>();
    @Transient
    private List<Layer> layers;
    @Transient
    private Map<Layer, List<Layer>> childrenByParent = null;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date authorizationsModified = new Date();
    @ElementCollection
    @JoinTable(joinColumns={@JoinColumn(name="geoservice")})
    private Map<String, ClobElement> details = new HashMap<String, ClobElement>();
    @OneToMany(cascade={CascadeType.PERSIST})
    @JoinTable(inverseJoinColumns={@JoinColumn(name="style_library")})
    @OrderColumn(name="list_index")
    private List<StyleLibrary> styleLibraries = new ArrayList<StyleLibrary>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public Layer getTopLayer() {
        return this.topLayer;
    }

    public void setTopLayer(Layer topLayer) {
        this.topLayer = topLayer;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Set<String> keywords) {
        this.keywords = keywords;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public void setMonitoringEnabled(boolean monitoringEnabled) {
        this.monitoringEnabled = monitoringEnabled;
    }

    public Date getAuthorizationsModified() {
        return this.authorizationsModified;
    }

    public void setAuthorizationsModified(Date authorizationsModified) {
        this.authorizationsModified = authorizationsModified;
    }

    public boolean isMonitoringStatusOK() {
        return this.monitoringStatusOK;
    }

    public void setMonitoringStatusOK(boolean monitoringStatusOK) {
        this.monitoringStatusOK = monitoringStatusOK;
    }

    public Map<String, ClobElement> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, ClobElement> details) {
        this.details = details;
    }

    public List<StyleLibrary> getStyleLibraries() {
        return this.styleLibraries;
    }

    public void setStyleLibraries(List<StyleLibrary> styleLibraries) {
        this.styleLibraries = styleLibraries;
    }

    @PreRemove
    public void removeAllLayers() {
        EntityManager em = Stripersist.getEntityManager();
        List allLayers = em.createQuery("from Layer where service = :this").setParameter("this", (Object)this).getResultList();
        for (Layer l : allLayers) {
            l.getChildren().clear();
            em.remove((Object)l);
        }
    }

    public void initLayerCollectionsForUpdate() {
        EntityManager em = Stripersist.getEntityManager();
        em.createQuery("from Layer l left join fetch l.crsList where l.service = :this").setParameter("this", (Object)this).getResultList();
        em.createQuery("from Layer l left join fetch l.boundingBoxes where l.service = :this").setParameter("this", (Object)this).getResultList();
        em.createQuery("from Layer l left join fetch l.keywords where l.service = :this").setParameter("this", (Object)this).getResultList();
        em.createQuery("from Layer l left join fetch l.details where l.service = :this").setParameter("this", (Object)this).getResultList();
        em.createQuery("from Layer l left join fetch l.children where l.service = :this").setParameter("this", (Object)this).getResultList();
    }

    public GeoService loadFromUrl(String url, Map params, EntityManager em) throws Exception {
        return this.loadFromUrl(url, params, new WaitPageStatus(), em);
    }

    public abstract GeoService loadFromUrl(String var1, Map var2, WaitPageStatus var3, EntityManager var4) throws Exception;

    protected static void setAllChildrenDetail(Layer layer, EntityManager em) {
        layer.accept(new Layer.Visitor(){

            @Override
            public boolean visit(final Layer l, EntityManager em) {
                if (!l.getChildren().isEmpty()) {
                    final MutableObject layerNames = new MutableObject(new ArrayList());
                    l.accept(new Layer.Visitor(){

                        @Override
                        public boolean visit(Layer child, EntityManager em) {
                            if (child != l && child.getChildren().isEmpty() && !child.isVirtual()) {
                                ((List)layerNames.getValue()).add(child.getName());
                            }
                            return true;
                        }
                    }, em);
                    if (!((List)layerNames.getValue()).isEmpty()) {
                        l.getDetails().put("all_children", new ClobElement(StringUtils.join((Iterable)((Iterable)layerNames.getValue()), (String)",")));
                        l.setVirtual(false);
                    }
                }
                return true;
            }
        }, em);
    }

    public void checkOnline(EntityManager em) throws Exception {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put(PARAM_ONLINE_CHECK_ONLY, Boolean.TRUE);
        this.loadFromUrl(this.getUrl(), params, new WaitPageStatus(){

            public void setCurrentAction(String currentAction) {
                this.currentAction.set(currentAction);
            }

            public void addLog(String message) {
                this.logs.add(message);
            }
        }, em);
    }

    public String getProtocol() {
        return this.getClass().getAnnotation(DiscriminatorValue.class).value();
    }

    public void authorizationsModified() {
        this.authorizationsModified = new Date();
    }

    public List<Layer> loadLayerTree(EntityManager em) {
        if (this.layers != null) {
            return this.layers;
        }
        if (!em.contains((Object)this)) {
            return Collections.EMPTY_LIST;
        }
        this.layers = em.createNamedQuery("getLayerTree").setParameter("rootId", (Object)this.topLayer.getId()).getResultList();
        this.childrenByParent = new HashMap<Layer, List<Layer>>();
        for (Layer l : this.layers) {
            if (l.getParent() == null) continue;
            List<Layer> parentChildren = this.childrenByParent.get(l.getParent());
            if (parentChildren == null) {
                parentChildren = new ArrayList<Layer>();
                this.childrenByParent.put(l.getParent(), parentChildren);
            }
            parentChildren.add(l);
        }
        return this.layers;
    }

    public List<Layer> getLayerChildrenCache(Layer l, EntityManager em) {
        if (this.childrenByParent != null) {
            if (!em.getEntityManagerFactory().getPersistenceUnitUtil().isLoaded(l.getChildren())) {
                List<Layer> childrenList = this.childrenByParent.get(l);
                if (childrenList == null) {
                    return Collections.EMPTY_LIST;
                }
                return childrenList;
            }
            return l.getChildren();
        }
        return l.getChildren();
    }

    public JSONObject toJSONObject(boolean includeLayerTree, Set<String> layersToInclude, boolean validXmlTags, EntityManager em) throws JSONException {
        return this.toJSONObject(includeLayerTree, layersToInclude, validXmlTags, false, em);
    }

    public JSONObject toJSONObject(boolean includeLayerTree, Set<String> layersToInclude, boolean validXmlTags, boolean includeAuthorizations, EntityManager em) throws JSONException {
        JSONObject o = new JSONObject();
        o.put("id", (Object)this.id);
        o.put("name", (Object)this.name);
        o.put("url", (Object)this.url);
        o.put("protocol", (Object)this.getProtocol());
        if (this.details.containsKey(DETAIL_USE_PROXY)) {
            ClobElement ce = this.details.get(DETAIL_USE_PROXY);
            boolean useProxy = Boolean.parseBoolean(ce.getValue());
            o.put(DETAIL_USE_PROXY, useProxy);
            if (this.getPassword() != null && this.getUsername() != null) {
                o.put(PARAM_MUST_LOGIN, true);
            }
        } else {
            o.put(DETAIL_USE_PROXY, false);
        }
        if (this instanceof WMSService) {
            WMSExceptionType extype = ((WMSService)this).getException_type() != null ? ((WMSService)this).getException_type() : WMSExceptionType.Inimage;
            o.put("exception_type", (Object)extype.getDescription());
        }
        if (!validXmlTags) {
            JSONObject jStyleLibraries = new JSONObject();
            for (StyleLibrary sld : this.getStyleLibraries()) {
                JSONObject jsld = new JSONObject();
                String styleName = sld.getId().toString();
                jStyleLibraries.put("sld:" + styleName, (Object)jsld);
                jsld.put("id", (Object)sld.getId());
                jsld.put("title", (Object)sld.getTitle());
                jsld.put("default", sld.isDefaultStyle());
                if (sld.isDefaultStyle()) {
                    o.put("defaultStyleLibrary", (Object)jsld);
                }
                if (sld.getExternalUrl() != null) {
                    jsld.put("externalUrl", (Object)sld.getExternalUrl());
                }
                JSONObject userStylesPerNamedLayer = new JSONObject();
                if (sld.getNamedLayerUserStylesJson() != null) {
                    userStylesPerNamedLayer = new JSONObject(sld.getNamedLayerUserStylesJson());
                }
                jsld.put("userStylesPerNamedLayer", (Object)userStylesPerNamedLayer);
                if (sld.getExtraLegendParameters() != null) {
                    jsld.put("extraLegendParameters", (Object)sld.getExtraLegendParameters());
                }
                jsld.put("hasBody", sld.getExternalUrl() == null);
            }
            o.put("styleLibraries", (Object)jStyleLibraries);
        }
        if (this.topLayer != null) {
            List<Layer> layerEntities;
            if (em.contains((Object)this) && !(layerEntities = this.loadLayerTree(em)).isEmpty()) {
                List<Layer> subList;
                int i = 0;
                do {
                    subList = layerEntities.subList(i, Math.min(layerEntities.size(), i + 500));
                    em.createQuery("from Layer l left join fetch l.details where l in (:layers)").setParameter("layers", subList).getResultList();
                } while ((i += subList.size()) < layerEntities.size());
            }
            JSONObject layers = new JSONObject();
            o.put("layers", (Object)layers);
            GeoService.walkLayerJSONFlatten(this.topLayer, layers, layersToInclude, validXmlTags, includeAuthorizations, em);
            if (includeLayerTree) {
                o.put("topLayer", (Object)GeoService.walkLayerJSONTree(this.topLayer, em));
            }
        }
        return o;
    }

    private static void walkLayerJSONFlatten(Layer l, JSONObject layers, Set<String> layersToInclude, boolean validXmlTags, boolean includeAuthorizations, EntityManager em) throws JSONException {
        if (!(layersToInclude != null && !layersToInclude.contains(l.getName()) || l.isVirtual() || l.getName() == null || layers.has(l.getName()))) {
            String name = l.getName();
            if (validXmlTags) {
                name = "layer" + layers.length();
            }
            JSONObject layer = l.toJSONObject();
            if (includeAuthorizations) {
                Authorizations.ReadWrite rw = Authorizations.getLayerAuthorizations(l, em);
                layer.put("authorizations", (Object)(rw != null ? rw.toJSON() : new JSONObject()));
            }
            layers.put(name, (Object)layer);
        }
        for (Layer child : l.getCachedChildren(em)) {
            GeoService.walkLayerJSONFlatten(child, layers, layersToInclude, validXmlTags, includeAuthorizations, em);
        }
    }

    private static JSONObject walkLayerJSONTree(Layer l, EntityManager em) throws JSONException {
        JSONObject j = l.toJSONObject();
        List<Layer> children = l.getCachedChildren(em);
        if (!children.isEmpty()) {
            JSONArray jc = new JSONArray();
            j.put("children", (Object)jc);
            for (Layer child : children) {
                jc.put((Object)GeoService.walkLayerJSONTree(child, em));
            }
        }
        return j;
    }

    public JSONObject toJSONObject(boolean includeLayerTree, EntityManager em) throws JSONException {
        return this.toJSONObject(includeLayerTree, null, false, false, em);
    }

    public Layer getSingleLayer(String layerName) {
        try {
            return (Layer)Stripersist.getEntityManager().createQuery("from Layer where service = :service and name = :n order by virtual desc").setParameter("service", (Object)this).setParameter("n", (Object)layerName).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    public Layer getLayer(final String layerName, EntityManager em) {
        this.loadLayerTree(em);
        if (layerName == null || this.topLayer == null) {
            return null;
        }
        final MutableObject layer = new MutableObject(null);
        this.topLayer.accept(new Layer.Visitor(){

            @Override
            public boolean visit(Layer l, EntityManager em) {
                if (StringUtils.equals((CharSequence)l.getName(), (CharSequence)layerName)) {
                    layer.setValue((Object)l);
                    return false;
                }
                return true;
            }
        }, em);
        return (Layer)layer.getValue();
    }
}

