/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.UpdatableFeatureSource;
import nl.b3p.web.WaitPageStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;

@Entity
@DiscriminatorValue(value="jdbc")
public class JDBCFeatureSource
extends UpdatableFeatureSource {
    private static final Log log = LogFactory.getLog(JDBCFeatureSource.class);
    public static final String PROTOCOL = "jdbc";
    @Column(name="db_schema")
    private String schema;

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public JDBCFeatureSource() {
    }

    public JDBCFeatureSource(Map params) throws JSONException {
        JSONObject urlObj = new JSONObject();
        urlObj.put("dbtype", params.get("dbtype"));
        urlObj.put("host", params.get("host"));
        urlObj.put("port", params.get("port"));
        urlObj.put("database", params.get("database"));
        this.setUrl(urlObj.toString());
        this.schema = (String)params.get("schema");
        this.setUsername((String)params.get("user"));
        this.setPassword((String)params.get("passwd"));
    }

    public void loadFeatureTypes() throws Exception {
        this.loadFeatureTypes(new WaitPageStatus());
    }

    public void loadFeatureTypes(WaitPageStatus status) throws Exception {
        this.getFeatureTypes().addAll(this.createFeatureTypes(status));
    }

    public List<SimpleFeatureType> createFeatureTypes() throws Exception {
        return this.createFeatureTypes(new WaitPageStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SimpleFeatureType> createFeatureTypes(WaitPageStatus status) throws Exception {
        status.setCurrentAction("Databaseverbinding maken...");
        ArrayList<SimpleFeatureType> createdFeatureTypes = new ArrayList<SimpleFeatureType>();
        DataStore store = null;
        try {
            store = this.createDataStore();
            status.setProgress(10);
            status.setCurrentAction("Lijst van tabellen met geo-informatie ophalen...");
            String[] typeNames = store.getTypeNames();
            status.setProgress(20);
            if (typeNames.length != 0) {
                double progress = 20.0;
                double progressPerTypeName = 80.0 / (double)typeNames.length;
                for (String typeName : typeNames) {
                    status.setCurrentAction("Inladen schema van tabel \"" + typeName + "\"...");
                    log.debug((Object)("Loading feature source " + typeName + " for JDBCFeatureSource " + this.getName()));
                    SimpleFeatureSource gtFs = store.getFeatureSource(typeName);
                    SimpleFeatureType sft = new SimpleFeatureType();
                    sft.setTypeName(typeName);
                    sft.setFeatureSource(this);
                    sft.setWriteable(true);
                    if (gtFs.getInfo() != null) {
                        sft.setDescription(gtFs.getInfo().getDescription());
                    }
                    org.opengis.feature.simple.SimpleFeatureType gtFt = (org.opengis.feature.simple.SimpleFeatureType)gtFs.getSchema();
                    for (org.opengis.feature.type.AttributeDescriptor gtAtt : gtFt.getAttributeDescriptors()) {
                        AttributeDescriptor att = new AttributeDescriptor();
                        sft.getAttributes().add(att);
                        att.setName(gtAtt.getLocalName());
                        AttributeType gtType = gtAtt.getType();
                        String binding = gtType.getBinding().getName();
                        String type = "";
                        if (binding.equals("com.vividsolutions.jts.geom.MultiPolygon")) {
                            type = "multipolygon";
                        } else if (binding.equals("com.vividsolutions.jts.geom.Polygon")) {
                            type = "polygon";
                        } else if (binding.equals("com.vividsolutions.jts.geom.Geometry")) {
                            type = "geometry";
                        } else if (binding.equals("com.vividsolutions.jts.geom.LineString")) {
                            type = "linestring";
                        } else if (binding.equals("com.vividsolutions.jts.geom.Point")) {
                            type = "point";
                        } else if (binding.equals("com.vividsolutions.jts.geom.MultiLineString")) {
                            type = "multilinestring";
                        } else if (binding.equals("com.vividsolutions.jts.geom.MultiPoint")) {
                            type = "multipoint";
                        } else if (binding.equals("java.lang.Boolean")) {
                            type = "boolean";
                        } else if (binding.equals("java.lang.Long")) {
                            type = "integer";
                        } else if (binding.equals("java.lang.String")) {
                            type = "string";
                        } else if (binding.equals("java.lang.Integer")) {
                            type = "integer";
                        } else if (binding.equals("java.lang.Short")) {
                            type = "integer";
                        } else if (binding.equals("java.lang.Double")) {
                            type = "double";
                        } else if (binding.equals("java.lang.Float")) {
                            type = "double";
                        } else if (binding.equals("java.sql.Timestamp")) {
                            type = "timestamp";
                        } else if (binding.equals("java.sql.Date")) {
                            type = "date";
                        } else if (binding.equals("java.math.BigDecimal")) {
                            type = "double";
                        }
                        if (sft.getGeometryAttribute() == null && gtType instanceof GeometryType) {
                            sft.setGeometryAttribute(att.getName());
                        }
                        att.setType(type);
                    }
                    createdFeatureTypes.add(sft);
                    status.setProgress((int)(progress += progressPerTypeName));
                }
            }
        }
        finally {
            status.setProgress(100);
            status.setCurrentAction("Databasegegevens ingeladen");
            status.setFinished(true);
            if (store != null) {
                store.dispose();
            }
        }
        return createdFeatureTypes;
    }

    public DataStore createDataStore() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONObject urlObj = new JSONObject(this.getUrl());
        params.put("dbtype", urlObj.get("dbtype"));
        params.put("host", urlObj.get("host"));
        params.put("port", urlObj.get("port"));
        params.put("database", urlObj.get("database"));
        params.put("schema", this.schema);
        params.put("user", this.getUsername());
        params.put(JDBCDataStoreFactory.FETCHSIZE.key, 50);
        params.put("passwd", this.getPassword());
        params.put(JDBCDataStoreFactory.EXPOSE_PK.key, true);
        log.debug((Object)("Opening datastore using parameters: " + params));
        try {
            DataStore ds = DataStoreFinder.getDataStore(params);
            if (ds == null) {
                params.put("passwd", "xxx");
                throw new Exception("Cannot open datastore using parameters " + params);
            }
            return ds;
        }
        catch (Exception e) {
            params.put("passwd", "xxx");
            throw new Exception("Cannot open datastore using parameters " + params, e);
        }
    }

    @Override
    FeatureSource openGeoToolsFeatureSource(SimpleFeatureType sft) throws Exception {
        DataStore ds = this.createDataStore();
        return ds.getFeatureSource(sft.getTypeName());
    }

    @Override
    FeatureSource openGeoToolsFeatureSource(SimpleFeatureType sft, int timeout) throws Exception {
        return this.openGeoToolsFeatureSource(sft);
    }

    @Override
    FeatureCollection getFeatures(SimpleFeatureType sft, Filter f, int maxFeatures) throws Exception {
        FeatureCollection fc = null;
        fc = f != null ? sft.openGeoToolsFeatureSource().getFeatures(f) : sft.openGeoToolsFeatureSource().getFeatures();
        return fc;
    }
}

