/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.RemoveEmptyMapValuesUtil;
import nl.b3p.viewer.config.services.BoundingBox;
import nl.b3p.viewer.config.services.CoordinateReferenceSystem;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.TileSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.StyleImpl;
import org.geotools.data.wms.xml.MetadataURL;
import org.hibernate.annotations.Type;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@Entity
@org.hibernate.annotations.Entity(dynamicUpdate=true)
public class Layer
implements Cloneable,
Serializable {
    private static final Log log = LogFactory.getLog(Layer.class);
    public static final String EXTRA_KEY_METADATA_URL = "metadata.url";
    public static final String EXTRA_KEY_METADATA_STYLESHEET_URL = "metadata.stylesheet";
    public static final String EXTRA_KEY_DOWNLOAD_URL = "download.url";
    public static final String EXTRA_KEY_FILTERABLE = "filterable";
    public static final String EXTRA_IMAGE_EXTENSION = "image_extension";
    public static final String DETAIL_WMS_STYLES = "wms.styles";
    public static final String DETAIL_ALL_CHILDREN = "all_children";
    public static final String DETAIL_ALTERNATE_LEGEND_IMAGE_URL = "alternateLegendImageUrl";
    private static Set<String> interestingDetails = new HashSet<String>(Arrays.asList("metadata.url", "metadata.stylesheet", "download.url", "filterable", "image_extension", "all_children", "wms.styles", "alternateLegendImageUrl"));
    private static Set<String> updatableDetails = new HashSet<String>(Arrays.asList("metadata.url", "all_children", "wms.styles"));
    @Id
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    private GeoService service;
    @ManyToOne(fetch=FetchType.LAZY)
    private Layer parent;
    private String name;
    private String title;
    private String titleAlias;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String legendImageUrl;
    private Double minScale;
    private Double maxScale;
    @ElementCollection
    private Set<CoordinateReferenceSystem> crsList = new HashSet<CoordinateReferenceSystem>();
    @ElementCollection
    private Map<CoordinateReferenceSystem, BoundingBox> boundingBoxes = new HashMap<CoordinateReferenceSystem, BoundingBox>();
    @ManyToOne(fetch=FetchType.LAZY)
    private TileSet tileset;
    private boolean virtual;
    private boolean queryable;
    private boolean filterable;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SimpleFeatureType featureType;
    @ElementCollection
    @Column(name="keyword")
    private Set<String> keywords = new HashSet<String>();
    @ElementCollection
    @Column(name="role_name")
    private Set<String> readers = new HashSet<String>();
    @ElementCollection
    @Column(name="role_name")
    public Set<String> writers = new HashSet<String>();
    @ElementCollection
    @Column(name="role_name")
    public Set<String> preventGeomEditors = new HashSet<String>();
    @ManyToMany(cascade={CascadeType.PERSIST})
    @JoinTable(inverseJoinColumns={@JoinColumn(name="child", unique=true)})
    @OrderColumn(name="list_index")
    private List<Layer> children = new ArrayList<Layer>();
    @ElementCollection
    @JoinTable(joinColumns={@JoinColumn(name="layer")})
    private Map<String, ClobElement> details = new HashMap<String, ClobElement>();

    public Layer() {
    }

    public Layer(org.geotools.data.ows.Layer l, GeoService service) {
        this.name = l.getName();
        this.virtual = this.name == null;
        this.title = l.getTitle();
        this.minScale = l.getScaleDenominatorMin();
        this.service = service;
        if (Double.isNaN(this.minScale)) {
            this.minScale = null;
        }
        this.maxScale = l.getScaleDenominatorMax();
        if (Double.isNaN(this.maxScale)) {
            this.maxScale = null;
        }
        if (this.minScale == null && this.maxScale == null) {
            this.minScale = l.getScaleDenominatorMin();
            this.maxScale = l.getScaleDenominatorMax();
            if (Double.isNaN(this.minScale)) {
                this.minScale = null;
            }
            if (Double.isNaN(this.maxScale)) {
                this.maxScale = null;
            }
            if (this.minScale != null && this.maxScale != null && this.minScale < 750.0 && this.maxScale < 5000.0) {
                this.minScale = Math.sqrt(this.minScale * this.minScale / 2.0);
                this.maxScale = Math.sqrt(this.maxScale * this.maxScale / 2.0);
            }
        }
        for (CRSEnvelope e : l.getLayerBoundingBoxes()) {
            BoundingBox b = new BoundingBox(e);
            this.boundingBoxes.put(b.getCrs(), b);
        }
        for (String s : l.getSrs()) {
            this.crsList.add(new CoordinateReferenceSystem(s));
        }
        this.queryable = l.isQueryable();
        if (l.getKeywords() != null) {
            this.keywords.addAll(Arrays.asList(l.getKeywords()));
        }
        if (!l.getMetadataURL().isEmpty()) {
            this.details.put(EXTRA_KEY_METADATA_URL, new ClobElement(((MetadataURL)l.getMetadataURL().get(0)).getUrl().toString()));
        }
        if (!l.getStyles().isEmpty()) {
            try {
                JSONArray styles = new JSONArray();
                for (StyleImpl style : l.getStyles()) {
                    JSONObject jstyle = new JSONObject();
                    styles.put((Object)jstyle);
                    jstyle.put("name", (Object)style.getName());
                    if (style.getTitle() != null) {
                        jstyle.put("title", (Object)style.getTitle().toString());
                    }
                    if (style.getAbstract() != null) {
                        jstyle.put("abstract", (Object)style.getAbstract().toString());
                    }
                    JSONArray legendUrls = new JSONArray();
                    jstyle.put("legendURLs", (Object)legendUrls);
                    for (String url : style.getLegendURLs()) {
                        if (!StringUtils.containsIgnoreCase((CharSequence)url, (CharSequence)"SERVICE=WMS")) {
                            url = url.concat("&SERVICE=WMS");
                        }
                        legendUrls.put((Object)url);
                    }
                }
                if (styles.length() > 0) {
                    this.details.put(DETAIL_WMS_STYLES, new ClobElement(styles.toString()));
                }
            }
            catch (JSONException e) {
                log.error((Object)"Error creating styles JSON", (Throwable)e);
            }
        }
        if (l.getStyles().size() > 0 && ((StyleImpl)l.getStyles().get(0)).getLegendURLs().size() > 0) {
            String legendUrl = (String)((StyleImpl)l.getStyles().get(0)).getLegendURLs().get(0);
            if (!StringUtils.containsIgnoreCase((CharSequence)legendUrl, (CharSequence)"SERVICE=WMS")) {
                legendUrl = legendUrl.concat("&SERVICE=WMS");
            }
            this.legendImageUrl = legendUrl;
        }
        for (org.geotools.data.ows.Layer child : l.getLayerChildren()) {
            Layer childLayer = new Layer(child, service);
            childLayer.setParent(this);
            this.children.add(childLayer);
        }
    }

    protected void update(Layer update) {
        this.update(update, null);
    }

    protected void update(Layer update, Set<String> additionalUpdatableDetails) {
        if (!this.getName().equals(update.getName())) {
            throw new IllegalArgumentException("Cannot update layer with properties from layer with different name!");
        }
        this.virtual = update.virtual;
        this.queryable = update.queryable;
        this.filterable = update.filterable;
        this.title = update.title;
        this.minScale = update.minScale;
        this.maxScale = update.maxScale;
        if (!this.boundingBoxes.equals(update.boundingBoxes)) {
            this.boundingBoxes.clear();
            this.boundingBoxes.putAll(update.boundingBoxes);
        }
        if (!this.crsList.equals(update.crsList)) {
            this.crsList.clear();
            this.crsList.addAll(update.crsList);
        }
        if (!this.keywords.equals(update.keywords)) {
            this.keywords.clear();
            this.keywords.addAll(update.keywords);
        }
        for (String s : updatableDetails) {
            this.details.remove(s);
        }
        if (additionalUpdatableDetails != null) {
            for (String s : additionalUpdatableDetails) {
                this.details.remove(s);
            }
        }
        this.details.putAll(update.getDetails());
        RemoveEmptyMapValuesUtil.removeEmptyMapValues(this.details);
        this.legendImageUrl = update.legendImageUrl;
    }

    protected void copyUserModifiedProperties(Layer other) {
        this.setTitleAlias(other.getTitleAlias());
        this.getReaders().clear();
        this.getReaders().addAll(other.getReaders());
        this.getWriters().clear();
        this.getWriters().addAll(other.getWriters());
    }

    public Layer pluckCopy() {
        if (Stripersist.getEntityManager().contains((Object)this)) {
            throw new IllegalStateException();
        }
        try {
            Layer clone = (Layer)super.clone();
            clone.setParent(null);
            clone.setChildren(new ArrayList<Layer>());
            clone.setService(null);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean isBufferable() {
        return this.getService().getProtocol().equals("arcims") || this.getFeatureType() != null;
    }

    public boolean accept(Visitor visitor, EntityManager em) {
        for (Layer child : this.getCachedChildren(em)) {
            if (child.accept(visitor, em)) continue;
            return false;
        }
        return visitor.visit(this, em);
    }

    public String getDisplayName() {
        if (StringUtils.isNotBlank((CharSequence)this.titleAlias)) {
            return this.titleAlias;
        }
        if (StringUtils.isNotBlank((CharSequence)"title")) {
            return this.title;
        }
        return this.name;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject o = new JSONObject();
        o.put("id", (Object)this.id);
        o.put("serviceId", (Object)this.service.getId());
        o.put("name", (Object)this.name);
        o.put("virtual", this.virtual);
        o.put("queryable", this.queryable);
        o.put(EXTRA_KEY_FILTERABLE, this.filterable);
        if (this.title != null) {
            o.put("title", (Object)this.title);
        }
        if (this.titleAlias != null) {
            o.put("titleAlias", (Object)this.titleAlias);
        }
        if (this.legendImageUrl != null) {
            o.put("legendImageUrl", (Object)this.legendImageUrl);
        }
        if (this.minScale != null) {
            if (this.minScale.isNaN() || this.minScale.isInfinite()) {
                log.error((Object)("Can't use minScale: " + this.minScale + " of Servicelayer" + this.service.getName() + " - " + this.name));
            } else {
                o.put("minScale", (Object)this.minScale);
            }
        }
        if (this.maxScale != null) {
            if (this.maxScale.isNaN() || this.maxScale.isInfinite()) {
                log.error((Object)("Can't use maxScale: " + this.maxScale + " of Servicelayer" + this.service.getName() + " - " + this.name));
            } else {
                o.put("maxScale", (Object)this.maxScale);
            }
        }
        o.put("hasFeatureType", this.featureType != null);
        if (this.featureType != null) {
            o.put("featureTypeName", (Object)this.featureType.getTypeName());
            o.put("featureTypeId", (Object)this.featureType.getId());
        }
        if (!this.details.isEmpty()) {
            JSONObject d = new JSONObject();
            o.put("details", (Object)d);
            for (Map.Entry<String, ClobElement> e : this.details.entrySet()) {
                if (!interestingDetails.contains(e.getKey())) continue;
                d.put(e.getKey(), (Object)e.getValue().getValue());
            }
        }
        if (this.tileset != null) {
            o.put("tileHeight", this.tileset.getHeight());
            o.put("tileWidth", this.tileset.getWidth());
            if (this.tileset.getResolutions() != null) {
                String resolutions = "";
                for (Double d : this.tileset.getResolutions()) {
                    if (resolutions.length() > 0) {
                        resolutions = resolutions + ",";
                    }
                    resolutions = resolutions + d.toString();
                }
                o.put("resolutions", (Object)resolutions);
            }
            if (this.boundingBoxes.size() == 1) {
                BoundingBox bbox = this.boundingBoxes.values().iterator().next();
                o.put("bbox", (Object)bbox.toJSONObject());
            }
        }
        return o;
    }

    public List<Layer> getCachedChildren(EntityManager em) {
        return this.service.getLayerChildrenCache(this, em);
    }

    public Layer getParent() {
        return this.parent;
    }

    public void setParent(Layer parent) {
        this.parent = parent;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleAlias() {
        return this.titleAlias;
    }

    public void setTitleAlias(String titleAlias) {
        this.titleAlias = titleAlias;
    }

    public GeoService getService() {
        return this.service;
    }

    public void setService(GeoService service) {
        this.service = service;
    }

    public Set<CoordinateReferenceSystem> getCrsList() {
        return this.crsList;
    }

    public void setCrsList(Set<CoordinateReferenceSystem> crsList) {
        this.crsList = crsList;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public void setFilterable(boolean filterable) {
        this.filterable = filterable;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public void setQueryable(boolean queryable) {
        this.queryable = queryable;
    }

    public Set<String> getReaders() {
        return this.readers;
    }

    public void setReaders(Set<String> readers) {
        this.readers = readers;
    }

    public Set<String> getWriters() {
        return this.writers;
    }

    public void setWriters(Set<String> writers) {
        this.writers = writers;
    }

    public Set<String> getPreventGeomEditors() {
        return this.preventGeomEditors;
    }

    public void setPreventGeomEditors(Set<String> preventGeomEditors) {
        this.preventGeomEditors = preventGeomEditors;
    }

    public List<Layer> getChildren() {
        return this.children;
    }

    public void setChildren(List<Layer> children) {
        this.children = children;
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Set<String> keywords) {
        this.keywords = keywords;
    }

    public Map<String, ClobElement> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, ClobElement> details) {
        this.details = details;
    }

    public Double getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(Double maxScale) {
        this.maxScale = maxScale;
    }

    public Double getMinScale() {
        return this.minScale;
    }

    public void setMinScale(Double minScale) {
        this.minScale = minScale;
    }

    public TileSet getTileset() {
        return this.tileset;
    }

    public void setTileset(TileSet tileset) {
        this.tileset = tileset;
    }

    public String getLegendImageUrl() {
        return this.legendImageUrl;
    }

    public void setLegendImageUrl(String legendImageUrl) {
        this.legendImageUrl = legendImageUrl;
    }

    public Map<CoordinateReferenceSystem, BoundingBox> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    public void setBoundingBoxes(Map<CoordinateReferenceSystem, BoundingBox> boundingBoxes) {
        this.boundingBoxes = boundingBoxes;
    }

    public static interface Visitor {
        public boolean visit(Layer var1, EntityManager var2);
    }
}

