/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
public class SolrConf {
    @Id
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    private SimpleFeatureType simpleFeatureType;
    @ElementCollection
    @CollectionTable(name="solr_conf_index_attributes", joinColumns={@JoinColumn(name="solr_conf")})
    @Column(name="attribute_")
    private List<String> indexAttributes = new ArrayList<String>();
    @ElementCollection
    @CollectionTable(name="solr_conf_result_attributes", joinColumns={@JoinColumn(name="solr_conf")})
    @Column(name="attribute_")
    private List<String> resultAttributes = new ArrayList<String>();
    private String name;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastUpdated = new Date();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SimpleFeatureType getSimpleFeatureType() {
        return this.simpleFeatureType;
    }

    public void setSimpleFeatureType(SimpleFeatureType simpleFeatureType) {
        this.simpleFeatureType = simpleFeatureType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getIndexAttributes() {
        return this.indexAttributes;
    }

    public void setIndexAttributes(List<String> indexAttributes) {
        this.indexAttributes = indexAttributes;
    }

    public List<String> getResultAttributes() {
        return this.resultAttributes;
    }

    public void setResultAttributes(List<String> resultAttributes) {
        this.resultAttributes = resultAttributes;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.id);
        json.put("name", (Object)this.name);
        String last = "Niet ingelezen";
        if (this.lastUpdated != null) {
            SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
            sdf.applyPattern("HH-mm_dd-MM-yyyy");
            last = sdf.format(this.lastUpdated);
        }
        json.put("lastUpdated", (Object)last);
        json.put("featureTypeId", (Object)this.simpleFeatureType.getId());
        json.put("featureTypeName", (Object)this.simpleFeatureType.getTypeName());
        json.put("featureSourceName", (Object)this.simpleFeatureType.getFeatureSource().getName());
        return json;
    }
}

