/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.util.Map;
import java.util.Set;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.services.BoundingBox;
import nl.b3p.viewer.config.services.CoordinateReferenceSystem;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.TileSet;
import nl.b3p.web.WaitPageStatus;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
@DiscriminatorValue(value="tiled")
public class TileService
extends GeoService {
    public static final String PROTOCOL = "tiled";
    public static final String PARAM_RESOLUTIONS = "resolutions";
    public static final String PARAM_TILESIZE = "tileSize";
    public static final String PARAM_TILINGPROTOCOL = "tilingProtocol";
    public static final String PARAM_SERVICENAME = "ServiceName";
    public static final String PARAM_SERVICEBBOX = "serviceBbox";
    public static final String PARAM_IMAGEEXTENSION = "imageExtension";
    public static final String PARAM_CRS = "crs";
    private String tilingProtocol;

    public String getTilingProtocol() {
        return this.tilingProtocol;
    }

    public void setTilingProtocol(String tilingProtocol) {
        this.tilingProtocol = tilingProtocol;
    }

    @Override
    public void checkOnline(EntityManager em) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeoService loadFromUrl(String url, Map params, WaitPageStatus status, EntityManager em) {
        status.setCurrentAction("Bezig met aanmaken tile service");
        try {
            TileService s = new TileService();
            s.setUrl(url);
            String serviceName = (String)params.get(PARAM_SERVICENAME);
            s.setName(serviceName);
            String tp = (String)params.get(PARAM_TILINGPROTOCOL);
            s.setTilingProtocol(tp);
            Layer topLayer = new Layer();
            topLayer.setVirtual(true);
            topLayer.setService(s);
            Layer tilingLayer = new Layer();
            tilingLayer.setName(serviceName);
            tilingLayer.setTitle(serviceName);
            tilingLayer.setParent(topLayer);
            tilingLayer.setService(s);
            TileSet ts = new TileSet();
            Boolean unique = false;
            String tsName = serviceName;
            for (int i = 0; i < 100; ++i) {
                if (em.find(TileSet.class, (Object)tsName) == null) {
                    unique = true;
                    break;
                }
                tsName = serviceName + "(" + (i + 1) + ")";
            }
            ts.setName(tsName);
            if (params.containsKey(PARAM_RESOLUTIONS)) {
                String resString = (String)params.get(PARAM_RESOLUTIONS);
                ts.setResolutions(resString);
            }
            if (params.containsKey(PARAM_TILESIZE)) {
                Integer size = (Integer)params.get(PARAM_TILESIZE);
                ts.setHeight(size);
                ts.setWidth(size);
            }
            if (params.containsKey(PARAM_SERVICEBBOX) && params.containsKey(PARAM_CRS)) {
                String bounds = (String)params.get(PARAM_SERVICEBBOX);
                BoundingBox bb = new BoundingBox();
                bb.setBounds(bounds);
                bb.setCrs(new CoordinateReferenceSystem((String)params.get(PARAM_CRS)));
                tilingLayer.getBoundingBoxes().put(bb.getCrs(), bb);
            }
            if (params.containsKey(PARAM_IMAGEEXTENSION) && params.get(PARAM_IMAGEEXTENSION) != null && StringUtils.isNotBlank((CharSequence)((String)params.get(PARAM_IMAGEEXTENSION)))) {
                tilingLayer.getDetails().put("image_extension", new ClobElement((String)params.get(PARAM_IMAGEEXTENSION)));
            }
            topLayer.getChildren().add(tilingLayer);
            s.setTopLayer(topLayer);
            em.persist((Object)ts);
            tilingLayer.setTileset(ts);
            TileService tileService = s;
            return tileService;
        }
        finally {
            status.setProgress(100);
            status.setCurrentAction("Service ingeladen");
            status.setFinished(true);
        }
    }

    public Layer getTilingLayer() {
        if (this.getTopLayer() != null && this.getTopLayer().getChildren().size() > 0) {
            return this.getTopLayer().getChildren().get(0);
        }
        return null;
    }

    @Override
    public JSONObject toJSONObject(boolean flatten, Set<String> layersToInclude, boolean validXmlTags, EntityManager em) throws JSONException {
        JSONObject o = super.toJSONObject(flatten, layersToInclude, validXmlTags, em);
        if (this.tilingProtocol != null) {
            o.put(PARAM_TILINGPROTOCOL, (Object)this.tilingProtocol);
        }
        return o;
    }

    @Override
    public JSONObject toJSONObject(boolean flatten, Set<String> layersToInclude, boolean validXmlTags, boolean includeAuthorizations, EntityManager em) throws JSONException {
        JSONObject o = super.toJSONObject(flatten, layersToInclude, validXmlTags, includeAuthorizations, em);
        if (this.tilingProtocol != null) {
            o.put(PARAM_TILINGPROTOCOL, (Object)this.tilingProtocol);
        }
        return o;
    }
}

