/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.Level;
import nl.b3p.viewer.config.app.StartLayer;
import nl.b3p.viewer.config.app.StartLevel;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.GeoService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

public class SelectedContentCache {
    private static final Log log = LogFactory.getLog(SelectedContentCache.class);
    public static final String AUTHORIZATIONS_KEY = "authorizations";
    public static final String DETAIL_CACHED_SELECTED_CONTENT = "cachedSelectedContent";
    public static final String DETAIL_CACHED_SELECTED_CONTENT_DIRTY = "cachedSelectedContentDirty";
    public static final String DETAIL_CACHED_EXPANDED_SELECTED_CONTENT = "cachedExpandedSelectedContent";
    public static final String DETAIL_CACHED_EXPANDED_SELECTED_CONTENT_DIRTY = "cachedExpandedSelectedContentDirty";

    public JSONObject getSelectedContent(HttpServletRequest request, Application app, boolean validXmlTags, boolean includeAppLayerAttributes, boolean includeRelations, EntityManager em) throws JSONException {
        ClobElement el;
        boolean useExpanded = includeAppLayerAttributes || includeRelations;
        JSONObject cached = null;
        if (this.mustCreateNewCache(app, validXmlTags, useExpanded)) {
            cached = this.createSelectedContent(app, validXmlTags, includeAppLayerAttributes, includeRelations, em);
            if (!validXmlTags) {
                el = new ClobElement(cached.toString());
                app.getDetails().put(useExpanded ? DETAIL_CACHED_EXPANDED_SELECTED_CONTENT : DETAIL_CACHED_SELECTED_CONTENT, el);
                SelectedContentCache.setApplicationCacheDirty(app, false, useExpanded, em);
                Stripersist.getEntityManager().getTransaction().commit();
            }
        } else {
            el = app.getDetails().get(useExpanded ? DETAIL_CACHED_EXPANDED_SELECTED_CONTENT : DETAIL_CACHED_SELECTED_CONTENT);
            cached = new JSONObject(el.getValue());
        }
        JSONObject selectedContent = this.processCache(request, cached);
        return selectedContent;
    }

    private JSONObject processCache(HttpServletRequest request, JSONObject cached) throws JSONException {
        boolean allowed;
        String key;
        Set<String> roles = Authorizations.getRoles(request);
        JSONObject levels = cached.getJSONObject("levels");
        JSONObject appLayers = cached.getJSONObject("appLayers");
        JSONArray selectedContent = cached.getJSONArray("selectedContent");
        JSONObject services = cached.has("services") ? cached.getJSONObject("services") : new JSONObject();
        Iterator it = appLayers.sortedKeys();
        while (it.hasNext()) {
            key = (String)it.next();
            JSONObject appLayer = appLayers.getJSONObject(key);
            allowed = this.isAppLayerAllowed(appLayer, roles);
            if (allowed) continue;
            appLayers.remove(key);
        }
        it = levels.sortedKeys();
        while (it.hasNext()) {
            key = (String)it.next();
            JSONObject level = levels.getJSONObject(key);
            allowed = this.isLevelAllowed(level, roles);
            if (!allowed) {
                levels.remove(key);
            }
            JSONArray newLayers = new JSONArray();
            if (!level.has("layers")) continue;
            JSONArray layers = level.getJSONArray("layers");
            for (int i = 0; i < layers.length(); ++i) {
                String layerId = layers.getString(i);
                if (!appLayers.has(layerId)) continue;
                newLayers.put((Object)layerId);
            }
            level.put("layers", (Object)newLayers);
        }
        String scheme = request.getScheme();
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String contextPath = request.getContextPath();
        StringBuilder url = new StringBuilder();
        String servletPath = "/action/proxy/wms";
        url.append(scheme).append("://").append(serverName);
        if (serverPort != 80 && serverPort != 443) {
            url.append(":").append(serverPort);
        }
        url.append(contextPath).append(servletPath);
        String proxyUrl = url.toString();
        Iterator it2 = services.sortedKeys();
        while (it2.hasNext()) {
            String key2 = (String)it2.next();
            JSONObject service = services.getJSONObject(key2);
            if (!service.has("useProxy") || !service.getBoolean("useProxy")) continue;
            try {
                String actualURL = service.getString("url");
                String param = URLEncoder.encode(actualURL, "UTF-8");
                StringBuilder newUrl = new StringBuilder(proxyUrl);
                newUrl.append("?url=");
                newUrl.append(param);
                if (service.has("mustLogin") && service.getBoolean("mustLogin")) {
                    newUrl.append("&mustLogin=true&serviceId=");
                    newUrl.append(service.get("id"));
                }
                service.put("url", (Object)newUrl);
            }
            catch (UnsupportedEncodingException ex) {
                log.error((Object)"Cannot add proxy url for service: ", (Throwable)ex);
            }
        }
        JSONArray newSelectedContent = new JSONArray();
        for (int i = 0; i < selectedContent.length(); ++i) {
            JSONObject obj = selectedContent.getJSONObject(i);
            String type = obj.getString("type");
            String id = obj.getString("id");
            if (!type.equalsIgnoreCase("level") || !this.isLevelAllowed(id, levels)) continue;
            newSelectedContent.put((Object)obj);
        }
        cached.put("selectedContent", (Object)newSelectedContent);
        return cached;
    }

    private boolean isLevelAllowed(String id, JSONObject levels) {
        return levels.has(id);
    }

    private boolean isLevelAllowed(JSONObject level, Set<String> roles) throws JSONException {
        boolean allowed = this.isAuthorized(level, roles, false);
        if (!allowed) {
            return false;
        }
        if (level.has("children")) {
            JSONArray children = level.getJSONArray("children");
            JSONArray newChildren = new JSONArray();
            for (int i = 0; i < children.length(); ++i) {
                JSONObject child = children.getJSONObject(i);
                if (!this.isLevelAllowed(child, roles)) continue;
                newChildren.put((Object)child.getString("child"));
            }
            level.put("children", (Object)newChildren);
        }
        return true;
    }

    private boolean isAppLayerAllowed(JSONObject appLayer, Set<String> roles) throws JSONException {
        boolean allowed = this.isAuthorized(appLayer, roles, false);
        if (!allowed) {
            return false;
        }
        boolean editAuthorized = this.isAuthorized(appLayer, roles, true, "editAuthorizations");
        appLayer.put("editAuthorized", editAuthorized);
        return true;
    }

    private boolean isAuthorized(JSONObject obj, Set<String> roles, boolean alsoWriters) throws JSONException {
        return this.isAuthorized(obj, roles, alsoWriters, AUTHORIZATIONS_KEY);
    }

    private boolean isAuthorized(JSONObject obj, Set<String> roles, boolean alsoWriters, String authString) throws JSONException {
        if (obj.has(authString) && obj.getJSONObject(authString).length() != 0) {
            JSONArray writers;
            JSONArray readers = obj.getJSONObject(authString).getJSONArray("readers");
            if (readers.length() > 0) {
                HashSet<String> allowedRoles = new HashSet<String>();
                for (int i = 0; i < readers.length(); ++i) {
                    if (readers.isNull(i)) continue;
                    String reader = readers.getString(i);
                    allowedRoles.add(reader);
                }
                if (Collections.disjoint(roles, allowedRoles)) {
                    return false;
                }
            }
            if (alsoWriters && (writers = obj.getJSONObject(authString).getJSONArray("writers")).length() > 0) {
                HashSet<String> allowedRoles = new HashSet<String>();
                for (int i = 0; i < writers.length(); ++i) {
                    String writer = writers.getString(i);
                    allowedRoles.add(writer);
                }
                if (Collections.disjoint(roles, allowedRoles)) {
                    return false;
                }
            }
        }
        obj.remove(authString);
        return true;
    }

    public JSONObject createSelectedContent(Application app, boolean validXmlTags, boolean includeAppLayerAttributes, boolean includeRelations, EntityManager em) throws JSONException {
        Level root = app.getRoot();
        JSONObject o = new JSONObject();
        if (root != null) {
            o.put("rootLevel", (Object)root.getId().toString());
            Application.TreeCache treeCache = app.loadTreeCache(em);
            treeCache.initializeLevels("left join fetch l.documents", em);
            treeCache.initializeApplicationLayers("left join fetch al.details", em);
            Authorizations.ApplicationCache appCache = Authorizations.getApplicationCache(app, em);
            JSONObject levels = new JSONObject();
            o.put("levels", (Object)levels);
            JSONObject appLayers = new JSONObject();
            o.put("appLayers", (Object)appLayers);
            JSONArray selectedContent = new JSONArray();
            o.put("selectedContent", (Object)selectedContent);
            ArrayList selectedObjects = new ArrayList();
            this.walkAppTreeForJSON(levels, appLayers, selectedObjects, root, false, validXmlTags, includeAppLayerAttributes, includeRelations, app, treeCache, appCache, em);
            Collections.sort(selectedObjects, new Comparator(){

                public int compare(Object lhs, Object rhs) {
                    Integer lhsIndex = lhs instanceof StartLevel ? ((StartLevel)lhs).getSelectedIndex() : ((StartLayer)lhs).getSelectedIndex();
                    Integer rhsIndex = rhs instanceof StartLevel ? ((StartLevel)rhs).getSelectedIndex() : ((StartLayer)rhs).getSelectedIndex();
                    return lhsIndex.compareTo(rhsIndex);
                }
            });
            for (Object obj : selectedObjects) {
                JSONObject j = new JSONObject();
                if (obj instanceof StartLevel) {
                    j.put("type", (Object)"level");
                    j.put("id", (Object)((StartLevel)obj).getLevel().getId().toString());
                } else {
                    j.put("type", (Object)"appLayer");
                    j.put("id", (Object)((StartLayer)obj).getApplicationLayer().getId().toString());
                }
                selectedContent.put((Object)j);
            }
            HashMap<GeoService, Set<String>> usedLayersByService = new HashMap<GeoService, Set<String>>();
            this.visitLevelForUsedServicesLayers(root, usedLayersByService, app, treeCache);
            if (!usedLayersByService.isEmpty()) {
                JSONObject services = new JSONObject();
                o.put("services", (Object)services);
                for (Map.Entry entry : usedLayersByService.entrySet()) {
                    GeoService gs = (GeoService)entry.getKey();
                    Set usedLayers = (Set)entry.getValue();
                    String serviceId = gs.getId().toString();
                    if (validXmlTags) {
                        serviceId = "service_" + serviceId;
                    }
                    services.put(serviceId, (Object)gs.toJSONObject(false, usedLayers, validXmlTags, true, em));
                }
            }
        }
        return o;
    }

    private void walkAppTreeForJSON(JSONObject levels, JSONObject appLayers, List selectedContent, Level l, boolean parentIsBackground, boolean validXmlTags, boolean includeAppLayerAttributes, boolean includeRelations, Application app, Application.TreeCache treeCache, Authorizations.ApplicationCache appCache, EntityManager em) throws JSONException {
        JSONObject o = l.toJSONObject(false, app, null, em);
        Authorizations.Read auths = appCache.getProtectedLevels().get(l.getId());
        o.put(AUTHORIZATIONS_KEY, (Object)(auths != null ? auths.toJSON() : new JSONObject()));
        o.put("background", l.isBackground() || parentIsBackground);
        String levelId = l.getId().toString();
        if (validXmlTags) {
            levelId = "level_" + levelId;
        }
        levels.put(levelId, (Object)o);
        StartLevel sl = l.getStartLevels().get(app);
        if (sl != null && sl.getSelectedIndex() != null) {
            selectedContent.add(sl);
        }
        for (ApplicationLayer al : l.getLayers()) {
            Authorizations.ReadWrite applayerAuths;
            JSONObject p = al.toJSONObject(includeAppLayerAttributes, includeRelations, em, app);
            p.put("background", l.isBackground() || parentIsBackground);
            Authorizations.ReadWrite rw = appCache.getProtectedAppLayers().get(al.getId());
            p.put("editAuthorizations", (Object)(rw != null ? rw.toJSON() : new JSONObject()));
            String alId = al.getId().toString();
            if (validXmlTags) {
                alId = "appLayer_" + alId;
            }
            p.put(AUTHORIZATIONS_KEY, (Object)((applayerAuths = appCache.getProtectedAppLayers().get(al.getId())) != null ? applayerAuths.toJSON() : new JSONObject()));
            appLayers.put(alId, (Object)p);
            StartLayer startLayer = al.getStartLayers().get(app);
            if (startLayer == null || startLayer.getSelectedIndex() == null) continue;
            selectedContent.add(startLayer);
        }
        List<Level> children = treeCache.getChildrenByParent().get(l);
        if (children != null) {
            Collections.sort(children);
            JSONArray jsonChildren = new JSONArray();
            o.put("children", (Object)jsonChildren);
            for (Level child : children) {
                JSONObject childObject = new JSONObject();
                String childId = child.getId().toString();
                if (validXmlTags) {
                    childId = "level_" + childId;
                }
                childObject.put("child", (Object)childId);
                Authorizations.Read levelAuths = appCache.getProtectedLevels().get(child.getId());
                childObject.put(AUTHORIZATIONS_KEY, (Object)(levelAuths != null ? levelAuths.toJSON() : new JSONObject()));
                jsonChildren.put((Object)childObject);
                this.walkAppTreeForJSON(levels, appLayers, selectedContent, child, l.isBackground(), validXmlTags, includeAppLayerAttributes, includeRelations, app, treeCache, appCache, em);
            }
        }
    }

    private void visitLevelForUsedServicesLayers(Level l, Map<GeoService, Set<String>> usedLayersByService, Application app, Application.TreeCache treeCache) {
        for (ApplicationLayer al : l.getLayers()) {
            GeoService gs = al.getService();
            Set<String> usedLayers = usedLayersByService.get(gs);
            if (usedLayers == null) {
                usedLayers = new HashSet<String>();
                usedLayersByService.put(gs, usedLayers);
            }
            usedLayers.add(al.getLayerName());
        }
        List<Level> children = treeCache.getChildrenByParent().get(l);
        if (children != null) {
            for (Level child : children) {
                this.visitLevelForUsedServicesLayers(child, usedLayersByService, app, treeCache);
            }
        }
    }

    private boolean mustCreateNewCache(Application app, boolean validXmlTags, boolean expanded) {
        ClobElement cache;
        ClobElement clobElement = cache = expanded ? app.getDetails().get(DETAIL_CACHED_EXPANDED_SELECTED_CONTENT) : app.getDetails().get(DETAIL_CACHED_SELECTED_CONTENT);
        if (cache == null || validXmlTags) {
            return true;
        }
        ClobElement dirtyClob = expanded ? app.getDetails().get(DETAIL_CACHED_EXPANDED_SELECTED_CONTENT_DIRTY) : app.getDetails().get(DETAIL_CACHED_SELECTED_CONTENT_DIRTY);
        boolean dirty = Boolean.valueOf(dirtyClob.getValue());
        return dirty;
    }

    public static void setApplicationCacheDirty(Application app, Boolean dirty, Boolean expanded, EntityManager em) {
        SelectedContentCache.setApplicationCacheDirty(app, dirty, expanded, false, em);
    }

    public static void setApplicationCacheDirty(Application app, Boolean dirty, Boolean expanded, Boolean onlyThisApplication, EntityManager em) {
        Set<Application> apps = new HashSet<Application>();
        if (dirty.booleanValue() && !onlyThisApplication.booleanValue()) {
            apps = app.getRoot().findApplications(em);
        } else {
            apps.add(app);
        }
        for (Application application : apps) {
            if (dirty.booleanValue()) {
                application.getDetails().put(DETAIL_CACHED_SELECTED_CONTENT_DIRTY, new ClobElement(dirty.toString()));
                application.getDetails().put(DETAIL_CACHED_EXPANDED_SELECTED_CONTENT_DIRTY, new ClobElement(dirty.toString()));
                continue;
            }
            application.getDetails().put(expanded != false ? DETAIL_CACHED_EXPANDED_SELECTED_CONTENT_DIRTY : DETAIL_CACHED_SELECTED_CONTENT_DIRTY, new ClobElement(dirty.toString()));
        }
    }
}

