/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.app;

import java.util.List;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.Level;
import nl.b3p.viewer.config.app.StartLayer;
import nl.b3p.viewer.config.app.StartLevel;
import nl.b3p.viewer.util.TestUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public class ApplicationTest
extends TestUtil {
    private static final Log log = LogFactory.getLog(ApplicationTest.class);

    @Test
    public void testDeepCopy() throws Exception {
        this.initData(false);
        int expectedStartLayerSize = this.app.getStartLayers().size();
        int expectedStartLevelSize = this.app.getStartLevels().size();
        Application copy = this.app.deepCopy();
        copy.setVersion("666");
        entityManager.detach((Object)this.app);
        entityManager.persist((Object)copy);
        objectsToRemove.add(copy);
        Assert.assertFalse((boolean)this.app.getId().equals(copy.getId()));
        Assert.assertEquals((long)expectedStartLayerSize, (long)copy.getStartLayers().size());
        Assert.assertEquals((long)expectedStartLevelSize, (long)copy.getStartLevels().size());
        for (StartLayer startLayer : copy.getStartLayers()) {
            Assert.assertEquals((Object)copy.getId(), (Object)startLayer.getApplication().getId());
        }
        for (StartLevel startLevel : copy.getStartLevels()) {
            Assert.assertEquals((Object)copy.getId(), (Object)startLevel.getApplication().getId());
        }
        this.app = (Application)entityManager.merge((Object)this.app);
        objectsToRemove.add(this.app);
    }

    @Test
    public void testDeepCopyReaders() throws Exception {
        this.initData(false);
        Application copy = this.app.deepCopy();
        Assert.assertEquals((long)2L, (long)copy.getReaders().size());
        for (String reader : this.app.getReaders()) {
            Assert.assertTrue((boolean)copy.getReaders().contains(reader));
        }
        objectsToRemove.add(this.app);
        objectsToRemove.add(copy);
    }

    @Test
    public void testDeleteApplications() throws Exception {
        this.initData(false);
        Application application = (Application)entityManager.find(Application.class, (Object)this.app.getId());
        Application copy = application.deepCopy();
        entityManager.detach((Object)application);
        copy.setVersion("123");
        entityManager.persist((Object)copy);
        application = (Application)entityManager.merge((Object)application);
        objectsToRemove.add(application);
        objectsToRemove.add(copy);
    }

    @Test
    public void testMakeMashupLinkComponents() throws Exception {
        block6: {
            this.initData(false);
            try {
                int expectedStartLayerSize = this.app.getStartLayers().size();
                int expectedStartLevelSize = this.app.getStartLevels().size();
                int expectedRootStartLevelSize = this.app.getRoot().getStartLevels().size() * 2;
                Application mashup = this.app.createMashup("mashup", entityManager, true);
                entityManager.persist((Object)mashup);
                objectsToRemove.add(this.app);
                objectsToRemove.add(mashup);
                entityManager.getTransaction().commit();
                entityManager.getTransaction().begin();
                Assert.assertFalse((boolean)this.app.getId().equals(mashup.getId()));
                Assert.assertEquals((long)expectedStartLayerSize, (long)mashup.getStartLayers().size());
                Assert.assertEquals((long)expectedStartLevelSize, (long)mashup.getStartLevels().size());
                for (StartLayer startLayer : mashup.getStartLayers()) {
                    Assert.assertEquals((Object)mashup.getId(), (Object)startLayer.getApplication().getId());
                }
                for (StartLevel startLevel : mashup.getStartLevels()) {
                    Assert.assertEquals((Object)mashup.getId(), (Object)startLevel.getApplication().getId());
                }
                Assert.assertEquals((long)expectedRootStartLevelSize, (long)this.app.getRoot().getStartLevels().size());
                Assert.assertEquals((Object)this.app.getRoot(), (Object)mashup.getRoot());
                Application.TreeCache tc = mashup.loadTreeCache(entityManager);
                List levels = tc.getLevels();
                List appLayers = tc.getApplicationLayers();
                for (ApplicationLayer appLayer : appLayers) {
                    Assert.assertTrue((boolean)appLayer.getStartLayers().containsKey(mashup));
                }
                for (Level level : levels) {
                    Assert.assertTrue((boolean)level.getStartLevels().containsKey(mashup));
                }
            }
            catch (Exception e) {
                log.error((Object)"Fout", (Throwable)e);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testMakeMashupDontLinkComponents() throws Exception {
        block6: {
            this.initData(false);
            try {
                int expectedStartLayerSize = this.app.getStartLayers().size();
                int expectedStartLevelSize = this.app.getStartLevels().size();
                int expectedRootStartLevelSize = this.app.getRoot().getStartLevels().size() * 2;
                Application mashup = this.app.createMashup("mashup", entityManager, false);
                entityManager.persist((Object)mashup);
                objectsToRemove.add(this.app);
                objectsToRemove.add(mashup);
                entityManager.getTransaction().commit();
                entityManager.getTransaction().begin();
                Assert.assertFalse((boolean)this.app.getId().equals(mashup.getId()));
                Assert.assertEquals((long)expectedStartLayerSize, (long)mashup.getStartLayers().size());
                Assert.assertEquals((long)expectedStartLevelSize, (long)mashup.getStartLevels().size());
                for (StartLayer startLayer : mashup.getStartLayers()) {
                    Assert.assertEquals((Object)mashup.getId(), (Object)startLayer.getApplication().getId());
                }
                for (StartLevel startLevel : mashup.getStartLevels()) {
                    Assert.assertEquals((Object)mashup.getId(), (Object)startLevel.getApplication().getId());
                }
                Assert.assertEquals((long)expectedRootStartLevelSize, (long)this.app.getRoot().getStartLevels().size());
                Assert.assertEquals((Object)this.app.getRoot(), (Object)mashup.getRoot());
                Application.TreeCache tc = mashup.loadTreeCache(entityManager);
                List levels = tc.getLevels();
                List appLayers = tc.getApplicationLayers();
                for (ApplicationLayer appLayer : appLayers) {
                    Assert.assertTrue((boolean)appLayer.getStartLayers().containsKey(mashup));
                }
                for (Level level : levels) {
                    Assert.assertTrue((boolean)level.getStartLevels().containsKey(mashup));
                }
            }
            catch (Exception e) {
                log.error((Object)"Fout", (Throwable)e);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testMakeMashupOfApplicationWithExistingMashup() throws Exception {
        block6: {
            this.initData(false);
            try {
                int expectedStartLayerSize = this.app.getStartLayers().size() * 2;
                int expectedStartLevelSize = this.app.getStartLevels().size() * 2;
                int expectedRootStartLevelSize = this.app.getRoot().getStartLevels().size() * 3;
                Application mashup1 = this.app.createMashup("mashup", entityManager, false);
                entityManager.persist((Object)mashup1);
                objectsToRemove.add(this.app);
                objectsToRemove.add(mashup1);
                entityManager.getTransaction().commit();
                entityManager.getTransaction().begin();
                Application mashup = this.app.createMashup("mashup2", entityManager, false);
                entityManager.persist((Object)mashup);
                objectsToRemove.add(this.app);
                objectsToRemove.add(mashup);
                entityManager.getTransaction().commit();
                entityManager.getTransaction().begin();
                Assert.assertFalse((boolean)this.app.getId().equals(mashup.getId()));
                Assert.assertEquals((long)expectedStartLayerSize, (long)mashup.getStartLayers().size());
                Assert.assertEquals((long)expectedStartLevelSize, (long)mashup.getStartLevels().size());
                for (StartLayer startLayer : mashup.getStartLayers()) {
                    Assert.assertEquals((Object)mashup.getId(), (Object)startLayer.getApplication().getId());
                }
                for (StartLevel startLevel : mashup.getStartLevels()) {
                    Assert.assertEquals((Object)mashup.getId(), (Object)startLevel.getApplication().getId());
                }
                Assert.assertEquals((long)expectedRootStartLevelSize, (long)this.app.getRoot().getStartLevels().size());
                Assert.assertEquals((Object)this.app.getRoot(), (Object)mashup.getRoot());
                Application.TreeCache tc = mashup.loadTreeCache(entityManager);
                List levels = tc.getLevels();
                List appLayers = tc.getApplicationLayers();
                for (ApplicationLayer appLayer : appLayers) {
                    Assert.assertTrue((boolean)appLayer.getStartLayers().containsKey(mashup));
                }
                for (Level level : levels) {
                    Assert.assertTrue((boolean)level.getStartLevels().containsKey(mashup));
                }
            }
            catch (Exception e) {
                log.error((Object)"Fout", (Throwable)e);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }
}

