/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.app;

import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.StartLayer;
import nl.b3p.viewer.util.TestUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public class StartLayerTest
extends TestUtil {
    private static final Log log = LogFactory.getLog(StartLayerTest.class);

    @Test
    public void persistLayer() {
        StartLayer sl = new StartLayer();
        sl.setChecked(true);
        sl.setSelectedIndex(Integer.valueOf(16));
        this.persistEntityTest(sl, StartLayer.class, true);
        entityManager.refresh((Object)sl);
        StartLayer test = (StartLayer)entityManager.find(StartLayer.class, (Object)sl.getId());
        Assert.assertNotNull((Object)test);
        Assert.assertEquals((Object)new Integer(16), (Object)test.getSelectedIndex());
        Assert.assertEquals((long)6L, (long)entityManager.createQuery("FROM Level").getResultList().size());
    }

    @Test
    public void deleteLayer() throws URISyntaxException, SQLException, IOException {
        Application app = (Application)entityManager.find(Application.class, (Object)1L);
        ApplicationLayer appLayer = (ApplicationLayer)entityManager.find(ApplicationLayer.class, (Object)2L);
        StartLayer sl = new StartLayer();
        sl.setChecked(true);
        sl.setApplicationLayer(appLayer);
        sl.setApplication(app);
        sl.setSelectedIndex(Integer.valueOf(16));
        this.persistAndDeleteEntityTest(sl, StartLayer.class);
        entityManager.flush();
        ApplicationLayer appLayerExists = (ApplicationLayer)entityManager.find(ApplicationLayer.class, (Object)2L);
        Application appExists = (Application)entityManager.find(Application.class, (Object)this.applicationId);
        Assert.assertNotNull((Object)appLayerExists);
        Assert.assertNotNull((Object)appExists);
        Assert.assertEquals((long)6L, (long)entityManager.createQuery("FROM Level").getResultList().size());
    }

    @Test
    public void deleteApplayer() throws URISyntaxException, SQLException, IOException {
        long lid;
        block2: {
            this.initData(true);
            Assert.assertNotNull((Object)this.testAppLayer);
            Assert.assertNotNull((Object)this.testStartLayer);
            lid = this.testAppLayer.getId();
            ApplicationLayer appLayer = (ApplicationLayer)entityManager.find(ApplicationLayer.class, (Object)lid);
            StartLayer startLayer = (StartLayer)entityManager.find(StartLayer.class, (Object)this.testStartLayer.getId());
            Assert.assertNotNull((Object)startLayer);
            this.testLevel.getLayers().remove(appLayer);
            this.app.getStartLayers().removeAll(appLayer.getStartLayers().values());
            entityManager.remove((Object)appLayer);
            try {
                entityManager.getTransaction().commit();
            }
            catch (Exception e) {
                log.error((Object)"Fout bij verwijderen", (Throwable)e);
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        entityManager.getTransaction().begin();
        ApplicationLayer appLayerNull = (ApplicationLayer)entityManager.find(ApplicationLayer.class, (Object)lid);
        StartLayer startLayerNull = (StartLayer)entityManager.find(StartLayer.class, (Object)this.testStartLayer.getId());
        Assert.assertNull((Object)appLayerNull);
        Assert.assertNull((Object)startLayerNull);
    }

    @Test
    public void deleteApplication() throws URISyntaxException, SQLException, IOException {
        this.initData(false);
        Assert.assertNotNull((Object)this.testAppLayer);
        Assert.assertNotNull((Object)this.app);
        Assert.assertNotNull((Object)this.testStartLayer);
        long lid = this.testAppLayer.getId();
        entityManager.remove((Object)this.app);
        entityManager.getTransaction().commit();
        entityManager.getTransaction().begin();
        ApplicationLayer shouldBeNull = (ApplicationLayer)entityManager.find(ApplicationLayer.class, (Object)lid);
        StartLayer shouldBeNullAsWell = (StartLayer)entityManager.find(StartLayer.class, (Object)this.testStartLayer.getId());
        Application appShouldBeNull = (Application)entityManager.find(Application.class, (Object)this.app.getId());
        Assert.assertNull((Object)shouldBeNull);
        Assert.assertNull((Object)shouldBeNullAsWell);
        Assert.assertNull((Object)appShouldBeNull);
    }
}

