/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.ConfiguredComponent;
import nl.b3p.viewer.config.app.Level;
import nl.b3p.viewer.config.services.Layer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

public class Authorizations {
    private static final Object LOCK = new Object();
    private static final String ROLES_ATTRIBUTE = Authorizations.class.getName() + ".roles";
    public static final Set<String> NOBODY = new HashSet<String>(Arrays.asList(new String[]{null}));
    public static final Set<String> EVERYBODY = Collections.EMPTY_SET;
    public static final Map<Long, GeoServiceCache> serviceCache = new HashMap<Long, GeoServiceCache>();
    private static final Map<Long, ApplicationCache> applicationCache = new HashMap<Long, ApplicationCache>();
    private static final Map<Long, AppConfiguredComponentsReadersCache> appConfiguredComponentsReadersCache = new HashMap<Long, AppConfiguredComponentsReadersCache>();
    private static final String REQUEST_APP_CACHE = Authorizations.class.getName() + ".REQUEST_APP_CACHE";

    public static Set<String> getRoles(HttpServletRequest request, EntityManager em) {
        if (request.getRemoteUser() == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> roles = (HashSet<String>)request.getAttribute(ROLES_ATTRIBUTE);
        if (roles == null) {
            roles = new HashSet<String>();
            List groups = em.createQuery("select name FROM Group").getResultList();
            for (String group : groups) {
                if (!request.isUserInRole(group)) continue;
                roles.add(group);
            }
            request.setAttribute(ROLES_ATTRIBUTE, roles);
        }
        return roles;
    }

    private static boolean isReadAuthorized(HttpServletRequest request, Read auths, EntityManager em) {
        if (auths == null || auths.readers.equals(EVERYBODY)) {
            return true;
        }
        if (auths.readers.equals(NOBODY)) {
            return false;
        }
        Set<String> roles = Authorizations.getRoles(request, em);
        if (roles.isEmpty()) {
            return false;
        }
        return !Collections.disjoint(auths.readers, roles);
    }

    private static boolean isWriteAuthorized(HttpServletRequest request, ReadWrite auths, EntityManager em) {
        if (!Authorizations.isReadAuthorized(request, auths, em)) {
            return false;
        }
        if (auths == null || auths.writers.equals(EVERYBODY)) {
            return true;
        }
        if (auths.writers.equals(NOBODY)) {
            return false;
        }
        Set<String> roles = Authorizations.getRoles(request, em);
        if (roles.isEmpty()) {
            return false;
        }
        return !Collections.disjoint(auths.writers, roles);
    }

    private static String unauthMsg(HttpServletRequest request, boolean write) {
        return "User " + request.getRemoteUser() == null ? "(none)" : request.getRemoteUser() + " not authorized to " + (write ? "edit " : "access ");
    }

    public static boolean isLayerReadAuthorized(Layer l, HttpServletRequest request, EntityManager em) {
        return Authorizations.isReadAuthorized(request, Authorizations.getLayerAuthorizations(l, em), em);
    }

    public static void checkLayerReadAuthorized(Layer l, HttpServletRequest request, EntityManager em) throws Exception {
        if (!Authorizations.isLayerReadAuthorized(l, request, em)) {
            throw new Exception(Authorizations.unauthMsg(request, false) + " layer #" + l.getId());
        }
    }

    public static boolean isLayerWriteAuthorized(Layer l, HttpServletRequest request, EntityManager em) {
        return Authorizations.isWriteAuthorized(request, Authorizations.getLayerAuthorizations(l, em), em);
    }

    public static void checkLayerWriteAuthorized(Layer l, HttpServletRequest request, EntityManager em) throws Exception {
        if (!Authorizations.isLayerWriteAuthorized(l, request, em)) {
            throw new Exception(Authorizations.unauthMsg(request, true) + " layer #" + l.getId());
        }
    }

    public static boolean isLayerGeomWriteAuthorized(Layer l, HttpServletRequest request, EntityManager em) {
        if (Authorizations.isLayerWriteAuthorized(l, request, em)) {
            Set<String> preventEditGeomGroup = l.getPreventGeomEditors();
            for (String group : preventEditGeomGroup) {
                if (!request.isUserInRole(group)) continue;
                return false;
            }
        }
        return true;
    }

    public static ApplicationCache getApplicationCacheFromRequest(Application app, HttpServletRequest request, EntityManager em) {
        ApplicationCache appCache;
        HashMap<Long, ApplicationCache> requestCache = (HashMap<Long, ApplicationCache>)request.getAttribute(REQUEST_APP_CACHE);
        if (requestCache == null) {
            requestCache = new HashMap<Long, ApplicationCache>();
            request.setAttribute(REQUEST_APP_CACHE, requestCache);
        }
        if ((appCache = (ApplicationCache)requestCache.get(app.getId())) == null) {
            appCache = Authorizations.getApplicationCache(app, em);
            requestCache.put(app.getId(), appCache);
        }
        return appCache;
    }

    public static boolean isApplicationReadAuthorized(Application app, HttpServletRequest request, EntityManager em) {
        Read auths = new Read(app.getReaders());
        return Authorizations.isReadAuthorized(request, auths, em);
    }

    public static boolean isLevelReadAuthorized(Application app, Level l, HttpServletRequest request, EntityManager em) {
        return Authorizations.isLevelReadAuthorized(app, l, request, Authorizations.getApplicationCacheFromRequest(app, request, em), em);
    }

    public static boolean isLevelReadAuthorized(Application app, Level l, HttpServletRequest request, ApplicationCache appCache, EntityManager em) {
        if (app.isAuthenticatedRequired() && request.getRemoteUser() == null) {
            return false;
        }
        if (appCache == null) {
            appCache = Authorizations.getApplicationCache(app, em);
        }
        Read auths = appCache.protectedLevels.get(l.getId());
        return Authorizations.isReadAuthorized(request, auths, em);
    }

    public static void checkLevelReadAuthorized(Application app, Level l, HttpServletRequest request, EntityManager em) throws Exception {
        if (!Authorizations.isLevelReadAuthorized(app, l, request, em)) {
            throw new Exception(Authorizations.unauthMsg(request, false) + " level #" + l.getId());
        }
    }

    public static boolean isAppLayerReadAuthorized(Application app, ApplicationLayer al, HttpServletRequest request, EntityManager em) {
        return Authorizations.isAppLayerReadAuthorized(app, al, request, Authorizations.getApplicationCacheFromRequest(app, request, em), em);
    }

    public static boolean isAppLayerReadAuthorized(Application app, ApplicationLayer al, HttpServletRequest request, ApplicationCache appCache, EntityManager em) {
        if (app == null || app.isAuthenticatedRequired() && request.getRemoteUser() == null) {
            return false;
        }
        if (appCache == null) {
            appCache = Authorizations.getApplicationCache(app, em);
        }
        ReadWrite auths = appCache.protectedAppLayers.get(al.getId());
        return Authorizations.isReadAuthorized(request, auths, em);
    }

    public static void checkAppLayerReadAuthorized(Application app, ApplicationLayer al, HttpServletRequest request, EntityManager em) throws Exception {
        if (!Authorizations.isAppLayerReadAuthorized(app, al, request, em)) {
            throw new Exception(Authorizations.unauthMsg(request, false) + " application layer #" + al.getId());
        }
    }

    public static boolean isAppLayerWriteAuthorized(Application app, ApplicationLayer al, HttpServletRequest request, EntityManager em) {
        return Authorizations.isAppLayerWriteAuthorized(app, al, request, Authorizations.getApplicationCacheFromRequest(app, request, em), em);
    }

    public static boolean isAppLayerWriteAuthorized(Application app, ApplicationLayer al, HttpServletRequest request, ApplicationCache appCache, EntityManager em) {
        if (app == null || app.isAuthenticatedRequired() && request.getRemoteUser() == null) {
            return false;
        }
        if (appCache == null) {
            appCache = Authorizations.getApplicationCache(app, em);
        }
        ReadWrite auths = appCache.protectedAppLayers.get(al.getId());
        return Authorizations.isWriteAuthorized(request, auths, em);
    }

    public static void checkAppLayerWriteAuthorized(Application app, ApplicationLayer al, HttpServletRequest request, EntityManager em) throws Exception {
        if (!Authorizations.isAppLayerWriteAuthorized(app, al, request, em)) {
            throw new Exception(Authorizations.unauthMsg(request, true) + " application layer #" + al.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isConfiguredComponentAuthorized(ConfiguredComponent component, HttpServletRequest request, EntityManager em) {
        Set<String> componentReaders;
        Application app = component.getApplication();
        Long appId = app.getId();
        Map<Long, AppConfiguredComponentsReadersCache> map = appConfiguredComponentsReadersCache;
        synchronized (map) {
            AppConfiguredComponentsReadersCache appCache = appConfiguredComponentsReadersCache.get(appId);
            if (appCache == null || appCache.modified.before(app.getAuthorizationsModified())) {
                appCache = new AppConfiguredComponentsReadersCache();
                appConfiguredComponentsReadersCache.put(appId, appCache);
                appCache.modified = component.getApplication().getAuthorizationsModified();
                appCache.readersByConfiguredComponentId = new HashMap<Long, Set<String>>();
                List readers = Stripersist.getEntityManager().createQuery("select cc.id, r from ConfiguredComponent cc join cc.readers r where cc.application = :app").setParameter("app", (Object)component.getApplication()).getResultList();
                for (Object[] row : readers) {
                    Long ccId = (Long)row[0];
                    String role = (String)row[1];
                    Set<String> roles = appCache.readersByConfiguredComponentId.get(ccId);
                    if (roles == null) {
                        roles = new HashSet<String>();
                        appCache.readersByConfiguredComponentId.put(ccId, roles);
                    }
                    roles.add(role);
                }
            }
            componentReaders = appCache.readersByConfiguredComponentId.get(component.getId());
        }
        if (componentReaders == null) {
            componentReaders = EVERYBODY;
        }
        return Authorizations.isReadAuthorized(request, new Read(componentReaders), em);
    }

    public static void checkConfiguredComponentAuthorized(ConfiguredComponent component, HttpServletRequest request, EntityManager em) throws Exception {
        if (!Authorizations.isReadAuthorized(request, new Read(component.getReaders()), em)) {
            throw new Exception(Authorizations.unauthMsg(request, true) + " configured component #" + component.getName() + " of app #" + component.getApplication().getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReadWrite getLayerAuthorizations(Layer l, EntityManager em) {
        Object object = LOCK;
        synchronized (object) {
            GeoServiceCache cache = serviceCache.get(l.getService().getId());
            if (cache != null && cache.modified.equals(l.getService().getAuthorizationsModified())) {
                return cache.protectedLayers.get(l.getId());
            }
            cache = new GeoServiceCache();
            serviceCache.put(l.getService().getId(), cache);
            cache.modified = l.getService().getAuthorizationsModified();
            cache.protectedLayers = new HashMap<Long, ReadWrite>();
            List<Layer> layers = l.getService().loadLayerTree(em);
            if (!layers.isEmpty()) {
                List<Layer> subList;
                int i = 0;
                do {
                    subList = layers.subList(i, Math.min(layers.size(), i + 500));
                    em.createQuery("from Layer l left join fetch l.readers left join fetch l.writers where l in (:layers)").setParameter("layers", subList).getResultList();
                } while ((i += subList.size()) < layers.size());
            }
            Authorizations.walkLayer(l.getService().getTopLayer(), EVERYBODY, EVERYBODY, cache.protectedLayers, em);
            return cache.protectedLayers.get(l.getId());
        }
    }

    private static Set<String> inheritAuthorizations(Set<String> current, Set<String> _new) {
        if (_new.equals(EVERYBODY)) {
            return current;
        }
        if (current.equals(EVERYBODY)) {
            return new HashSet<String>(_new);
        }
        HashSet<String> copy = new HashSet<String>(current);
        copy.retainAll(_new);
        if (copy.isEmpty()) {
            return NOBODY;
        }
        return copy;
    }

    private static void walkLayer(Layer l, Set<String> currentReaders, Set<String> currentWriters, Map serviceProtectedLayers, EntityManager em) {
        currentReaders = Authorizations.inheritAuthorizations(currentReaders, l.getReaders());
        currentWriters = Authorizations.inheritAuthorizations(currentWriters, l.getWriters());
        if (!currentReaders.equals(EVERYBODY) || !currentWriters.equals(EVERYBODY)) {
            serviceProtectedLayers.put(l.getId(), new ReadWrite(currentReaders, currentWriters));
        }
        for (Layer child : l.getCachedChildren(em)) {
            Authorizations.walkLayer(child, currentReaders, currentWriters, serviceProtectedLayers, em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationCache getApplicationCache(Application app, EntityManager em) {
        Object object = LOCK;
        synchronized (object) {
            ApplicationCache cache = applicationCache.get(app.getId());
            Date allServicesAuthLastChanged = null;
            if (cache != null && !cache.modified.before(app.getAuthorizationsModified())) {
                try {
                    allServicesAuthLastChanged = (Date)em.createQuery("select max(authorizationsModified) from GeoService").getSingleResult();
                    if (allServicesAuthLastChanged != null && !cache.modified.before(allServicesAuthLastChanged)) {
                        return cache;
                    }
                }
                catch (NoResultException noResultException) {
                    // empty catch block
                }
            }
            cache = new ApplicationCache();
            applicationCache.put(app.getId(), cache);
            cache.modified = allServicesAuthLastChanged != null ? (allServicesAuthLastChanged.after(app.getAuthorizationsModified()) ? allServicesAuthLastChanged : app.getAuthorizationsModified()) : app.getAuthorizationsModified();
            cache.protectedLevels = new HashMap<Long, Read>();
            cache.protectedAppLayers = new HashMap<Long, ReadWrite>();
            Application.TreeCache treeCache = app.loadTreeCache(em);
            treeCache.initializeLevels("left join fetch l.readers", em);
            treeCache.initializeApplicationLayers("left join fetch al.readers left join fetch al.writers", em);
            Authorizations.walkLevel(app.getRoot(), EVERYBODY, cache, treeCache, em);
            return cache;
        }
    }

    private static void walkLevel(Level l, Set<String> currentReaders, ApplicationCache cache, Application.TreeCache treeCache, EntityManager em) {
        if (!(currentReaders = Authorizations.inheritAuthorizations(currentReaders, l.getReaders())).equals(EVERYBODY)) {
            cache.protectedLevels.put(l.getId(), new Read(currentReaders));
        }
        for (ApplicationLayer al : l.getLayers()) {
            if (al == null) continue;
            Authorizations.walkAppLayer(al, currentReaders, cache, em);
        }
        for (Level child : treeCache.getChildren(l)) {
            Authorizations.walkLevel(child, currentReaders, cache, treeCache, em);
        }
    }

    private static void walkAppLayer(ApplicationLayer al, Set<String> currentReaders, ApplicationCache cache, EntityManager em) {
        ReadWrite layerAuth;
        currentReaders = Authorizations.inheritAuthorizations(currentReaders, al.getReaders());
        Layer l = al.getService().getLayer(al.getLayerName(), em);
        Set<String> currentWriters = al.getWriters();
        if (l != null && (layerAuth = Authorizations.getLayerAuthorizations(l, em)) != null) {
            currentReaders = Authorizations.inheritAuthorizations(currentReaders, layerAuth.readers);
            currentWriters = Authorizations.inheritAuthorizations(currentWriters, layerAuth.writers);
        }
        if (!currentReaders.equals(EVERYBODY) || !currentWriters.equals(EVERYBODY)) {
            cache.protectedAppLayers.put(al.getId(), new ReadWrite(currentReaders, currentWriters));
        }
    }

    public static class ReadWrite
    extends Read {
        Set<String> writers;

        public ReadWrite(Set<String> readers, Set<String> writers) {
            super(readers);
            this.writers = writers;
        }

        public Set<String> getWriters() {
            return this.writers;
        }

        @Override
        public JSONObject toJSON() throws JSONException {
            JSONObject obj = new JSONObject();
            JSONArray jWriters = new JSONArray(this.writers);
            JSONArray jReaders = new JSONArray((Collection)this.readers);
            obj.put("readers", (Object)jReaders);
            obj.put("writers", (Object)jWriters);
            return obj;
        }
    }

    public static class Read {
        Set<String> readers;

        public Read(Set<String> readers) {
            this.readers = readers;
        }

        public Set<String> getReaders() {
            return this.readers;
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject obj = new JSONObject();
            JSONArray jReaders = new JSONArray(this.readers);
            obj.put("readers", (Object)jReaders);
            return obj;
        }
    }

    public static class AppConfiguredComponentsReadersCache {
        Date modified;
        Map<Long, Set<String>> readersByConfiguredComponentId;
    }

    public static class ApplicationCache {
        Date modified;
        Map<Long, Read> protectedLevels;
        Map<Long, ReadWrite> protectedAppLayers;

        public Date getModified() {
            return this.modified;
        }

        public Map<Long, ReadWrite> getProtectedAppLayers() {
            return this.protectedAppLayers;
        }

        public Map<Long, Read> getProtectedLevels() {
            return this.protectedLevels;
        }
    }

    public static class GeoServiceCache {
        Date modified;
        Map<Long, ReadWrite> protectedLayers;

        public Map<Long, ReadWrite> getProtectedLayers() {
            return this.protectedLayers;
        }

        public Date getModified() {
            return this.modified;
        }
    }
}

