/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.util.databaseupdate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import nl.b3p.viewer.config.metadata.Metadata;
import nl.b3p.viewer.config.stripersist.DynamicStripersistInitializer;
import nl.b3p.viewer.util.databaseupdate.DatabaseSynchronizerEM;
import nl.b3p.viewer.util.databaseupdate.ScriptRunner;
import nl.b3p.viewer.util.databaseupdate.UpdateElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.jdbc.Work;
import org.stripesstuff.stripersist.Stripersist;

public class DatabaseSynchronizer
implements Servlet {
    private static final Log log = LogFactory.getLog(DatabaseSynchronizer.class);
    static final LinkedHashMap<String, UpdateElement> updates = new LinkedHashMap();
    private static final String SCRIPT_PATH = "/scripts";
    private String databaseProductName = "postgresql";
    private static final String[] SUPPORTED_DATABASE_PRODUCTS = new String[]{"postgresql", "oracle"};
    private ServletConfig sc;
    UpdateElement uel = new UpdateElement(new ArrayList<String>(), String.class);

    public static String getUpdateNumber() {
        String update = "";
        for (Map.Entry<String, UpdateElement> e : updates.entrySet()) {
            update = e.getKey();
        }
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInit(EntityManager em) {
        block21: {
            try {
                this.checkScriptDir();
                log.info((Object)"Checking for need to update the database.");
                this.databaseProductName = DynamicStripersistInitializer.databaseProductName;
                if (em == null) break block21;
                Session session = (Session)em.unwrap(Session.class);
                Transaction trans = session.beginTransaction();
                LinkedHashMap<String, UpdateElement> scripts = new LinkedHashMap<String, UpdateElement>();
                Metadata mdVersion = null;
                try {
                    List metadata = em.createQuery("From Metadata where configKey = :v").setParameter("v", (Object)"database_version").getResultList();
                    String version = "init";
                    if (!metadata.isEmpty()) {
                        mdVersion = (Metadata)metadata.get(0);
                        version = mdVersion.getConfigValue();
                        log.info((Object)("Current database version is: " + version));
                    } else {
                        log.warn((Object)"Database already initialized but not valid. Try to execute scripts again.");
                    }
                    scripts = this.getUpdates(version);
                }
                catch (Exception e) {
                    log.warn((Object)"No correct database, run init scripts");
                    log.debug((Object)"Cause: ", (Throwable)e);
                    scripts.put("0", updates.get("0"));
                }
                if (scripts.isEmpty()) {
                    log.info((Object)"Database is up to date. No need for running update scripts");
                } else {
                    String updatedVersion;
                    ScriptWorker w = new ScriptWorker(scripts, em);
                    session.doWork((Work)w);
                    if (w.isErrored()) {
                        log.info((Object)"Database updates returned a error.");
                    }
                    if ((updatedVersion = w.getLatestSuccesVersion()) != null) {
                        if (mdVersion == null) {
                            mdVersion = new Metadata();
                            mdVersion.setConfigKey("database_version");
                        }
                        if (updatedVersion.equals("0")) {
                            updatedVersion = (String)updates.keySet().toArray()[updates.size() - 1];
                        }
                        mdVersion.setConfigValue(updatedVersion);
                        if (em.getTransaction().getRollbackOnly()) {
                            em.getTransaction().rollback();
                        }
                        if (!em.getTransaction().isActive()) {
                            em.getTransaction().begin();
                        }
                        em.persist((Object)mdVersion);
                        em.getTransaction().commit();
                        log.info((Object)("Database updated to version: " + updatedVersion));
                    } else {
                        log.info((Object)"No updates done on database, maybe a error occured");
                    }
                    String neededVersion = (String)updates.keySet().toArray()[updates.size() - 1];
                    String version = "-1";
                    if (mdVersion != null) {
                        version = mdVersion.getConfigValue();
                    }
                    if (!neededVersion.equalsIgnoreCase(version)) {
                        log.warn((Object)("Version of database is: " + version + " while the version must be: " + neededVersion + " Try to do the updates manualy"));
                    } else {
                        log.info((Object)"Database is up to date");
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to execute scripts for updating database", (Throwable)e);
            }
            finally {
                Stripersist.requestComplete();
            }
        }
    }

    private LinkedHashMap<String, UpdateElement> getUpdates(String version) {
        LinkedHashMap<String, UpdateElement> scripts = new LinkedHashMap<String, UpdateElement>();
        boolean versionFound = false;
        for (Map.Entry<String, UpdateElement> entry : updates.entrySet()) {
            if (!versionFound) {
                String v = entry.getKey();
                if (!v.equalsIgnoreCase(version)) continue;
                versionFound = true;
                continue;
            }
            if (!versionFound) continue;
            scripts.put(entry.getKey(), entry.getValue());
        }
        return scripts;
    }

    private void checkScriptDir() {
        File[] scripts;
        File scriptDir = new File(DatabaseSynchronizer.class.getResource(SCRIPT_PATH).getFile());
        if (scriptDir != null && (scripts = scriptDir.listFiles()) != null) {
            for (File script : scripts) {
                String scriptName = null;
                if (script.getName().startsWith(this.databaseProductName.toLowerCase() + "-")) {
                    scriptName = script.getName().substring(this.databaseProductName.length() + 1);
                } else {
                    boolean forOtherProduct = false;
                    for (String supProd : SUPPORTED_DATABASE_PRODUCTS) {
                        if (!script.getName().startsWith(supProd + "-")) continue;
                        forOtherProduct = true;
                    }
                    if (!forOtherProduct) {
                        scriptName = script.getName();
                    }
                }
                if (scriptName == null) continue;
                boolean found = false;
                for (Map.Entry entry : updates.entrySet()) {
                    for (String registeredScript : ((UpdateElement)entry.getValue()).getElements()) {
                        if (!scriptName.equals(registeredScript)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                log.warn((Object)("The sql script " + script.getAbsolutePath() + " is not registered in a update. The script is not used to updated the database. Is this correct? Otherwise add the script to the var DatabaseSynchronizer.updates."));
            }
        }
    }

    public void init(ServletConfig sc) throws ServletException {
        this.sc = sc;
        Stripersist.requestInit();
        EntityManager em = Stripersist.getEntityManager();
        this.doInit(em);
    }

    public ServletConfig getServletConfig() {
        return this.sc;
    }

    public void service(ServletRequest sr, ServletResponse sr1) throws ServletException, IOException {
    }

    public String getServletInfo() {
        return "";
    }

    public void destroy() {
    }

    static {
        updates.put("init", new UpdateElement(new ArrayList<String>(), String.class));
        updates.put("0", new UpdateElement(new ArrayList<String>(), String.class));
        updates.get("0").add("schema-export.sql");
        updates.get("0").add("initialize_database.sql");
        updates.put("1", new UpdateElement(new ArrayList<String>(), String.class));
        updates.get("1").add("add_solr_config.sql");
        updates.put("2", new UpdateElement(new ArrayList<String>(), String.class));
        updates.get("2").add("update_solr_config.sql");
        updates.put("3", new UpdateElement(new ArrayList<String>(), String.class));
        updates.get("3").add("add_url_level.sql");
        updates.put("4", new UpdateElement(new ArrayList<String>(), String.class));
        updates.get("4").add("configure_exception_layer.sql");
        updates.put("5", new UpdateElement(new ArrayList<String>(), String.class));
        updates.get("5").add("add_cyclorama_account.sql");
        updates.put("6", new UpdateElement(Collections.singletonList("alter_layer_children_child_unique.sql"), String.class));
        updates.put("7", new UpdateElement(Collections.singletonList("add_application_to_bookmark.sql"), String.class));
        updates.put("8", new UpdateElement(Collections.singletonList("add_layer_prevent_geom_editors.sql"), String.class));
        updates.put("9", new UpdateElement(Collections.singletonList("selectedcontentcaches_dirty.sql"), String.class));
        updates.put("10", new UpdateElement(Collections.singletonList("add_allowValueListOnly.sql"), String.class));
        updates.put("11", new UpdateElement(Collections.singletonList("add_valueListFeatureSource.sql"), String.class));
        updates.put("12", new UpdateElement(Collections.singletonList("add_start_map.sql"), String.class));
        updates.put("13", new UpdateElement(Collections.singletonList("add_linked_components.sql"), String.class));
        updates.put("14", new UpdateElement(Collections.singletonList("add_disableEditing.sql"), String.class));
        updates.put("16", new UpdateElement(Collections.singletonList("add_application_rights.sql"), String.class));
        updates.put("17", new UpdateElement(Collections.singletonList("solrconf_reference_to_value.sql"), String.class));
        updates.put("18", new UpdateElement(Collections.singletonList("idx_layer_crs_list.sql"), String.class));
        updates.put("19", new UpdateElement(Collections.singletonList("add_label_configured_attribute.sql"), String.class));
        updates.put("20", new UpdateElement(Collections.singletonList("updateApplicationLayersAttributesOrder"), DatabaseSynchronizerEM.class));
        updates.put("21", new UpdateElement(Collections.singletonList("remove_selectedIndexChecked.sql"), String.class));
        updates.put("22", new UpdateElement(Collections.singletonList("add_user_ips.sql"), String.class));
        updates.put("23", new UpdateElement(Collections.singletonList("removeDuplicateStartLayersLevels.sql"), String.class));
        updates.put("24", new UpdateElement(Collections.singletonList("removeFaultyTopLayers.sql"), String.class));
        updates.put("25", new UpdateElement(Collections.singletonList("alter_layer_children_child_unique.sql"), String.class));
        updates.put("26", new UpdateElement(Collections.singletonList("add-wmts-support.sql"), String.class));
        updates.put("27", new UpdateElement(Collections.singletonList("fix_removed_startlayers_levels.sql"), String.class));
        updates.put("28", new UpdateElement(Collections.singletonList("add_geoservice_rights.sql"), String.class));
    }

    public class ScriptWorker
    implements Work {
        LinkedHashMap<String, UpdateElement> updateScripts;
        private String successVersion = null;
        private boolean errored = false;
        private EntityManager em;

        public ScriptWorker(LinkedHashMap<String, UpdateElement> scripts, EntityManager em) {
            this.updateScripts = scripts;
            this.em = em;
        }

        public void execute(Connection cnctn) throws SQLException {
            ScriptRunner runner = new ScriptRunner(cnctn, true, true);
            for (Map.Entry<String, UpdateElement> entry : this.updateScripts.entrySet()) {
                UpdateElement element = entry.getValue();
                if (element.getClazz() == String.class) {
                    for (String script : element.getElements()) {
                        InputStream is = null;
                        try {
                            String scriptName = "/scripts/" + script;
                            is = DatabaseSynchronizer.class.getResourceAsStream(scriptName);
                            if (is == null) {
                                scriptName = "/scripts/" + DatabaseSynchronizer.this.databaseProductName.toLowerCase() + "-" + script;
                                is = DatabaseSynchronizer.class.getResourceAsStream(scriptName);
                            }
                            if (is == null) {
                                throw new Exception("Update script '" + script + "' nor '" + DatabaseSynchronizer.this.databaseProductName.toLowerCase() + "-" + script + "' can be found");
                            }
                            log.info((Object)("Running database upgrade script: " + scriptName));
                            runner.runScript(new InputStreamReader(is));
                            if (this.errored) continue;
                            this.successVersion = entry.getKey();
                        }
                        catch (Exception ex) {
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException ioe) {
                                log.error((Object)"Exception while closing InputStream", (Throwable)ioe);
                            }
                            log.error((Object)("Error while executing script: " + script), (Throwable)ex);
                            this.errored = true;
                            break;
                        }
                    }
                } else if (element.getClazz() == DatabaseSynchronizerEM.class) {
                    try {
                        List<String> methods = element.getElements();
                        DatabaseSynchronizerEM dsem = new DatabaseSynchronizerEM();
                        for (String method : methods) {
                            Method m = dsem.getClass().getMethod(method, EntityManager.class);
                            Object object = m.invoke((Object)dsem, this.em);
                        }
                    }
                    catch (Exception e) {
                        this.errored = true;
                        log.error((Object)"Cannot run updatemethod", (Throwable)e);
                    }
                    if (!this.errored) {
                        this.successVersion = entry.getKey();
                    }
                }
                if (!this.isErrored()) continue;
                break;
            }
        }

        public boolean isErrored() {
            return this.errored;
        }

        public String getLatestSuccesVersion() {
            return this.successVersion;
        }
    }
}

