/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.util.databaseupdate;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.persistence.EntityManager;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.ConfiguredAttribute;
import nl.b3p.viewer.config.services.FeatureTypeRelation;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatabaseSynchronizerEM {
    private static final Log log = LogFactory.getLog(DatabaseSynchronizerEM.class);

    public void updateApplicationLayersAttributesOrder(EntityManager em) {
        List appLayers = em.createQuery("From ApplicationLayer").getResultList();
        for (ApplicationLayer applicationLayer : appLayers) {
            Layer layer = applicationLayer.getService().getSingleLayer(applicationLayer.getLayerName(), em);
            if (layer == null) continue;
            this.updateAttributeOrder(applicationLayer, layer.getFeatureType(), em);
        }
    }

    void updateAttributeOrder(ApplicationLayer applicationLayer, final SimpleFeatureType layerSft, EntityManager em) {
        List<ConfiguredAttribute> cas = applicationLayer.getAttributes();
        log.info((Object)("Sorting layer " + applicationLayer.getLayerName()));
        Collections.sort(cas, new Comparator<ConfiguredAttribute>(){

            @Override
            public int compare(ConfiguredAttribute o1, ConfiguredAttribute o2) {
                if (layerSft == null) {
                    return -1;
                }
                if (o1.getFeatureType() == null) {
                    return -1;
                }
                if (o2.getFeatureType() == null) {
                    return 1;
                }
                if (o1.getFeatureType().getId().equals(layerSft.getId())) {
                    return -1;
                }
                if (o2.getFeatureType().getId().equals(layerSft.getId())) {
                    return 1;
                }
                return o1.getFeatureType().getId().compareTo(o2.getFeatureType().getId());
            }
        });
        if (layerSft != null) {
            this.sortPerFeatureType(layerSft, cas);
        }
        applicationLayer.setAttributes(cas);
        em.persist((Object)applicationLayer);
    }

    private void sortPerFeatureType(final SimpleFeatureType layerSft, List<ConfiguredAttribute> cas) {
        List<FeatureTypeRelation> relations = layerSft.getRelations();
        for (FeatureTypeRelation relation : relations) {
            SimpleFeatureType foreign = relation.getForeignFeatureType();
            this.sortPerFeatureType(foreign, cas);
        }
        Collections.sort(cas, new Comparator<ConfiguredAttribute>(){

            @Override
            public int compare(ConfiguredAttribute o1, ConfiguredAttribute o2) {
                if (o1.getFeatureType() == null) {
                    return 0;
                }
                if (o2.getFeatureType() == null) {
                    return 0;
                }
                if (o1.getFeatureType().getId().equals(layerSft.getId()) && o2.getFeatureType().getId().equals(layerSft.getId())) {
                    return o1.getAttributeName().compareTo(o2.getAttributeName());
                }
                return 0;
            }
        });
        for (ConfiguredAttribute ca : cas) {
            log.info((Object)ca.getAttributeName());
        }
    }
}

