
    alter table application 
        drop constraint FK5CA40550AFA2FE1D;

    alter table application 
        drop constraint FK5CA40550EE90884A;

    alter table application_details 
        drop constraint FKD9A4E532A91FB84;

    alter table application_layer 
        drop constraint FKFB01A255F7BD5A;

    alter table application_layer_attributes 
        drop constraint FKD41041446FB11F;

    alter table application_layer_attributes 
        drop constraint FKD4104148017EC25;

    alter table application_layer_details 
        drop constraint FKD720D8A546FB11F;

    alter table application_layer_readers 
        drop constraint FKBAADA67346FB11F;

    alter table application_layer_writers 
        drop constraint FKD9D3D0C346FB11F;

    alter table application_readers 
        drop constraint FKF1271C212A91FB84;

    alter table bookmark 
        drop constraint FK7787A5362A91FB84;

    alter table category 
        drop constraint FK302BCFE433C669;

    alter table category_children 
        drop constraint FKF77E9020428B7ABD;

    alter table category_children 
        drop constraint FKF77E9020452CB2DB;

    alter table category_readers 
        drop constraint FKB6245CF428B7ABD;

    alter table category_services 
        drop constraint FKE6C9427F55F7BD5A;

    alter table category_services 
        drop constraint FKE6C9427F428B7ABD;

    alter table category_writers 
        drop constraint FK2A88701F428B7ABD;

    alter table configured_attribute 
        drop constraint FK521A69DBB7916580;

    alter table configured_attribute 
        drop constraint FK521A69DBEC20F033;

    alter table configured_attribute 
        drop constraint FK521A69DB72DC0207;

    alter table configured_component 
        drop constraint FKFDE1DC3C2A91FB84;

    alter table configured_component 
        drop constraint FKFDE1DC3CFD682FC4;

    alter table configured_component_details 
        drop constraint FK5B8793F1193917F;

    alter table configured_component_readers 
        drop constraint FKE945470D1193917F;

    alter table feature_source 
        drop constraint FK8DE1C984D576E134;

    alter table feature_source_feature_types 
        drop constraint FK57524A75B7916580;

    alter table feature_source_feature_types 
        drop constraint FK57524A7524045814;

    alter table feature_type 
        drop constraint FK481336E324045814;

    alter table feature_type_attributes 
        drop constraint FKA280AC33B7916580;

    alter table feature_type_attributes 
        drop constraint FKA280AC33C22478BC;

    alter table feature_type_relation 
        drop constraint FK1CA203D8B7916580;

    alter table feature_type_relation 
        drop constraint FK1CA203D8C6F0470B;

    alter table feature_type_relation_key 
        drop constraint FK31F9257826403964;

    alter table feature_type_relation_key 
        drop constraint FK31F92578E0CA5659;

    alter table feature_type_relation_key 
        drop constraint FK31F92578AD91C807;

    alter table geo_service 
        drop constraint FK957D1BC7428B7ABD;

    alter table geo_service 
        drop constraint FK957D1BC72B2D5A17;

    alter table geo_service_details 
        drop constraint FK2ACCFDCA292680E9;

    alter table geo_service_keywords 
        drop constraint FKFBC05227531126C;

    alter table geo_service_readers 
        drop constraint FKE59CB987531126C;

    alter table geo_service_style_libraries 
        drop constraint FK95F125137531126C;

    alter table geo_service_style_libraries 
        drop constraint FK95F1251313076638;

    alter table layar_source 
        drop constraint FKFC8466C5B7916580;

    alter table layar_source 
        drop constraint FKFC8466C580F5B5AC;

    alter table layar_source_details 
        drop constraint FK7ED06AC81E0B97B4;

    alter table layer 
        drop constraint FK61FD551B7916580;

    alter table layer 
        drop constraint FK61FD551E93D7CDA;

    alter table layer 
        drop constraint FK61FD551AF8870E7;

    alter table layer 
        drop constraint FK61FD55155F7BD5A;

    alter table layer_bounding_boxes 
        drop constraint FK5D360E0C2AB24981;

    alter table layer_children 
        drop constraint FK3B6C252D2AB24981;

    alter table layer_children 
        drop constraint FK3B6C252D2A36694C;

    alter table layer_crs_list 
        drop constraint FK5CC73D472AB24981;

    alter table layer_details 
        drop constraint FK3A8A8D542AB24981;

    alter table layer_keywords 
        drop constraint FKF7B066D82AB24981;

    alter table layer_matrix_sets 
        drop constraint FK118A64219EBB0496;

    alter table layer_matrix_sets 
        drop constraint FK118A64212AB24981;

    alter table layer_prevent_geom_editors 
        drop constraint FKF2CC57D82AB24981;

    alter table layer_readers 
        drop constraint FK1E175B222AB24981;

    alter table layer_writers 
        drop constraint FK3D3D85722AB24981;

    alter table level_ 
        drop constraint FKBE11D55BB3061012;

    alter table level_children 
        drop constraint FK24AAA85AAC6CDCC3;

    alter table level_children 
        drop constraint FK24AAA85AF3FEFC84;

    alter table level_documents 
        drop constraint FKAE8653BDA33FA2F7;

    alter table level_documents 
        drop constraint FKAE8653BDAC6CDCC3;

    alter table level_layers 
        drop constraint FK484FFA5DAC6CDCC3;

    alter table level_layers 
        drop constraint FK484FFA5D99484CE;

    alter table level_readers 
        drop constraint FK4953E55AC6CDCC3;

    alter table solr_conf 
        drop constraint FKBE7330614AC66EED;

    alter table solr_conf_index_attributes 
        drop constraint FKC4645F0253A60848;

    alter table solr_conf_result_attributes 
        drop constraint FKF0AA165B53A60848;

    alter table start_layer 
        drop constraint FKA4C6AB342A91FB84;

    alter table start_layer 
        drop constraint FKA4C6AB3446FB11F;

    alter table start_level 
        drop constraint FKA4C871672A91FB84;

    alter table start_level 
        drop constraint FKA4C87167AC6CDCC3;

    alter table tile_matrix 
        drop constraint FK937382729EBB0496;

    alter table tile_matrix_set 
        drop constraint FKD055E515591F39EA;

    alter table tile_set_resolutions 
        drop constraint FKA1D2C15980656544;

    alter table user_details 
        drop constraint FKB7C889CE99789440;

    alter table user_groups 
        drop constraint FKE27720C8360AA480;

    alter table user_groups 
        drop constraint FKE27720C899789440;

    alter table user_ips 
        drop constraint FKF022D5B8AFF5995E;

    drop table application if exists;

    drop table application_details if exists;

    drop table application_layer if exists;

    drop table application_layer_attributes if exists;

    drop table application_layer_details if exists;

    drop table application_layer_readers if exists;

    drop table application_layer_writers if exists;

    drop table application_readers if exists;

    drop table attribute_descriptor if exists;

    drop table bookmark if exists;

    drop table category if exists;

    drop table category_children if exists;

    drop table category_readers if exists;

    drop table category_services if exists;

    drop table category_writers if exists;

    drop table configured_attribute if exists;

    drop table configured_component if exists;

    drop table configured_component_details if exists;

    drop table configured_component_readers if exists;

    drop table cyclorama_account if exists;

    drop table document if exists;

    drop table feature_source if exists;

    drop table feature_source_feature_types if exists;

    drop table feature_type if exists;

    drop table feature_type_attributes if exists;

    drop table feature_type_relation if exists;

    drop table feature_type_relation_key if exists;

    drop table geo_service if exists;

    drop table geo_service_details if exists;

    drop table geo_service_keywords if exists;

    drop table geo_service_readers if exists;

    drop table geo_service_style_libraries if exists;

    drop table group_ if exists;

    drop table layar_service if exists;

    drop table layar_source if exists;

    drop table layar_source_details if exists;

    drop table layer if exists;

    drop table layer_bounding_boxes if exists;

    drop table layer_children if exists;

    drop table layer_crs_list if exists;

    drop table layer_details if exists;

    drop table layer_keywords if exists;

    drop table layer_matrix_sets if exists;

    drop table layer_prevent_geom_editors if exists;

    drop table layer_readers if exists;

    drop table layer_writers if exists;

    drop table level_ if exists;

    drop table level_children if exists;

    drop table level_documents if exists;

    drop table level_layers if exists;

    drop table level_readers if exists;

    drop table metadata if exists;

    drop table resource_ if exists;

    drop table solr_conf if exists;

    drop table solr_conf_index_attributes if exists;

    drop table solr_conf_result_attributes if exists;

    drop table start_layer if exists;

    drop table start_level if exists;

    drop table style_library if exists;

    drop table tile_matrix if exists;

    drop table tile_matrix_set if exists;

    drop table tile_set if exists;

    drop table tile_set_resolutions if exists;

    drop table user_ if exists;

    drop table user_details if exists;

    drop table user_groups if exists;

    drop table user_ips if exists;

    create table application (
        id bigint generated by default as identity (start with 1),
        authenticated_required bit not null,
        authorizations_modified timestamp not null,
        layout clob,
        max_crs varchar(255),
        max_maxx double,
        max_maxy double,
        max_minx double,
        max_miny double,
        name varchar(255) not null,
        start_crs varchar(255),
        start_maxx double,
        start_maxy double,
        start_minx double,
        start_miny double,
        version varchar(30),
        owner varchar(255),
        root bigint,
        primary key (id),
        unique (name, version)
    );

    create table application_details (
        application bigint not null,
        value clob,
        details_key varchar(255),
        primary key (application, details_key)
    );

    create table application_layer (
        id bigint generated by default as identity (start with 1),
        layer_name varchar(255) not null,
        service bigint,
        primary key (id)
    );

    create table application_layer_attributes (
        application_layer bigint not null,
        attribute_ bigint not null,
        list_index integer not null,
        primary key (application_layer, list_index)
    );

    create table application_layer_details (
        application_layer bigint not null,
        value clob,
        details_key varchar(255),
        primary key (application_layer, details_key)
    );

    create table application_layer_readers (
        application_layer bigint not null,
        role_name varchar(255)
    );

    create table application_layer_writers (
        application_layer bigint not null,
        role_name varchar(255)
    );

    create table application_readers (
        application bigint not null,
        role_name varchar(255)
    );

    create table attribute_descriptor (
        id bigint generated by default as identity (start with 1),
        name_alias varchar(255),
        name varchar(255) not null,
        type varchar(255),
        primary key (id)
    );

    create table bookmark (
        id bigint generated by default as identity (start with 1),
        code varchar(255),
        created_at timestamp,
        created_by varchar(255),
        params clob not null,
        application bigint,
        primary key (id),
        unique (code, application)
    );

    create table category (
        id bigint generated by default as identity (start with 1),
        name varchar(255) not null,
        parent bigint,
        primary key (id),
        unique (parent, name)
    );

    create table category_children (
        category bigint not null,
        child bigint not null,
        list_index integer not null,
        primary key (category, list_index)
    );

    create table category_readers (
        category bigint not null,
        role_name varchar(255)
    );

    create table category_services (
        category bigint not null,
        service bigint not null,
        list_index integer not null,
        primary key (category, list_index)
    );

    create table category_writers (
        category bigint not null,
        role_name varchar(255)
    );

    create table configured_attribute (
        id bigint generated by default as identity (start with 1),
        allow_value_list_only bit not null,
        attribute_name varchar(255),
        default_value varchar(255),
        disable_user_edit bit not null,
        disallow_null_value bit not null,
        edit_alias varchar(255),
        edit_height varchar(255),
        edit_values clob,
        editable bit not null,
        filterable bit not null,
        label varchar(255),
        selectable bit not null,
        value_list varchar(255),
        value_list_label_name varchar(255),
        value_list_value_name varchar(255),
        visible bit not null,
        feature_type bigint,
        value_list_feature_source bigint,
        value_list_feature_type bigint,
        primary key (id)
    );

    create table configured_component (
        id bigint generated by default as identity (start with 1),
        class_name varchar(255) not null,
        config clob,
        name varchar(255) not null,
        application bigint not null,
        mother_component bigint,
        primary key (id),
        unique (name, application)
    );

    create table configured_component_details (
        configured_component bigint not null,
        details varchar(255),
        details_key varchar(255),
        primary key (configured_component, details_key)
    );

    create table configured_component_readers (
        configured_component bigint not null,
        role_name varchar(255)
    );

    create table cyclorama_account (
        id bigint generated by default as identity (start with 1),
        filename varchar(255),
        password varchar(255),
        private_base64key clob,
        username varchar(255),
        primary key (id)
    );

    create table document (
        id bigint generated by default as identity (start with 1),
        category varchar(255),
        name varchar(255) not null,
        url varchar(255) not null,
        primary key (id)
    );

    create table feature_source (
        protocol varchar(31) not null,
        id bigint generated by default as identity (start with 1),
        name varchar(255) not null,
        password varchar(255),
        url varchar(255) not null,
        username varchar(255),
        db_schema varchar(255),
        service_name varchar(255),
        linked_service bigint,
        primary key (id)
    );

    create table feature_source_feature_types (
        feature_source bigint not null,
        feature_type bigint not null,
        list_index integer not null,
        primary key (feature_source, list_index)
    );

    create table feature_type (
        id bigint generated by default as identity (start with 1),
        description varchar(255),
        geometry_attribute varchar(255),
        type_name varchar(255),
        writeable bit not null,
        feature_source bigint,
        primary key (id)
    );

    create table feature_type_attributes (
        feature_type bigint not null,
        attribute_descriptor bigint not null,
        list_index integer not null,
        primary key (feature_type, list_index)
    );

    create table feature_type_relation (
        id bigint generated by default as identity (start with 1),
        type varchar(255),
        feature_type bigint,
        foreign_feature_type bigint,
        primary key (id)
    );

    create table feature_type_relation_key (
        id bigint generated by default as identity (start with 1),
        left_side bigint,
        relation bigint,
        right_side bigint,
        primary key (id)
    );

    create table geo_service (
        protocol varchar(31) not null,
        id bigint generated by default as identity (start with 1),
        authorizations_modified timestamp not null,
        monitoring_enabled bit not null,
        monitoring_statusok bit not null,
        name varchar(255) not null,
        password varchar(255),
        url varchar(255) not null,
        username varchar(255),
        service_name varchar(255),
        tiling_protocol varchar(255),
        exception_type varchar(255),
        override_url bit,
        category bigint,
        top_layer bigint,
        primary key (id)
    );

    create table geo_service_details (
        geoservice bigint not null,
        value clob,
        details_key varchar(255),
        primary key (geoservice, details_key)
    );

    create table geo_service_keywords (
        geo_service bigint not null,
        keyword varchar(255)
    );

    create table geo_service_readers (
        geo_service bigint not null,
        role_name varchar(255)
    );

    create table geo_service_style_libraries (
        geo_service bigint not null,
        style_library bigint not null,
        list_index integer not null,
        primary key (geo_service, list_index),
        unique (style_library)
    );

    create table group_ (
        name varchar(255) not null,
        description clob,
        primary key (name)
    );

    create table layar_service (
        id bigint generated by default as identity (start with 1),
        name varchar(255) not null,
        primary key (id),
        unique (name)
    );

    create table layar_source (
        id bigint generated by default as identity (start with 1),
        feature_type bigint,
        layar_service bigint,
        primary key (id)
    );

    create table layar_source_details (
        layar_source bigint not null,
        value clob,
        details_key varchar(255),
        primary key (layar_source, details_key)
    );

    create table layer (
        id bigint generated by default as identity (start with 1),
        filterable bit not null,
        legend_image_url clob,
        max_scale double,
        min_scale double,
        name varchar(255),
        queryable bit not null,
        title varchar(255),
        title_alias varchar(255),
        virtual bit not null,
        feature_type bigint,
        parent bigint,
        service bigint,
        tileset varchar(255),
        primary key (id)
    );

    create table layer_bounding_boxes (
        layer bigint not null,
        name varchar(255),
        maxx double,
        maxy double,
        minx double,
        miny double,
        crs varchar(255),
        primary key (layer, crs)
    );

    create table layer_children (
        layer bigint not null,
        child bigint not null,
        list_index integer not null,
        primary key (layer, list_index),
        unique (child)
    );

    create table layer_crs_list (
        layer bigint not null,
        crs varchar(255)
    );

    create table layer_details (
        layer bigint not null,
        value clob,
        details_key varchar(255),
        primary key (layer, details_key)
    );

    create table layer_keywords (
        layer bigint not null,
        keyword varchar(255)
    );

    create table layer_matrix_sets (
        layer bigint not null,
        matrix_set bigint not null,
        list_index integer not null,
        primary key (layer, list_index)
    );

    create table layer_prevent_geom_editors (
        layer bigint not null,
        role_name varchar(255)
    );

    create table layer_readers (
        layer bigint not null,
        role_name varchar(255)
    );

    create table layer_writers (
        layer bigint not null,
        role_name varchar(255)
    );

    create table level_ (
        id bigint generated by default as identity (start with 1),
        background bit not null,
        info clob,
        name varchar(255) not null,
        url varchar(255),
        parent bigint,
        primary key (id)
    );

    create table level_children (
        level_ bigint not null,
        child bigint not null,
        list_index integer not null,
        primary key (level_, list_index)
    );

    create table level_documents (
        level_ bigint not null,
        document bigint not null,
        list_index integer not null,
        primary key (level_, list_index)
    );

    create table level_layers (
        level_ bigint not null,
        layer bigint not null,
        list_index integer not null,
        primary key (level_, list_index)
    );

    create table level_readers (
        level_ bigint not null,
        role_name varchar(255)
    );

    create table metadata (
        id bigint generated by default as identity (start with 1),
        config_key varchar(255),
        config_value varchar(255),
        primary key (id)
    );

    create table resource_ (
        name varchar(255) not null,
        content_type varchar(255),
        data_ BINARY not null,
        modified timestamp not null,
        size_ bigint not null,
        primary key (name)
    );

    create table solr_conf (
        id bigint generated by default as identity (start with 1),
        last_updated timestamp,
        name varchar(255),
        simple_feature_type bigint,
        primary key (id)
    );

    create table solr_conf_index_attributes (
        solr_conf bigint not null,
        attribute_ varchar(255)
    );

    create table solr_conf_result_attributes (
        solr_conf bigint not null,
        attribute_ varchar(255)
    );

    create table start_layer (
        id bigint generated by default as identity (start with 1),
        checked bit not null,
        removed bit not null,
        selected_index integer,
        application bigint,
        application_layer bigint,
        primary key (id)
    );

    create table start_level (
        id bigint generated by default as identity (start with 1),
        removed bit not null,
        selected_index integer,
        application bigint,
        level_ bigint,
        primary key (id)
    );

    create table style_library (
        id bigint generated by default as identity (start with 1),
        default_style bit not null,
        external_url varchar(1000),
        extra_legend_parameters varchar(255),
        named_layer_user_styles_json clob,
        sld_body clob,
        title varchar(255) not null,
        primary key (id)
    );

    create table tile_matrix (
        id bigint generated by default as identity (start with 1),
        description varchar(255),
        identifier varchar(255),
        matrix_height integer not null,
        matrix_width integer not null,
        scale_denominator varchar(255),
        tile_height integer not null,
        tile_width integer not null,
        title varchar(255),
        top_left_corner varchar(255),
        matrix_set bigint,
        primary key (id)
    );

    create table tile_matrix_set (
        id bigint generated by default as identity (start with 1),
        max_crs varchar(255),
        max_maxx double,
        max_maxy double,
        max_minx double,
        max_miny double,
        crs varchar(255),
        identifier varchar(255),
        tile_service bigint,
        primary key (id)
    );

    create table tile_set (
        name varchar(255) not null,
        height integer not null,
        width integer not null,
        primary key (name)
    );

    create table tile_set_resolutions (
        tile_set varchar(255) not null,
        resolution double,
        list_index integer not null,
        primary key (tile_set, list_index)
    );

    create table user_ (
        username varchar(255) not null,
        password varchar(255),
        primary key (username)
    );

    create table user_details (
        username varchar(255) not null,
        details varchar(255),
        details_key varchar(255),
        primary key (username, details_key)
    );

    create table user_groups (
        username varchar(255) not null,
        group_ varchar(255) not null,
        primary key (username, group_)
    );

    create table user_ips (
        user_ varchar(255) not null,
        ipaddress varchar(45)
    );

    alter table application 
        add constraint FK5CA40550AFA2FE1D 
        foreign key (owner) 
        references user_;

    alter table application 
        add constraint FK5CA40550EE90884A 
        foreign key (root) 
        references level_;

    alter table application_details 
        add constraint FKD9A4E532A91FB84 
        foreign key (application) 
        references application;

    alter table application_layer 
        add constraint FKFB01A255F7BD5A 
        foreign key (service) 
        references geo_service;

    alter table application_layer_attributes 
        add constraint FKD41041446FB11F 
        foreign key (application_layer) 
        references application_layer;

    alter table application_layer_attributes 
        add constraint FKD4104148017EC25 
        foreign key (attribute_) 
        references configured_attribute;

    alter table application_layer_details 
        add constraint FKD720D8A546FB11F 
        foreign key (application_layer) 
        references application_layer;

    alter table application_layer_readers 
        add constraint FKBAADA67346FB11F 
        foreign key (application_layer) 
        references application_layer;

    alter table application_layer_writers 
        add constraint FKD9D3D0C346FB11F 
        foreign key (application_layer) 
        references application_layer;

    alter table application_readers 
        add constraint FKF1271C212A91FB84 
        foreign key (application) 
        references application;

    alter table bookmark 
        add constraint FK7787A5362A91FB84 
        foreign key (application) 
        references application;

    alter table category 
        add constraint FK302BCFE433C669 
        foreign key (parent) 
        references category;

    alter table category_children 
        add constraint FKF77E9020428B7ABD 
        foreign key (category) 
        references category;

    alter table category_children 
        add constraint FKF77E9020452CB2DB 
        foreign key (child) 
        references category;

    alter table category_readers 
        add constraint FKB6245CF428B7ABD 
        foreign key (category) 
        references category;

    alter table category_services 
        add constraint FKE6C9427F55F7BD5A 
        foreign key (service) 
        references geo_service;

    alter table category_services 
        add constraint FKE6C9427F428B7ABD 
        foreign key (category) 
        references category;

    alter table category_writers 
        add constraint FK2A88701F428B7ABD 
        foreign key (category) 
        references category;

    alter table configured_attribute 
        add constraint FK521A69DBB7916580 
        foreign key (feature_type) 
        references feature_type;

    alter table configured_attribute 
        add constraint FK521A69DBEC20F033 
        foreign key (value_list_feature_type) 
        references feature_type;

    alter table configured_attribute 
        add constraint FK521A69DB72DC0207 
        foreign key (value_list_feature_source) 
        references feature_source;

    alter table configured_component 
        add constraint FKFDE1DC3C2A91FB84 
        foreign key (application) 
        references application;

    alter table configured_component 
        add constraint FKFDE1DC3CFD682FC4 
        foreign key (mother_component) 
        references configured_component;

    alter table configured_component_details 
        add constraint FK5B8793F1193917F 
        foreign key (configured_component) 
        references configured_component;

    alter table configured_component_readers 
        add constraint FKE945470D1193917F 
        foreign key (configured_component) 
        references configured_component;

    alter table feature_source 
        add constraint FK8DE1C984D576E134 
        foreign key (linked_service) 
        references geo_service;

    alter table feature_source_feature_types 
        add constraint FK57524A75B7916580 
        foreign key (feature_type) 
        references feature_type;

    alter table feature_source_feature_types 
        add constraint FK57524A7524045814 
        foreign key (feature_source) 
        references feature_source;

    alter table feature_type 
        add constraint FK481336E324045814 
        foreign key (feature_source) 
        references feature_source;

    alter table feature_type_attributes 
        add constraint FKA280AC33B7916580 
        foreign key (feature_type) 
        references feature_type;

    alter table feature_type_attributes 
        add constraint FKA280AC33C22478BC 
        foreign key (attribute_descriptor) 
        references attribute_descriptor;

    alter table feature_type_relation 
        add constraint FK1CA203D8B7916580 
        foreign key (feature_type) 
        references feature_type;

    alter table feature_type_relation 
        add constraint FK1CA203D8C6F0470B 
        foreign key (foreign_feature_type) 
        references feature_type;

    alter table feature_type_relation_key 
        add constraint FK31F9257826403964 
        foreign key (right_side) 
        references attribute_descriptor;

    alter table feature_type_relation_key 
        add constraint FK31F92578E0CA5659 
        foreign key (left_side) 
        references attribute_descriptor;

    alter table feature_type_relation_key 
        add constraint FK31F92578AD91C807 
        foreign key (relation) 
        references feature_type_relation;

    alter table geo_service 
        add constraint FK957D1BC7428B7ABD 
        foreign key (category) 
        references category;

    alter table geo_service 
        add constraint FK957D1BC72B2D5A17 
        foreign key (top_layer) 
        references layer;

    alter table geo_service_details 
        add constraint FK2ACCFDCA292680E9 
        foreign key (geoservice) 
        references geo_service;

    alter table geo_service_keywords 
        add constraint FKFBC05227531126C 
        foreign key (geo_service) 
        references geo_service;

    alter table geo_service_readers 
        add constraint FKE59CB987531126C 
        foreign key (geo_service) 
        references geo_service;

    alter table geo_service_style_libraries 
        add constraint FK95F125137531126C 
        foreign key (geo_service) 
        references geo_service;

    alter table geo_service_style_libraries 
        add constraint FK95F1251313076638 
        foreign key (style_library) 
        references style_library;

    alter table layar_source 
        add constraint FKFC8466C5B7916580 
        foreign key (feature_type) 
        references feature_type;

    alter table layar_source 
        add constraint FKFC8466C580F5B5AC 
        foreign key (layar_service) 
        references layar_service;

    alter table layar_source_details 
        add constraint FK7ED06AC81E0B97B4 
        foreign key (layar_source) 
        references layar_source;

    alter table layer 
        add constraint FK61FD551B7916580 
        foreign key (feature_type) 
        references feature_type;

    alter table layer 
        add constraint FK61FD551E93D7CDA 
        foreign key (parent) 
        references layer;

    alter table layer 
        add constraint FK61FD551AF8870E7 
        foreign key (tileset) 
        references tile_set;

    alter table layer 
        add constraint FK61FD55155F7BD5A 
        foreign key (service) 
        references geo_service;

    alter table layer_bounding_boxes 
        add constraint FK5D360E0C2AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_children 
        add constraint FK3B6C252D2AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_children 
        add constraint FK3B6C252D2A36694C 
        foreign key (child) 
        references layer;

    alter table layer_crs_list 
        add constraint FK5CC73D472AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_details 
        add constraint FK3A8A8D542AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_keywords 
        add constraint FKF7B066D82AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_matrix_sets 
        add constraint FK118A64219EBB0496 
        foreign key (matrix_set) 
        references tile_matrix_set;

    alter table layer_matrix_sets 
        add constraint FK118A64212AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_prevent_geom_editors 
        add constraint FKF2CC57D82AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_readers 
        add constraint FK1E175B222AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_writers 
        add constraint FK3D3D85722AB24981 
        foreign key (layer) 
        references layer;

    alter table level_ 
        add constraint FKBE11D55BB3061012 
        foreign key (parent) 
        references level_;

    alter table level_children 
        add constraint FK24AAA85AAC6CDCC3 
        foreign key (level_) 
        references level_;

    alter table level_children 
        add constraint FK24AAA85AF3FEFC84 
        foreign key (child) 
        references level_;

    alter table level_documents 
        add constraint FKAE8653BDA33FA2F7 
        foreign key (document) 
        references document;

    alter table level_documents 
        add constraint FKAE8653BDAC6CDCC3 
        foreign key (level_) 
        references level_;

    alter table level_layers 
        add constraint FK484FFA5DAC6CDCC3 
        foreign key (level_) 
        references level_;

    alter table level_layers 
        add constraint FK484FFA5D99484CE 
        foreign key (layer) 
        references application_layer;

    alter table level_readers 
        add constraint FK4953E55AC6CDCC3 
        foreign key (level_) 
        references level_;

    alter table solr_conf 
        add constraint FKBE7330614AC66EED 
        foreign key (simple_feature_type) 
        references feature_type;

    alter table solr_conf_index_attributes 
        add constraint FKC4645F0253A60848 
        foreign key (solr_conf) 
        references solr_conf;

    alter table solr_conf_result_attributes 
        add constraint FKF0AA165B53A60848 
        foreign key (solr_conf) 
        references solr_conf;

    alter table start_layer 
        add constraint FKA4C6AB342A91FB84 
        foreign key (application) 
        references application;

    alter table start_layer 
        add constraint FKA4C6AB3446FB11F 
        foreign key (application_layer) 
        references application_layer;

    alter table start_level 
        add constraint FKA4C871672A91FB84 
        foreign key (application) 
        references application;

    alter table start_level 
        add constraint FKA4C87167AC6CDCC3 
        foreign key (level_) 
        references level_;

    alter table tile_matrix 
        add constraint FK937382729EBB0496 
        foreign key (matrix_set) 
        references tile_matrix_set;

    alter table tile_matrix_set 
        add constraint FKD055E515591F39EA 
        foreign key (tile_service) 
        references geo_service;

    alter table tile_set_resolutions 
        add constraint FKA1D2C15980656544 
        foreign key (tile_set) 
        references tile_set;

    alter table user_details 
        add constraint FKB7C889CE99789440 
        foreign key (username) 
        references user_;

    alter table user_groups 
        add constraint FKE27720C8360AA480 
        foreign key (group_) 
        references group_;

    alter table user_groups 
        add constraint FKE27720C899789440 
        foreign key (username) 
        references user_;

    alter table user_ips 
        add constraint FKF022D5B8AFF5995E 
        foreign key (user_) 
        references user_;
