
    create table application (
        id  bigserial not null,
        authenticated_required bool not null,
        authorizations_modified timestamp not null,
        layout text,
        max_crs varchar(255),
        max_maxx float8,
        max_maxy float8,
        max_minx float8,
        max_miny float8,
        name varchar(255) not null,
        start_crs varchar(255),
        start_maxx float8,
        start_maxy float8,
        start_minx float8,
        start_miny float8,
        version varchar(30),
        owner varchar(255),
        root int8,
        primary key (id),
        unique (name, version)
    );

    create table application_details (
        application int8 not null,
        value text,
        details_key varchar(255),
        primary key (application, details_key)
    );

    create table application_layer (
        id  bigserial not null,
        layer_name varchar(255) not null,
        service int8,
        primary key (id)
    );

    create table application_layer_attributes (
        application_layer int8 not null,
        attribute_ int8 not null,
        list_index int4 not null,
        primary key (application_layer, list_index)
    );

    create table application_layer_details (
        application_layer int8 not null,
        value text,
        details_key varchar(255),
        primary key (application_layer, details_key)
    );

    create table application_layer_readers (
        application_layer int8 not null,
        role_name varchar(255)
    );

    create table application_layer_writers (
        application_layer int8 not null,
        role_name varchar(255)
    );

    create table application_readers (
        application int8 not null,
        role_name varchar(255)
    );

    create table attribute_descriptor (
        id  bigserial not null,
        name_alias varchar(255),
        name varchar(255) not null,
        type varchar(255),
        primary key (id)
    );

    create table bookmark (
        id  bigserial not null,
        code varchar(255),
        created_at timestamp,
        created_by varchar(255),
        params text not null,
        application int8,
        primary key (id),
        unique (code, application)
    );

    create table category (
        id  bigserial not null,
        name varchar(255) not null,
        parent int8,
        primary key (id),
        unique (parent, name)
    );

    create table category_children (
        category int8 not null,
        child int8 not null,
        list_index int4 not null,
        primary key (category, list_index)
    );

    create table category_readers (
        category int8 not null,
        role_name varchar(255)
    );

    create table category_services (
        category int8 not null,
        service int8 not null,
        list_index int4 not null,
        primary key (category, list_index)
    );

    create table category_writers (
        category int8 not null,
        role_name varchar(255)
    );

    create table configured_attribute (
        id  bigserial not null,
        allow_value_list_only bool not null,
        attribute_name varchar(255),
        default_value varchar(255),
        disable_user_edit bool not null,
        disallow_null_value bool not null,
        edit_alias varchar(255),
        edit_height varchar(255),
        edit_values text,
        editable bool not null,
        filterable bool not null,
        label varchar(255),
        selectable bool not null,
        value_list varchar(255),
        value_list_label_name varchar(255),
        value_list_value_name varchar(255),
        visible bool not null,
        feature_type int8,
        value_list_feature_source int8,
        value_list_feature_type int8,
        primary key (id)
    );

    create table configured_component (
        id  bigserial not null,
        class_name varchar(255) not null,
        config text,
        name varchar(255) not null,
        application int8 not null,
        mother_component int8,
        primary key (id),
        unique (name, application)
    );

    create table configured_component_details (
        configured_component int8 not null,
        details varchar(255),
        details_key varchar(255),
        primary key (configured_component, details_key)
    );

    create table configured_component_readers (
        configured_component int8 not null,
        role_name varchar(255)
    );

    create table cyclorama_account (
        id  bigserial not null,
        filename varchar(255),
        password varchar(255),
        private_base64key text,
        username varchar(255),
        primary key (id)
    );

    create table document (
        id  bigserial not null,
        category varchar(255),
        name varchar(255) not null,
        url varchar(255) not null,
        primary key (id)
    );

    create table feature_source (
        protocol varchar(31) not null,
        id  bigserial not null,
        name varchar(255) not null,
        password varchar(255),
        url varchar(255) not null,
        username varchar(255),
        db_schema varchar(255),
        service_name varchar(255),
        linked_service int8,
        primary key (id)
    );

    create table feature_source_feature_types (
        feature_source int8 not null,
        feature_type int8 not null,
        list_index int4 not null,
        primary key (feature_source, list_index)
    );

    create table feature_type (
        id  bigserial not null,
        description varchar(255),
        geometry_attribute varchar(255),
        type_name varchar(255),
        writeable bool not null,
        feature_source int8,
        primary key (id)
    );

    create table feature_type_attributes (
        feature_type int8 not null,
        attribute_descriptor int8 not null,
        list_index int4 not null,
        primary key (feature_type, list_index)
    );

    create table feature_type_relation (
        id  bigserial not null,
        type varchar(255),
        feature_type int8,
        foreign_feature_type int8,
        primary key (id)
    );

    create table feature_type_relation_key (
        id  bigserial not null,
        left_side int8,
        relation int8,
        right_side int8,
        primary key (id)
    );

    create table geo_service (
        protocol varchar(31) not null,
        id  bigserial not null,
        authorizations_modified timestamp not null,
        monitoring_enabled bool not null,
        monitoring_statusok bool not null,
        name varchar(255) not null,
        password varchar(255),
        url varchar(255) not null,
        username varchar(255),
        service_name varchar(255),
        tiling_protocol varchar(255),
        exception_type varchar(255),
        override_url bool,
        category int8,
        top_layer int8,
        primary key (id)
    );

    create table geo_service_details (
        geoservice int8 not null,
        value text,
        details_key varchar(255),
        primary key (geoservice, details_key)
    );

    create table geo_service_keywords (
        geo_service int8 not null,
        keyword varchar(255)
    );

    create table geo_service_readers (
        geo_service int8 not null,
        role_name varchar(255)
    );

    create table geo_service_style_libraries (
        geo_service int8 not null,
        style_library int8 not null,
        list_index int4 not null,
        primary key (geo_service, list_index),
        unique (style_library)
    );

    create table group_ (
        name varchar(255) not null,
        description text,
        primary key (name)
    );

    create table layar_service (
        id  bigserial not null,
        name varchar(255) not null unique,
        primary key (id)
    );

    create table layar_source (
        id  bigserial not null,
        feature_type int8,
        layar_service int8,
        primary key (id)
    );

    create table layar_source_details (
        layar_source int8 not null,
        value text,
        details_key varchar(255),
        primary key (layar_source, details_key)
    );

    create table layer (
        id  bigserial not null,
        filterable bool not null,
        legend_image_url text,
        max_scale float8,
        min_scale float8,
        name varchar(255),
        queryable bool not null,
        title varchar(255),
        title_alias varchar(255),
        virtual bool not null,
        feature_type int8,
        parent int8,
        service int8,
        tileset varchar(255),
        primary key (id)
    );

    create table layer_bounding_boxes (
        layer int8 not null,
        name varchar(255),
        maxx float8,
        maxy float8,
        minx float8,
        miny float8,
        crs varchar(255),
        primary key (layer, crs)
    );

    create table layer_children (
        layer int8 not null,
        child int8 not null unique,
        list_index int4 not null,
        primary key (layer, list_index)
    );

    create table layer_crs_list (
        layer int8 not null,
        crs varchar(255)
    );

    create table layer_details (
        layer int8 not null,
        value text,
        details_key varchar(255),
        primary key (layer, details_key)
    );

    create table layer_keywords (
        layer int8 not null,
        keyword varchar(255)
    );

    create table layer_matrix_sets (
        layer int8 not null,
        matrix_set int8 not null,
        list_index int4 not null,
        primary key (layer, list_index)
    );

    create table layer_prevent_geom_editors (
        layer int8 not null,
        role_name varchar(255)
    );

    create table layer_readers (
        layer int8 not null,
        role_name varchar(255)
    );

    create table layer_writers (
        layer int8 not null,
        role_name varchar(255)
    );

    create table level_ (
        id  bigserial not null,
        background bool not null,
        info text,
        name varchar(255) not null,
        url varchar(255),
        parent int8,
        primary key (id)
    );

    create table level_children (
        level_ int8 not null,
        child int8 not null,
        list_index int4 not null,
        primary key (level_, list_index)
    );

    create table level_documents (
        level_ int8 not null,
        document int8 not null,
        list_index int4 not null,
        primary key (level_, list_index)
    );

    create table level_layers (
        level_ int8 not null,
        layer int8 not null,
        list_index int4 not null,
        primary key (level_, list_index)
    );

    create table level_readers (
        level_ int8 not null,
        role_name varchar(255)
    );

    create table metadata (
        id  bigserial not null,
        config_key varchar(255),
        config_value varchar(255),
        primary key (id)
    );

    create table resource_ (
        name varchar(255) not null,
        content_type varchar(255),
        data_ bytea not null,
        modified timestamp not null,
        size_ int8 not null,
        primary key (name)
    );

    create table solr_conf (
        id  bigserial not null,
        last_updated timestamp,
        name varchar(255),
        simple_feature_type int8,
        primary key (id)
    );

    create table solr_conf_index_attributes (
        solr_conf int8 not null,
        attribute_ varchar(255)
    );

    create table solr_conf_result_attributes (
        solr_conf int8 not null,
        attribute_ varchar(255)
    );

    create table start_layer (
        id  bigserial not null,
        checked bool not null,
        removed bool not null,
        selected_index int4,
        application int8,
        application_layer int8,
        primary key (id)
    );

    create table start_level (
        id  bigserial not null,
        removed bool not null,
        selected_index int4,
        application int8,
        level_ int8,
        primary key (id)
    );

    create table style_library (
        id  bigserial not null,
        default_style bool not null,
        external_url varchar(1000),
        extra_legend_parameters varchar(255),
        named_layer_user_styles_json text,
        sld_body text,
        title varchar(255) not null,
        primary key (id)
    );

    create table tile_matrix (
        id  bigserial not null,
        description varchar(255),
        identifier varchar(255),
        matrix_height int4 not null,
        matrix_width int4 not null,
        scale_denominator varchar(255),
        tile_height int4 not null,
        tile_width int4 not null,
        title varchar(255),
        top_left_corner varchar(255),
        matrix_set int8,
        primary key (id)
    );

    create table tile_matrix_set (
        id  bigserial not null,
        max_crs varchar(255),
        max_maxx float8,
        max_maxy float8,
        max_minx float8,
        max_miny float8,
        crs varchar(255),
        identifier varchar(255),
        tile_service int8,
        primary key (id)
    );

    create table tile_set (
        name varchar(255) not null,
        height int4 not null,
        width int4 not null,
        primary key (name)
    );

    create table tile_set_resolutions (
        tile_set varchar(255) not null,
        resolution float8,
        list_index int4 not null,
        primary key (tile_set, list_index)
    );

    create table user_ (
        username varchar(255) not null,
        password varchar(255),
        primary key (username)
    );

    create table user_details (
        username varchar(255) not null,
        details varchar(255),
        details_key varchar(255),
        primary key (username, details_key)
    );

    create table user_groups (
        username varchar(255) not null,
        group_ varchar(255) not null,
        primary key (username, group_)
    );

    create table user_ips (
        user_ varchar(255) not null,
        ipaddress varchar(45)
    );

    alter table application 
        add constraint FK5CA40550AFA2FE1D 
        foreign key (owner) 
        references user_;

    alter table application 
        add constraint FK5CA40550EE90884A 
        foreign key (root) 
        references level_;

    alter table application_details 
        add constraint FKD9A4E532A91FB84 
        foreign key (application) 
        references application;

    alter table application_layer 
        add constraint FKFB01A255F7BD5A 
        foreign key (service) 
        references geo_service;

    alter table application_layer_attributes 
        add constraint FKD41041446FB11F 
        foreign key (application_layer) 
        references application_layer;

    alter table application_layer_attributes 
        add constraint FKD4104148017EC25 
        foreign key (attribute_) 
        references configured_attribute;

    alter table application_layer_details 
        add constraint FKD720D8A546FB11F 
        foreign key (application_layer) 
        references application_layer;

    alter table application_layer_readers 
        add constraint FKBAADA67346FB11F 
        foreign key (application_layer) 
        references application_layer;

    alter table application_layer_writers 
        add constraint FKD9D3D0C346FB11F 
        foreign key (application_layer) 
        references application_layer;

    alter table application_readers 
        add constraint FKF1271C212A91FB84 
        foreign key (application) 
        references application;

    alter table bookmark 
        add constraint FK7787A5362A91FB84 
        foreign key (application) 
        references application;

    alter table category 
        add constraint FK302BCFE433C669 
        foreign key (parent) 
        references category;

    alter table category_children 
        add constraint FKF77E9020428B7ABD 
        foreign key (category) 
        references category;

    alter table category_children 
        add constraint FKF77E9020452CB2DB 
        foreign key (child) 
        references category;

    alter table category_readers 
        add constraint FKB6245CF428B7ABD 
        foreign key (category) 
        references category;

    alter table category_services 
        add constraint FKE6C9427F55F7BD5A 
        foreign key (service) 
        references geo_service;

    alter table category_services 
        add constraint FKE6C9427F428B7ABD 
        foreign key (category) 
        references category;

    alter table category_writers 
        add constraint FK2A88701F428B7ABD 
        foreign key (category) 
        references category;

    alter table configured_attribute 
        add constraint FK521A69DBB7916580 
        foreign key (feature_type) 
        references feature_type;

    alter table configured_attribute 
        add constraint FK521A69DBEC20F033 
        foreign key (value_list_feature_type) 
        references feature_type;

    alter table configured_attribute 
        add constraint FK521A69DB72DC0207 
        foreign key (value_list_feature_source) 
        references feature_source;

    alter table configured_component 
        add constraint FKFDE1DC3C2A91FB84 
        foreign key (application) 
        references application;

    alter table configured_component 
        add constraint FKFDE1DC3CFD682FC4 
        foreign key (mother_component) 
        references configured_component;

    alter table configured_component_details 
        add constraint FK5B8793F1193917F 
        foreign key (configured_component) 
        references configured_component;

    alter table configured_component_readers 
        add constraint FKE945470D1193917F 
        foreign key (configured_component) 
        references configured_component;

    alter table feature_source 
        add constraint FK8DE1C984D576E134 
        foreign key (linked_service) 
        references geo_service;

    alter table feature_source_feature_types 
        add constraint FK57524A75B7916580 
        foreign key (feature_type) 
        references feature_type;

    alter table feature_source_feature_types 
        add constraint FK57524A7524045814 
        foreign key (feature_source) 
        references feature_source;

    alter table feature_type 
        add constraint FK481336E324045814 
        foreign key (feature_source) 
        references feature_source;

    alter table feature_type_attributes 
        add constraint FKA280AC33B7916580 
        foreign key (feature_type) 
        references feature_type;

    alter table feature_type_attributes 
        add constraint FKA280AC33C22478BC 
        foreign key (attribute_descriptor) 
        references attribute_descriptor;

    alter table feature_type_relation 
        add constraint FK1CA203D8B7916580 
        foreign key (feature_type) 
        references feature_type;

    alter table feature_type_relation 
        add constraint FK1CA203D8C6F0470B 
        foreign key (foreign_feature_type) 
        references feature_type;

    alter table feature_type_relation_key 
        add constraint FK31F9257826403964 
        foreign key (right_side) 
        references attribute_descriptor;

    alter table feature_type_relation_key 
        add constraint FK31F92578E0CA5659 
        foreign key (left_side) 
        references attribute_descriptor;

    alter table feature_type_relation_key 
        add constraint FK31F92578AD91C807 
        foreign key (relation) 
        references feature_type_relation;

    alter table geo_service 
        add constraint FK957D1BC7428B7ABD 
        foreign key (category) 
        references category;

    alter table geo_service 
        add constraint FK957D1BC72B2D5A17 
        foreign key (top_layer) 
        references layer;

    alter table geo_service_details 
        add constraint FK2ACCFDCA292680E9 
        foreign key (geoservice) 
        references geo_service;

    alter table geo_service_keywords 
        add constraint FKFBC05227531126C 
        foreign key (geo_service) 
        references geo_service;

    alter table geo_service_readers 
        add constraint FKE59CB987531126C 
        foreign key (geo_service) 
        references geo_service;

    alter table geo_service_style_libraries 
        add constraint FK95F125137531126C 
        foreign key (geo_service) 
        references geo_service;

    alter table geo_service_style_libraries 
        add constraint FK95F1251313076638 
        foreign key (style_library) 
        references style_library;

    alter table layar_source 
        add constraint FKFC8466C5B7916580 
        foreign key (feature_type) 
        references feature_type;

    alter table layar_source 
        add constraint FKFC8466C580F5B5AC 
        foreign key (layar_service) 
        references layar_service;

    alter table layar_source_details 
        add constraint FK7ED06AC81E0B97B4 
        foreign key (layar_source) 
        references layar_source;

    alter table layer 
        add constraint FK61FD551B7916580 
        foreign key (feature_type) 
        references feature_type;

    alter table layer 
        add constraint FK61FD551E93D7CDA 
        foreign key (parent) 
        references layer;

    alter table layer 
        add constraint FK61FD551AF8870E7 
        foreign key (tileset) 
        references tile_set;

    alter table layer 
        add constraint FK61FD55155F7BD5A 
        foreign key (service) 
        references geo_service;

    alter table layer_bounding_boxes 
        add constraint FK5D360E0C2AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_children 
        add constraint FK3B6C252D2AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_children 
        add constraint FK3B6C252D2A36694C 
        foreign key (child) 
        references layer;

    alter table layer_crs_list 
        add constraint FK5CC73D472AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_details 
        add constraint FK3A8A8D542AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_keywords 
        add constraint FKF7B066D82AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_matrix_sets 
        add constraint FK118A64219EBB0496 
        foreign key (matrix_set) 
        references tile_matrix_set;

    alter table layer_matrix_sets 
        add constraint FK118A64212AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_prevent_geom_editors 
        add constraint FKF2CC57D82AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_readers 
        add constraint FK1E175B222AB24981 
        foreign key (layer) 
        references layer;

    alter table layer_writers 
        add constraint FK3D3D85722AB24981 
        foreign key (layer) 
        references layer;

    alter table level_ 
        add constraint FKBE11D55BB3061012 
        foreign key (parent) 
        references level_;

    alter table level_children 
        add constraint FK24AAA85AAC6CDCC3 
        foreign key (level_) 
        references level_;

    alter table level_children 
        add constraint FK24AAA85AF3FEFC84 
        foreign key (child) 
        references level_;

    alter table level_documents 
        add constraint FKAE8653BDA33FA2F7 
        foreign key (document) 
        references document;

    alter table level_documents 
        add constraint FKAE8653BDAC6CDCC3 
        foreign key (level_) 
        references level_;

    alter table level_layers 
        add constraint FK484FFA5DAC6CDCC3 
        foreign key (level_) 
        references level_;

    alter table level_layers 
        add constraint FK484FFA5D99484CE 
        foreign key (layer) 
        references application_layer;

    alter table level_readers 
        add constraint FK4953E55AC6CDCC3 
        foreign key (level_) 
        references level_;

    alter table solr_conf 
        add constraint FKBE7330614AC66EED 
        foreign key (simple_feature_type) 
        references feature_type;

    alter table solr_conf_index_attributes 
        add constraint FKC4645F0253A60848 
        foreign key (solr_conf) 
        references solr_conf;

    alter table solr_conf_result_attributes 
        add constraint FKF0AA165B53A60848 
        foreign key (solr_conf) 
        references solr_conf;

    alter table start_layer 
        add constraint FKA4C6AB342A91FB84 
        foreign key (application) 
        references application;

    alter table start_layer 
        add constraint FKA4C6AB3446FB11F 
        foreign key (application_layer) 
        references application_layer;

    alter table start_level 
        add constraint FKA4C871672A91FB84 
        foreign key (application) 
        references application;

    alter table start_level 
        add constraint FKA4C87167AC6CDCC3 
        foreign key (level_) 
        references level_;

    alter table tile_matrix 
        add constraint FK937382729EBB0496 
        foreign key (matrix_set) 
        references tile_matrix_set;

    alter table tile_matrix_set 
        add constraint FKD055E515591F39EA 
        foreign key (tile_service) 
        references geo_service;

    alter table tile_set_resolutions 
        add constraint FKA1D2C15980656544 
        foreign key (tile_set) 
        references tile_set;

    alter table user_details 
        add constraint FKB7C889CE99789440 
        foreign key (username) 
        references user_;

    alter table user_groups 
        add constraint FKE27720C8360AA480 
        foreign key (group_) 
        references group_;

    alter table user_groups 
        add constraint FKE27720C899789440 
        foreign key (username) 
        references user_;

    alter table user_ips 
        add constraint FKF022D5B8AFF5995E 
        foreign key (user_) 
        references user_;
