/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import nl.b3p.geotools.data.arcims.ArcIMSDataStoreFactory;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.referencing.CRS;
import org.opengis.filter.Filter;

@Entity
@DiscriminatorValue(value="arcxml")
public class ArcXMLFeatureSource
extends FeatureSource {
    private static final Log log = LogFactory.getLog(ArcXMLFeatureSource.class);
    public static final String PROTOCOL = "arcxml";
    @Basic
    private String serviceName;

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public DataStore createDataStore() throws Exception {
        return this.createDataStore(null);
    }

    public DataStore createDataStore(Map extraDataStoreParams) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (extraDataStoreParams != null) {
            params.putAll(extraDataStoreParams);
        }
        params.put(ArcIMSDataStoreFactory.URL.key, new URL(this.getUrl()));
        params.put(ArcIMSDataStoreFactory.SERVICENAME.key, this.serviceName);
        params.put(ArcIMSDataStoreFactory.USER.key, this.getUsername());
        params.put(ArcIMSDataStoreFactory.PASSWD.key, this.getPassword());
        log.debug((Object)("Opening datastore using parameters: " + params));
        params.put(ArcIMSDataStoreFactory.CRS.key, CRS.decode((String)"EPSG:28992"));
        DataStore ds = null;
        try {
            ds = new ArcIMSDataStoreFactory().createDataStore(params);
        }
        catch (Exception e) {
            params.put(ArcIMSDataStoreFactory.PASSWD.key, "xxx");
            throw new Exception("Cannot open datastore using parameters " + params, e);
        }
        if (ds == null) {
            params.put(ArcIMSDataStoreFactory.PASSWD.key, "xxx");
            throw new Exception("Cannot open datastore using parameters " + params);
        }
        return ds;
    }

    @Override
    org.geotools.data.FeatureSource openGeoToolsFeatureSource(SimpleFeatureType sft) throws Exception {
        DataStore ds = this.createDataStore();
        return ds.getFeatureSource(sft.getTypeName());
    }

    @Override
    org.geotools.data.FeatureSource openGeoToolsFeatureSource(SimpleFeatureType sft, int timeout) throws Exception {
        HashMap<String, Integer> extraParams = new HashMap<String, Integer>();
        extraParams.put(ArcIMSDataStoreFactory.TIMEOUT.key, timeout);
        DataStore ds = this.createDataStore(extraParams);
        return ds.getFeatureSource(sft.getTypeName());
    }

    @Override
    FeatureCollection getFeatures(SimpleFeatureType sft, Filter f, int maxFeatures) throws Exception {
        Query q = null;
        q = f != null ? new Query(sft.getTypeName(), f) : new Query(sft.getTypeName());
        q.setMaxFeatures(maxFeatures);
        FeatureCollection fc = sft.openGeoToolsFeatureSource().getFeatures(q);
        return fc;
    }
}

