/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.web.WaitPageStatus;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class UpdateResult {
    private static final Log log = LogFactory.getLog(UpdateResult.class);
    private Status status = Status.FAILED;
    private WaitPageStatus waitPageStatus = new WaitPageStatus();
    private GeoService geoService;
    private Throwable exception;
    private String message = "Unknown error";
    private SortedMap<String, MutablePair<Layer, Status>> layerStatus = new TreeMap<String, MutablePair<Layer, Status>>();
    private List<Layer> duplicateOrNoNameLayers = new ArrayList<Layer>();

    public UpdateResult(GeoService toUpdate, EntityManager em) {
        this.geoService = toUpdate;
        Layer l = toUpdate.getTopLayer();
        if (l == null) {
            this.waitPageStatus.addLog("Before update: service has no layers");
        } else {
            final MutableInt layers = new MutableInt(0);
            l.accept(new Layer.Visitor(){

                @Override
                public boolean visit(Layer l, EntityManager em) {
                    if (l.getName() == null || UpdateResult.this.layerStatus.containsKey(l.getName())) {
                        UpdateResult.this.duplicateOrNoNameLayers.add(l);
                    } else {
                        UpdateResult.this.layerStatus.put(l.getName(), new MutablePair((Object)l, (Object)Status.MISSING));
                    }
                    layers.increment();
                    return true;
                }
            }, em);
            this.waitPageStatus.addLog("Before update: service has %d layers (%d duplicate or no name)", new Object[]{layers.intValue(), this.duplicateOrNoNameLayers.size()});
        }
    }

    public Map<Status, List<String>> getLayerNamesByStatus() {
        HashMap<Status, List<String>> byStatus = new HashMap<Status, List<String>>();
        byStatus.put(Status.NEW, new ArrayList());
        byStatus.put(Status.UNMODIFIED, new ArrayList());
        byStatus.put(Status.UPDATED, new ArrayList());
        byStatus.put(Status.MISSING, new ArrayList());
        for (Map.Entry<String, MutablePair<Layer, Status>> entry : this.layerStatus.entrySet()) {
            List layers = (List)byStatus.get(entry.getValue().getRight());
            layers.add(entry.getKey());
        }
        return byStatus;
    }

    public void failedWithException(Exception e) {
        this.exception = e;
        this.setStatus(Status.FAILED);
        String msg = String.format("Error updating %s service #%d \"%s\": %s: %s", this.geoService.getProtocol(), this.geoService.getId(), this.geoService.getName(), e.getClass().getName(), e.getMessage());
        log.error((Object)msg, (Throwable)e);
        this.setMessage(msg);
        Stripersist.getEntityManager().getTransaction().rollback();
    }

    public void changed() {
        this.status = Status.CHANGED;
    }

    public WaitPageStatus getWaitPageStatus() {
        return this.waitPageStatus;
    }

    public GeoService getGeoService() {
        return this.geoService;
    }

    public void setGeoService(GeoService geoService) {
        this.geoService = geoService;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public SortedMap<String, MutablePair<Layer, Status>> getLayerStatus() {
        return this.layerStatus;
    }

    public void setLayerStatus(SortedMap<String, MutablePair<Layer, Status>> layerStatus) {
        this.layerStatus = layerStatus;
    }

    public List<Layer> getDuplicateOrNoNameLayers() {
        return this.duplicateOrNoNameLayers;
    }

    public void setDuplicateOrNoNameLayers(List<Layer> duplicateOrNoNameLayers) {
        this.duplicateOrNoNameLayers = duplicateOrNoNameLayers;
    }

    public static enum Status {
        FAILED,
        MISSING,
        NEW,
        UNMODIFIED,
        CHANGED,
        UPDATED;

    }
}

