/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.Updatable;
import nl.b3p.viewer.config.services.UpdateResult;
import nl.b3p.viewer.config.services.WFSFeatureSource;
import nl.b3p.viewer.config.services.WMSExceptionType;
import nl.b3p.web.WaitPageStatus;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.ServiceInfo;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.LayerDescription;
import org.geotools.data.ows.SimpleHttpClient;
import org.geotools.data.ows.Specification;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wms.WMS1_0_0;
import org.geotools.data.wms.WMS1_1_0;
import org.geotools.data.wms.WMS1_1_1;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.request.DescribeLayerRequest;
import org.geotools.data.wms.response.DescribeLayerResponse;
import org.geotools.ows.ServiceException;
import org.stripesstuff.stripersist.Stripersist;

@Entity
@DiscriminatorValue(value="wms")
public class WMSService
extends GeoService
implements Updatable {
    private static final Log log = LogFactory.getLog(WMSService.class);
    public static final String PROTOCOL = "wms";
    public static final String PARAM_OVERRIDE_URL = "overrideUrl";
    public static final String DETAIL_SUPPORT_SLD = "SupportSLD";
    public static final String DETAIL_USER_STYLE = "UserStyle";
    private Boolean overrideUrl;
    @Enumerated(value=EnumType.STRING)
    private WMSExceptionType exception_type = WMSExceptionType.Inimage;

    public Boolean getOverrideUrl() {
        return this.overrideUrl;
    }

    public void setOverrideUrl(Boolean overrideUrl) {
        this.overrideUrl = overrideUrl;
    }

    public WMSExceptionType getException_type() {
        return this.exception_type;
    }

    public void setException_type(WMSExceptionType exception_type) {
        this.exception_type = exception_type;
    }

    public String toString() {
        return String.format("WMS service \"%s\" at %s", this.getName(), this.getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WMSService loadFromUrl(String url, Map params, WaitPageStatus status, EntityManager em) throws Exception {
        try {
            status.setCurrentAction("Ophalen informatie...");
            WMSService wmsService = new WMSService();
            wmsService.setUsername((String)params.get("username"));
            wmsService.setPassword((String)params.get("password"));
            wmsService.setUrl(url);
            wmsService.setOverrideUrl(Boolean.TRUE.equals(params.get(PARAM_OVERRIDE_URL)));
            WebMapServer wms = wmsService.getWebMapServer();
            if (Boolean.TRUE.equals(params.get("onlineCheckOnly"))) {
                WMSService wMSService = null;
                return wMSService;
            }
            wmsService.load(wms, params, status, em);
            WMSService wMSService = wmsService;
            return wMSService;
        }
        finally {
            status.setProgress(100);
            status.setCurrentAction("Service ingeladen");
            status.setFinished(true);
        }
    }

    protected void load(WebMapServer wms, Map params, WaitPageStatus status, EntityManager em) throws IOException, MalformedURLException, ServiceException {
        ServiceInfo si = wms.getInfo();
        this.setName(si.getTitle());
        String serviceUrl = si.getSource().toString();
        if (this.getOverrideUrl().booleanValue() && !this.getUrl().equals(serviceUrl)) {
            this.getDetails().put("overridenUrl", new ClobElement(serviceUrl));
        } else {
            this.setUrl(serviceUrl);
        }
        this.getKeywords().addAll(si.getKeywords());
        status.setCurrentAction("Inladen layers...");
        boolean supportsDescribeLayer = wms.getCapabilities().getRequest().getDescribeLayer() != null;
        status.setProgress(40);
        org.geotools.data.ows.Layer rl = wms.getCapabilities().getLayer();
        this.setTopLayer(new Layer(rl, this));
        Map<String, List<LayerDescription>> layerDescByWfs = null;
        if (!"1.0.0".equals(wms.getCapabilities().getVersion())) {
            try {
                status.setProgress(60);
                status.setCurrentAction("Gerelateerde WFS bronnen opzoeken...");
                layerDescByWfs = WMSService.getDescribeLayerPerWFS(wms);
            }
            catch (Exception e) {
                if (supportsDescribeLayer) {
                    log.error((Object)"DescribeLayer request failed", (Throwable)e);
                }
                log.debug((Object)"DescribeLayer not supported in Capabilities, did request anyway but failed");
            }
        }
        if (layerDescByWfs != null) {
            status.setProgress(80);
            String action = "Gerelateerde WFS bron inladen...";
            String[] wfses = layerDescByWfs.keySet().toArray(new String[0]);
            for (int i = 0; i < wfses.length; ++i) {
                String wfsUrl = wfses[i];
                String wfsAction = action + (wfses.length > 1 ? " (" + (i + 1) + " van " + wfses.length + ")" : "");
                status.setCurrentAction(wfsAction);
                try {
                    List<LayerDescription> layerDescriptions = layerDescByWfs.get(wfsUrl);
                    this.loadLayerFeatureTypes(wfsUrl, layerDescriptions, em);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Failed loading feature types from WFS " + wfsUrl), (Throwable)e);
                }
            }
        }
    }

    protected WebMapServer getWebMapServer() throws IOException, MalformedURLException, ServiceException {
        SimpleHttpClient client = new SimpleHttpClient();
        client.setUser(this.getUsername());
        client.setPassword(this.getPassword());
        return new WebMapServer(new URL(this.getUrl()), (HTTPClient)client){

            protected void setupSpecifications() {
                this.specs = new Specification[]{new WMS1_0_0(), new WMS1_1_0(), new WMS1_1_1()};
            }
        };
    }

    @Override
    public UpdateResult update(EntityManager em) {
        this.initLayerCollectionsForUpdate();
        UpdateResult result = new UpdateResult(this, em);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(PARAM_OVERRIDE_URL, this.getOverrideUrl());
            params.put("username", this.getUsername());
            params.put("password", this.getPassword());
            WMSService update = this.loadFromUrl(this.getUrl(), params, result.getWaitPageStatus().subtask("", 80.0f), em);
            if (!this.getUrl().equals(update.getUrl())) {
                this.setUrl(update.getUrl());
                result.changed();
            }
            if (Boolean.TRUE.equals(this.getOverrideUrl())) {
                this.getDetails().put("overridenUrl", update.getDetails().get("overridenUrl"));
            } else {
                this.getDetails().remove("overridenUrl");
            }
            if (!this.getDetails().containsKey("originalName")) {
                this.getDetails().put("originalName", new ClobElement(update.getName()));
            } else {
                this.setName(update.getName());
            }
            if (!this.getKeywords().equals(update.getKeywords())) {
                this.getKeywords().clear();
                this.getKeywords().addAll(update.getKeywords());
            }
            Set<FeatureSource> linkedFS = WMSService.getAutomaticallyLinkedFeatureSources(this.getTopLayer(), em);
            Map<String, WFSFeatureSource> linkedFSByURL = this.createFeatureSourceMapByURL(linkedFS);
            ArrayList<SimpleFeatureType> typesToRemove = new ArrayList<SimpleFeatureType>();
            HashSet<SimpleFeatureType> updatedFeatureTypes = new HashSet<SimpleFeatureType>();
            this.updateWFS(update, linkedFSByURL, updatedFeatureTypes, typesToRemove, result, em);
            this.updateLayers(update, linkedFSByURL, updatedFeatureTypes, result, em);
            this.updateLayerTree(update, result);
            this.removeOrphanLayersAfterUpdate(result);
            this.removeFeatureTypes(typesToRemove, result);
            result.setStatus(UpdateResult.Status.UPDATED);
        }
        catch (Exception e) {
            result.failedWithException(e);
        }
        return result;
    }

    private Map<String, WFSFeatureSource> createFeatureSourceMapByURL(Collection<FeatureSource> fsCollection) {
        HashMap<String, WFSFeatureSource> map = new HashMap<String, WFSFeatureSource>();
        for (FeatureSource fs : fsCollection) {
            map.put(fs.getUrl(), (WFSFeatureSource)fs);
        }
        return map;
    }

    private void removeFeatureTypes(Collection<SimpleFeatureType> typesToRemove, UpdateResult result) {
        if (typesToRemove.isEmpty()) {
            return;
        }
        SimpleFeatureType.clearReferences(typesToRemove);
        for (SimpleFeatureType typeToRemove : typesToRemove) {
            typeToRemove.getFeatureSource().getFeatureTypes().remove(typeToRemove);
            Stripersist.getEntityManager().remove((Object)typeToRemove);
        }
    }

    private static Set<FeatureSource> getAutomaticallyLinkedFeatureSources(Layer top, EntityManager em) {
        final GeoService service = top.getService();
        final HashSet<FeatureSource> featureSources = new HashSet<FeatureSource>();
        top.accept(new Layer.Visitor(){

            @Override
            public boolean visit(Layer l, EntityManager em) {
                FeatureSource fs;
                if (l.getFeatureType() != null && (fs = l.getFeatureType().getFeatureSource()).getLinkedService() == service) {
                    featureSources.add((WFSFeatureSource)fs);
                }
                return true;
            }
        }, em);
        return featureSources;
    }

    private void updateWFS(WMSService updateWMS, Map<String, WFSFeatureSource> linkedFSesByURL, Set<SimpleFeatureType> updatedFeatureTypes, Collection<SimpleFeatureType> outTypesToRemove, UpdateResult result, EntityManager em) {
        Set<FeatureSource> updateFSes = WMSService.getAutomaticallyLinkedFeatureSources(updateWMS.getTopLayer(), em);
        for (FeatureSource fs : updateFSes) {
            WFSFeatureSource oldFS = linkedFSesByURL.get(fs.getUrl());
            if (oldFS == null) {
                log.info((Object)("Found new WFS with URL " + fs.getUrl() + " linked to WMS"));
                linkedFSesByURL.put(fs.getUrl(), (WFSFeatureSource)fs);
                fs.setLinkedService(this);
                continue;
            }
            log.info((Object)("Updating WFS with URL " + fs.getUrl() + " linked to WMS"));
            for (SimpleFeatureType updateFT : fs.getFeatureTypes()) {
                boolean isNew;
                MutableBoolean updated = new MutableBoolean();
                SimpleFeatureType updatedFT = oldFS.addOrUpdateFeatureType(updateFT.getTypeName(), updateFT, updated);
                boolean bl = isNew = updateFT == updatedFT;
                if (updated.isTrue()) {
                    updatedFeatureTypes.add(updatedFT);
                }
                if (!isNew) continue;
                log.info((Object)("New feature type in WFS: " + updateFT.getTypeName()));
            }
            HashSet<SimpleFeatureType> typesToRemove = new HashSet<SimpleFeatureType>();
            for (SimpleFeatureType oldFT : oldFS.getFeatureTypes()) {
                if (fs.getFeatureType(oldFT.getTypeName()) != null) continue;
                typesToRemove.add(oldFT);
                log.info((Object)("Feature type " + oldFT.getTypeName() + " does no longer exist"));
            }
            outTypesToRemove.addAll(typesToRemove);
        }
    }

    private void updateLayers(WMSService update, final Map<String, WFSFeatureSource> linkedFSesByURL, final Set<SimpleFeatureType> updatedFeatureTypes, final UpdateResult result, EntityManager em) {
        final WMSService updatingWMSService = this;
        update.getTopLayer().accept(new Layer.Visitor(){

            @Override
            public boolean visit(Layer l, EntityManager em) {
                if (l.getName() == null) {
                    return true;
                }
                MutablePair layerStatus = (MutablePair)result.getLayerStatus().get(l.getName());
                if (layerStatus == null) {
                    l = l.pluckCopy();
                    result.getLayerStatus().put(l.getName(), (MutablePair<Layer, UpdateResult.Status>)new MutablePair((Object)l, (Object)UpdateResult.Status.NEW));
                    if (l.getFeatureType() != null) {
                        WFSFeatureSource fs = (WFSFeatureSource)linkedFSesByURL.get(l.getFeatureType().getFeatureSource().getUrl());
                        l.setFeatureType(fs.getFeatureType(l.getFeatureType().getTypeName()));
                    }
                } else {
                    if (layerStatus.getRight() != UpdateResult.Status.MISSING) {
                        return true;
                    }
                    Layer old = (Layer)layerStatus.getLeft();
                    old.setParent(null);
                    old.getChildren().clear();
                    old.update(l);
                    layerStatus.setRight((Object)UpdateResult.Status.UNMODIFIED);
                    if (old.getFeatureType() == null || old.getFeatureType().getFeatureSource().getLinkedService() == updatingWMSService) {
                        if (l.getFeatureType() != null) {
                            WFSFeatureSource fs = (WFSFeatureSource)linkedFSesByURL.get(l.getFeatureType().getFeatureSource().getUrl());
                            boolean wasNull = old.getFeatureType() == null;
                            old.setFeatureType(fs.getFeatureType(l.getFeatureType().getTypeName()));
                            if (wasNull || updatedFeatureTypes.contains(old.getFeatureType())) {
                                layerStatus.setRight((Object)UpdateResult.Status.UPDATED);
                            }
                        } else {
                            if (old.getFeatureType() != null) {
                                layerStatus.setRight((Object)UpdateResult.Status.UPDATED);
                            }
                            old.setFeatureType(null);
                        }
                    }
                }
                return true;
            }
        }, em);
    }

    private void updateLayerTree(WMSService update, UpdateResult result) {
        String topLayerName = update.getTopLayer().getName();
        Layer newTopLayer = topLayerName == null ? update.getTopLayer().pluckCopy() : (Layer)((MutablePair)result.getLayerStatus().get(topLayerName)).getLeft();
        newTopLayer.copyUserModifiedProperties(this.getTopLayer());
        newTopLayer.setParent(null);
        newTopLayer.setService(this);
        newTopLayer.getChildren().clear();
        this.setTopLayer(newTopLayer);
        LinkedList<ImmutablePair> q = new LinkedList<ImmutablePair>();
        for (Layer child : update.getTopLayer().getChildren()) {
            q.add(new ImmutablePair((Object)child, (Object)newTopLayer));
        }
        HashSet<String> visitedLayerNames = new HashSet<String>();
        do {
            Layer thisLayer;
            Pair p = (Pair)q.remove();
            Layer updateLayer = (Layer)p.getLeft();
            Layer parent = (Layer)p.getRight();
            String layerName = updateLayer.getName();
            if (layerName == null) {
                thisLayer = updateLayer.pluckCopy();
            } else if (visitedLayerNames.contains(layerName)) {
                thisLayer = null;
            } else {
                thisLayer = (Layer)((MutablePair)result.getLayerStatus().get(layerName)).getLeft();
                visitedLayerNames.add(layerName);
            }
            if (thisLayer != null) {
                thisLayer.setService(this);
                thisLayer.setParent(parent);
                parent.getChildren().add(thisLayer);
            }
            for (Layer child : updateLayer.getChildren()) {
                q.add(new ImmutablePair((Object)child, (Object)thisLayer));
            }
        } while (!q.isEmpty());
    }

    private void removeOrphanLayersAfterUpdate(UpdateResult result) {
        for (Layer layer : result.getDuplicateOrNoNameLayers()) {
            Stripersist.getEntityManager().remove((Object)layer);
        }
        for (Pair pair : result.getLayerStatus().values()) {
            if (pair.getRight() != UpdateResult.Status.MISSING) continue;
            Stripersist.getEntityManager().remove(pair.getLeft());
        }
    }

    private static Map<String, List<LayerDescription>> getDescribeLayerPerWFS(WebMapServer wms) {
        StringBuffer layers = new StringBuffer();
        DescribeLayerResponse dlr = null;
        try {
            WMSService.getAllNonVirtualLayers(layers, wms.getCapabilities().getLayer());
            DescribeLayerRequest dlreq = null;
            dlreq = wms.getCapabilities().getRequest().getDescribeLayer() != null ? wms.createDescribeLayerRequest() : new WMS1_1_0().createDescribeLayerRequest(wms.getInfo().getSource().toURL());
            dlreq.setProperty("VERSION", wms.getCapabilities().getVersion());
            dlreq.setLayers(layers.toString());
            log.debug((Object)("Issuing DescribeLayer request for WMS " + wms.getInfo().getSource().toString() + " with layers=" + layers));
            dlr = wms.issueRequest(dlreq);
        }
        catch (Exception e) {
            log.warn((Object)("DescribeLayer request failed for layers " + layers + " on service " + wms.getInfo().getSource().toString()), (Throwable)e);
        }
        if (dlr == null) {
            return null;
        }
        HashMap<String, List<LayerDescription>> layerDescByWfs = new HashMap<String, List<LayerDescription>>();
        for (LayerDescription ld : dlr.getLayerDescs()) {
            String wfsUrl;
            log.debug((Object)String.format("DescribeLayer response, name=%s, wfs=%s, owsType=%s, owsURL=%s, typeNames=%s", ld.getName(), ld.getWfs(), ld.getOwsType(), ld.getOwsURL(), Arrays.toString(ld.getQueries())));
            String string = wfsUrl = ld.getWfs() != null ? ld.getWfs().toString() : null;
            if (wfsUrl == null && "WFS".equalsIgnoreCase(ld.getOwsType())) {
                wfsUrl = ld.getOwsURL().toString();
            }
            if (wfsUrl == null) {
                wfsUrl = wms.getInfo().getSource().toString();
            }
            if (wfsUrl == null || ld.getQueries() == null || ld.getQueries().length == 0) continue;
            ArrayList<LayerDescription> lds = (ArrayList<LayerDescription>)layerDescByWfs.get(wfsUrl);
            if (lds == null) {
                lds = new ArrayList<LayerDescription>();
                layerDescByWfs.put(wfsUrl, lds);
            }
            lds.add(ld);
        }
        return layerDescByWfs;
    }

    private static void getAllNonVirtualLayers(StringBuffer sb, org.geotools.data.ows.Layer l) {
        if (l.getName() != null) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(l.getName());
        }
        for (org.geotools.data.ows.Layer child : l.getChildren()) {
            WMSService.getAllNonVirtualLayers(sb, child);
        }
    }

    public void loadLayerFeatureTypes(String wfsUrl, List<LayerDescription> layerDescriptions, EntityManager em) {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(WFSDataStoreFactory.URL.key, wfsUrl);
        p.put(WFSDataStoreFactory.USERNAME.key, this.getUsername());
        p.put(WFSDataStoreFactory.PASSWORD.key, this.getPassword());
        try {
            WFSFeatureSource wfsFs = new WFSFeatureSource(p);
            wfsFs.loadFeatureTypes();
            boolean used = false;
            for (LayerDescription ld : layerDescriptions) {
                SimpleFeatureType sft;
                Layer l = this.getLayer(ld.getName(), em);
                if (l == null) continue;
                TreeSet<String> uniqueQueries = new TreeSet<String>(Arrays.asList(ld.getQueries()));
                if (uniqueQueries.size() != 1) {
                    log.warn((Object)("Cannot handle multiple typeNames for layer " + l.getName() + ", only using the first. Type names: " + Arrays.toString(ld.getQueries())));
                }
                if ((sft = wfsFs.getFeatureType((String)uniqueQueries.first())) != null) {
                    l.setFeatureType(sft);
                    log.debug((Object)("Feature type for layer " + l.getName() + " set to feature type " + sft.getTypeName()));
                    used = true;
                    continue;
                }
                log.warn((Object)("Type name " + (String)uniqueQueries.first() + " in WFS for described layer " + l.getName() + " does not exist!"));
            }
            if (used) {
                log.debug((Object)("Type from WFSFeatureSource with url " + wfsUrl + " used by layer of WMS"));
                wfsFs.setLinkedService(this);
            } else {
                log.debug((Object)("No type from WFSFeatureSource with url " + wfsUrl + " used!"));
            }
        }
        catch (Exception e) {
            log.error((Object)("Error loading WFS from url " + wfsUrl), (Throwable)e);
        }
    }
}

