/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.util.databaseupdate;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import nl.b3p.viewer.config.metadata.Metadata;
import nl.b3p.viewer.config.services.SolrConf;
import nl.b3p.viewer.util.databaseupdate.DatabaseSynchronizer;
import nl.b3p.viewer.util.databaseupdate.DatabaseSynchronizerEM;
import nl.b3p.viewer.util.databaseupdate.DatabaseSynchronizerTestInterface;
import nl.b3p.viewer.util.databaseupdate.UpdateElement;
import org.junit.Assert;
import org.junit.Test;

public class DatabaseSynchronizerTest
extends DatabaseSynchronizerTestInterface {
    @Test
    public void testSQLScriptUpdate() {
        DatabaseSynchronizer ds = new DatabaseSynchronizer();
        LinkedHashMap updates = DatabaseSynchronizer.updates;
        Assert.assertFalse((boolean)updates.isEmpty());
        Metadata metadata = (Metadata)this.entityManager.createQuery("From Metadata where configKey = :v", Metadata.class).setParameter("v", (Object)"database_version").getSingleResult();
        String oldVersion = metadata.getConfigValue();
        updates.put("" + TEST_VERSION_NUMBER, new UpdateElement(Collections.singletonList("emptySql.sql"), String.class));
        ds.doInit(this.entityManager);
        Metadata newMetadata = (Metadata)this.entityManager.createQuery("From Metadata where configKey = :v", Metadata.class).setParameter("v", (Object)"database_version").getSingleResult();
        Assert.assertNotEquals((Object)oldVersion, (Object)newMetadata.getConfigValue());
        Assert.assertEquals((long)TEST_VERSION_NUMBER, (long)Integer.parseInt(newMetadata.getConfigValue()));
    }

    @Test
    public void testCodeUpdateWrongMethodname() throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Metadata metadata = (Metadata)this.entityManager.createQuery("From Metadata where configKey = :v", Metadata.class).setParameter("v", (Object)"database_version").getSingleResult();
        String oldVersion = metadata.getConfigValue();
        DatabaseSynchronizer ds = new DatabaseSynchronizer();
        LinkedHashMap updates = DatabaseSynchronizer.updates;
        updates.put("" + TEST_VERSION_NUMBER, new UpdateElement(Collections.singletonList("nonExistentMethod"), DatabaseSynchronizerEM.class));
        ds.doInit(this.entityManager);
        Metadata newMetadata = (Metadata)this.entityManager.createQuery("From Metadata where configKey = :v", Metadata.class).setParameter("v", (Object)"database_version").getSingleResult();
        Assert.assertEquals((Object)oldVersion, (Object)newMetadata.getConfigValue());
    }

    @Test
    public void testConvertSolrConfigReferenceToValues() {
        DatabaseSynchronizer ds = new DatabaseSynchronizer();
        LinkedHashMap updates = DatabaseSynchronizer.updates;
        updates.put("" + TEST_VERSION_NUMBER, new UpdateElement(Collections.singletonList("hqsqldb-solrconf_reference_to_value.sql"), String.class));
        ds.doInit(this.entityManager);
        SolrConf conf = (SolrConf)this.entityManager.find(SolrConf.class, (Object)1L);
        List indexAttrs = conf.getIndexAttributes();
        Assert.assertEquals((Object)"ident", indexAttrs.get(0));
        Assert.assertEquals((Object)"status", indexAttrs.get(1));
        List resultAttrs = conf.getResultAttributes();
        Assert.assertEquals((Object)"ident", resultAttrs.get(0));
        Assert.assertEquals((Object)"status", resultAttrs.get(1));
    }
}

