/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Not;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.stripesstuff.stripersist.Stripersist;

@Entity
@DiscriminatorColumn(name="protocol")
public abstract class FeatureSource {
    @Id
    private Long id;
    @Basic(optional=false)
    private String name;
    @Basic(optional=false)
    private String url;
    private String username;
    private String password;
    @ManyToOne
    private GeoService linkedService;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(inverseJoinColumns={@JoinColumn(name="feature_type")})
    @OrderColumn(name="list_index")
    private List<SimpleFeatureType> featureTypes = new ArrayList<SimpleFeatureType>();

    public List<SimpleFeatureType> getFeatureTypes() {
        return this.featureTypes;
    }

    public void setFeatureTypes(List<SimpleFeatureType> featureTypes) {
        this.featureTypes = featureTypes;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public GeoService getLinkedService() {
        return this.linkedService;
    }

    public void setLinkedService(GeoService linkedService) {
        this.linkedService = linkedService;
    }

    public String getProtocol() {
        return this.getClass().getAnnotation(DiscriminatorValue.class).value();
    }

    List<String> calculateUniqueValues(SimpleFeatureType sft, String attributeName, int maxFeatures) throws Exception {
        org.geotools.data.FeatureSource fs = null;
        try {
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            Function unique = ff.function("Collection_Unique", new Expression[]{ff.property(attributeName)});
            Not notNull = ff.not((Filter)ff.isNull((Expression)ff.property(attributeName)));
            Query q = new Query(sft.getTypeName(), (Filter)notNull);
            q.setMaxFeatures(maxFeatures);
            fs = sft.openGeoToolsFeatureSource();
            FeatureCollection fc = fs.getFeatures(q);
            Object o = unique.evaluate((Object)fc);
            HashSet uniqueValues = (HashSet)o;
            if (uniqueValues == null) {
                uniqueValues = new HashSet();
            }
            ArrayList<String> l = new ArrayList<String>(uniqueValues);
            Collections.sort(l);
            ArrayList<String> arrayList = l;
            return arrayList;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (fs != null && fs.getDataStore() != null) {
                fs.getDataStore().dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getKeyValuePairs(SimpleFeatureType sft, String key, String label, int maxFeatures) throws Exception {
        TreeMap<String, String> output = new TreeMap<String, String>();
        SimpleFeatureSource fs = null;
        try {
            fs = (SimpleFeatureSource)sft.openGeoToolsFeatureSource();
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            Not notNull = ff.not((Filter)ff.isNull((Expression)ff.property(key)));
            Query q = new Query(sft.getTypeName(), (Filter)notNull);
            q.setMaxFeatures(maxFeatures);
            q.setPropertyNames(new String[]{key, label});
            try (SimpleFeatureIterator iterator = fs.getFeatures(q).features();){
                while (iterator.hasNext()) {
                    SimpleFeature f = (SimpleFeature)iterator.next();
                    output.put(f.getAttribute(key).toString(), f.getAttribute(label).toString());
                }
            }
            TreeMap<String, String> treeMap = output;
            return treeMap;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (fs != null && fs.getDataStore() != null) {
                fs.getDataStore().dispose();
            }
        }
    }

    public Object getMaxValue(SimpleFeatureType sft, String attributeName, int maxFeatures) throws Exception {
        org.geotools.data.FeatureSource fs = null;
        try {
            Object value;
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            Function max = ff.function("Collection_Max", new Expression[]{ff.property(attributeName)});
            fs = sft.openGeoToolsFeatureSource();
            FeatureCollection fc = fs.getFeatures();
            Object object = value = max.evaluate((Object)fc);
            return object;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (fs != null && fs.getDataStore() != null) {
                fs.getDataStore().dispose();
            }
        }
    }

    public Object getMinValue(SimpleFeatureType sft, String attributeName, int maxFeatures) throws Exception {
        org.geotools.data.FeatureSource fs = null;
        try {
            Object o;
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            Function minFunction = ff.function("Collection_Min", new Expression[]{ff.property(attributeName)});
            fs = sft.openGeoToolsFeatureSource();
            FeatureCollection f = fs.getFeatures();
            Object object = o = minFunction.evaluate((Object)f);
            return object;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (fs != null && fs.getDataStore() != null) {
                fs.getDataStore().dispose();
            }
        }
    }

    abstract org.geotools.data.FeatureSource openGeoToolsFeatureSource(SimpleFeatureType var1) throws Exception;

    abstract FeatureCollection getFeatures(SimpleFeatureType var1, Filter var2, int var3) throws Exception;

    abstract org.geotools.data.FeatureSource openGeoToolsFeatureSource(SimpleFeatureType var1, int var2) throws Exception;

    public SimpleFeatureType getFeatureType(String typeName) {
        for (SimpleFeatureType sft : this.getFeatureTypes()) {
            if (!sft.getTypeName().equals(typeName)) continue;
            return sft;
        }
        return null;
    }

    public SimpleFeatureType addOrUpdateFeatureType(String typeName, SimpleFeatureType newType, MutableBoolean updated) {
        SimpleFeatureType old = this.getFeatureType(typeName);
        if (old != null) {
            updated.setValue(old.update(newType));
            return old;
        }
        newType.setFeatureSource(this);
        this.getFeatureTypes().add(newType);
        return newType;
    }

    public void removeFeatureType(SimpleFeatureType featureType) {
        Stripersist.getEntityManager().remove((Object)featureType);
        this.getFeatureTypes().remove(featureType);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.getId());
        json.put("name", (Object)this.getName());
        json.put("protocol", (Object)this.getProtocol());
        json.put("url", (Object)this.getUrl());
        return json;
    }
}

