/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.security;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import nl.b3p.viewer.config.security.Group;

@Entity
@Table(name="user_")
public class User
implements Principal {
    public static final String DETAIL_EMAIL = "email";
    public static final int MIN_PASSWORD_LENGTH = 8;
    private static final String DIGEST_ALGORITM = "SHA-1";
    private static final String DIGEST_CHARSET = "UTF-8";
    @Id
    private String username;
    private String password;
    @ManyToMany
    @JoinTable(name="user_groups", joinColumns={@JoinColumn(name="username")}, inverseJoinColumns={@JoinColumn(name="group_")})
    private Set<Group> groups = new HashSet<Group>();
    @ElementCollection
    @JoinTable(joinColumns={@JoinColumn(name="username")})
    private Map<String, String> details = new HashMap<String, String>();
    @ElementCollection
    @Column(name="ipaddress", length=45)
    @CollectionTable(joinColumns={@JoinColumn(name="user_")})
    private Set<String> ips = new HashSet<String>();
    @Transient
    private boolean authenticatedByIp = false;

    public void changePassword(String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance(DIGEST_ALGORITM);
        md.update(password.getBytes(DIGEST_CHARSET));
        byte[] digest = md.digest();
        StringBuilder sb = new StringBuilder(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            sb.append(Integer.toHexString(digest[i] >> 4 & 0xF));
            sb.append(Integer.toHexString(digest[i] & 0xF));
        }
        this.setPassword(sb.toString());
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<Group> groups) {
        this.groups = groups;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Set<String> getIps() {
        return this.ips;
    }

    public void setIps(Set<String> ips) {
        this.ips = ips;
    }

    public boolean checkRole(String role) {
        for (Group group : this.groups) {
            if (!group.getName().equals(role)) continue;
            return true;
        }
        return false;
    }

    public boolean isAuthenticatedByIp() {
        return this.authenticatedByIp;
    }

    public void setAuthenticatedByIp(boolean authenticatedByIp) {
        this.authenticatedByIp = authenticatedByIp;
    }

    @Override
    public String getName() {
        return this.username;
    }
}

