/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.UpdateResult;
import nl.b3p.web.WaitPageStatus;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FeatureSourceUpdateResult {
    private static final Log log = LogFactory.getLog(FeatureSourceUpdateResult.class);
    private FeatureSource featureSource;
    private UpdateResult.Status status = UpdateResult.Status.FAILED;
    private WaitPageStatus waitPageStatus = new WaitPageStatus();
    private Throwable exception;
    private String message = "Unknown error";
    private SortedMap<String, MutablePair<SimpleFeatureType, UpdateResult.Status>> featureTypeStatus = new TreeMap<String, MutablePair<SimpleFeatureType, UpdateResult.Status>>();

    public FeatureSourceUpdateResult(FeatureSource toUpdate) {
        this.featureSource = toUpdate;
        List<SimpleFeatureType> fts = this.featureSource.getFeatureTypes();
        if (fts.isEmpty()) {
            this.waitPageStatus.addLog("Before update: FeatureSource has no featuretypes");
        } else {
            for (SimpleFeatureType ft : fts) {
                this.featureTypeStatus.put(ft.getTypeName(), (MutablePair<SimpleFeatureType, UpdateResult.Status>)new MutablePair((Object)ft, (Object)UpdateResult.Status.MISSING));
            }
            this.waitPageStatus.addLog("Before update: service has %d featuretypes", new Object[]{fts.size()});
        }
    }

    public Map<UpdateResult.Status, List<String>> getLayerNamesByStatus() {
        HashMap<UpdateResult.Status, List<String>> byStatus = new HashMap<UpdateResult.Status, List<String>>();
        byStatus.put(UpdateResult.Status.NEW, new ArrayList());
        byStatus.put(UpdateResult.Status.UNMODIFIED, new ArrayList());
        byStatus.put(UpdateResult.Status.UPDATED, new ArrayList());
        byStatus.put(UpdateResult.Status.MISSING, new ArrayList());
        for (Map.Entry<String, MutablePair<SimpleFeatureType, UpdateResult.Status>> entry : this.featureTypeStatus.entrySet()) {
            List layers = (List)byStatus.get(entry.getValue().getRight());
            layers.add(entry.getKey());
        }
        return byStatus;
    }

    public Map<UpdateResult.Status, List<SimpleFeatureType>> getFeatureTypeByStatus() {
        HashMap<UpdateResult.Status, List<SimpleFeatureType>> byStatus = new HashMap<UpdateResult.Status, List<SimpleFeatureType>>();
        byStatus.put(UpdateResult.Status.NEW, new ArrayList());
        byStatus.put(UpdateResult.Status.UNMODIFIED, new ArrayList());
        byStatus.put(UpdateResult.Status.UPDATED, new ArrayList());
        byStatus.put(UpdateResult.Status.MISSING, new ArrayList());
        for (Map.Entry<String, MutablePair<SimpleFeatureType, UpdateResult.Status>> entry : this.featureTypeStatus.entrySet()) {
            List layers = (List)byStatus.get(entry.getValue().getRight());
            layers.add(entry.getValue().getLeft());
        }
        return byStatus;
    }

    public void failedWithException(Exception e) {
        this.exception = e;
        this.setStatus(UpdateResult.Status.FAILED);
        String msg = String.format("Error updating %s service #%d \"%s\": %s: %s", this.featureSource.getProtocol(), this.featureSource.getId(), this.featureSource.getName(), e.getClass().getName(), e.getMessage());
        log.error((Object)msg, (Throwable)e);
        this.setMessage(msg);
    }

    public void changed() {
        this.status = UpdateResult.Status.CHANGED;
    }

    public WaitPageStatus getWaitPageStatus() {
        return this.waitPageStatus;
    }

    public FeatureSource getFeatureSource() {
        return this.featureSource;
    }

    public void setFeatureSource(FeatureSource featureSource) {
        this.featureSource = featureSource;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public UpdateResult.Status getStatus() {
        return this.status;
    }

    public void setStatus(UpdateResult.Status status) {
        this.status = status;
    }

    public SortedMap<String, MutablePair<SimpleFeatureType, UpdateResult.Status>> getFeatureTypeStatus() {
        return this.featureTypeStatus;
    }

    public void setFeatureTypeStatus(SortedMap<String, MutablePair<SimpleFeatureType, UpdateResult.Status>> featureTypeStatus) {
        this.featureTypeStatus = featureTypeStatus;
    }
}

