/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import nl.b3p.viewer.config.services.FeatureTypeRelationKey;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
public class FeatureTypeRelation {
    public static final String JOIN = "join";
    public static final String RELATE = "relate";
    @Id
    private Long id;
    @ManyToOne
    private SimpleFeatureType featureType;
    @ManyToOne
    private SimpleFeatureType foreignFeatureType;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="relation", orphanRemoval=true)
    private List<FeatureTypeRelationKey> relationKeys = new ArrayList<FeatureTypeRelationKey>();
    private String type;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public List<FeatureTypeRelationKey> getRelationKeys() {
        return this.relationKeys;
    }

    public void setRelationKeys(List<FeatureTypeRelationKey> relationKeys) {
        this.relationKeys = relationKeys;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SimpleFeatureType getForeignFeatureType() {
        return this.foreignFeatureType;
    }

    public void setForeignFeatureType(SimpleFeatureType foreignFeatureType) {
        this.foreignFeatureType = foreignFeatureType;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject j = new JSONObject();
        j.put("type", (Object)this.type);
        if (this.featureType != null) {
            j.put("featureType", (Object)this.featureType.getId());
        }
        if (this.foreignFeatureType != null) {
            j.put("foreignFeatureType", (Object)this.foreignFeatureType.getId());
            JSONArray jRel = new JSONArray();
            if (!this.foreignFeatureType.getRelations().isEmpty()) {
                j.put("relations", (Object)jRel);
                for (FeatureTypeRelation rel : this.foreignFeatureType.getRelations()) {
                    jRel.put((Object)rel.toJSONObject());
                }
            }
        }
        return j;
    }
}

