/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import nl.b3p.viewer.config.services.TileMatrixSet;
import org.json.JSONObject;

@Entity
public class TileMatrix {
    @Id
    private Long id;
    private String identifier;
    private String title;
    private String description;
    private String scaleDenominator;
    private String topLeftCorner;
    private int tileWidth;
    private int tileHeight;
    private int matrixWidth;
    private int matrixHeight;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private TileMatrixSet matrixSet;

    public static TileMatrix fromJSONObject(JSONObject tilematrix) {
        TileMatrix tm = new TileMatrix();
        tm.setDescription(tilematrix.optString("description"));
        tm.setMatrixHeight(tilematrix.getInt("matrixHeight"));
        tm.setMatrixWidth(tilematrix.getInt("matrixWidth"));
        tm.setScaleDenominator(tilematrix.getString("scaleDenominator"));
        tm.setTopLeftCorner(tilematrix.getString("topLeftCorner"));
        tm.setTileHeight(tilematrix.getInt("tileHeight"));
        tm.setTileWidth(tilematrix.getInt("tileWidth"));
        tm.setIdentifier(tilematrix.getString("identifier"));
        tm.setTitle(tilematrix.optString("title"));
        return tm;
    }

    public JSONObject toJSONObject() {
        JSONObject obj = new JSONObject();
        obj.put("id", (Object)this.id);
        obj.put("identifier", (Object)this.identifier);
        obj.put("title", (Object)this.title);
        obj.put("description", (Object)this.description);
        obj.put("scaleDenominator", (Object)this.scaleDenominator);
        obj.put("topLeftCorner", (Object)this.topLeftCorner);
        obj.put("tileWidth", this.tileWidth);
        obj.put("tileHeight", this.tileHeight);
        obj.put("matrixWidth", this.matrixWidth);
        obj.put("matrixHeight", this.matrixHeight);
        return obj;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getScaleDenominator() {
        return this.scaleDenominator;
    }

    public void setScaleDenominator(String scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    public int getMatrixWidth() {
        return this.matrixWidth;
    }

    public void setMatrixWidth(int matrixWidth) {
        this.matrixWidth = matrixWidth;
    }

    public int getMatrixHeight() {
        return this.matrixHeight;
    }

    public void setMatrixHeight(int matrixHeight) {
        this.matrixHeight = matrixHeight;
    }

    public TileMatrixSet getMatrixSet() {
        return this.matrixSet;
    }

    public void setMatrixSet(TileMatrixSet matrixSet) {
        this.matrixSet = matrixSet;
    }

    public String getTopLeftCorner() {
        return this.topLeftCorner;
    }

    public void setTopLeftCorner(String topLeftCorner) {
        this.topLeftCorner = topLeftCorner;
    }
}

