/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import nl.b3p.viewer.config.services.BoundingBox;
import nl.b3p.viewer.config.services.TileMatrix;
import nl.b3p.viewer.config.services.TileService;
import org.json.JSONArray;
import org.json.JSONObject;

@Entity
public class TileMatrixSet {
    @Id
    private Long id;
    private String identifier;
    private String crs;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="matrixSet")
    private List<TileMatrix> matrices = new ArrayList<TileMatrix>();
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private TileService tileService;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="crs.name", column=@Column(name="max_crs")), @AttributeOverride(name="minx", column=@Column(name="max_minx")), @AttributeOverride(name="maxx", column=@Column(name="max_maxx")), @AttributeOverride(name="miny", column=@Column(name="max_miny")), @AttributeOverride(name="maxy", column=@Column(name="max_maxy"))})
    private BoundingBox bbox;

    public static TileMatrixSet fromJSONObject(JSONObject obj) {
        TileMatrixSet tms = new TileMatrixSet();
        BoundingBox bbox = BoundingBox.fromJSONObject(obj.getJSONObject("bbox"));
        tms.setBbox(bbox);
        tms.setCrs(obj.getString("crs"));
        tms.setIdentifier(obj.getString("identifier"));
        JSONArray tmses = obj.getJSONArray("matrices");
        for (int i = 0; i < tmses.length(); ++i) {
            JSONObject tmObj = tmses.getJSONObject(i);
            TileMatrix tm = TileMatrix.fromJSONObject(tmObj);
            tm.setMatrixSet(tms);
            tms.getMatrices().add(tm);
        }
        return tms;
    }

    public JSONObject toJSONObject() {
        JSONObject obj = new JSONObject();
        obj.put("id", (Object)this.id);
        obj.put("identifier", (Object)this.identifier);
        obj.put("crs", (Object)this.crs);
        JSONArray matricesJSON = new JSONArray();
        for (TileMatrix matrix : this.matrices) {
            matricesJSON.put((Object)matrix.toJSONObject());
        }
        obj.put("matrices", (Object)matricesJSON);
        if (this.bbox != null) {
            obj.put("bbox", (Object)this.bbox.toJSONObject());
        }
        return obj;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getCrs() {
        return this.crs;
    }

    public void setCrs(String crs) {
        this.crs = crs;
    }

    public List<TileMatrix> getMatrices() {
        return this.matrices;
    }

    public void setMatrices(List<TileMatrix> matrices) {
        this.matrices = matrices;
    }

    public TileService getTileService() {
        return this.tileService;
    }

    public void setTileService(TileService tileService) {
        this.tileService = tileService;
    }

    public BoundingBox getBbox() {
        return this.bbox;
    }

    public void setBbox(BoundingBox bbox) {
        this.bbox = bbox;
    }
}

