/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.app;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PostPersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBeanContext;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.Bookmark;
import nl.b3p.viewer.config.app.ConfiguredComponent;
import nl.b3p.viewer.config.app.Level;
import nl.b3p.viewer.config.app.StartLayer;
import nl.b3p.viewer.config.app.StartLevel;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.security.User;
import nl.b3p.viewer.config.services.BoundingBox;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.util.ApplicationDetailsValueTransformer;
import nl.b3p.viewer.util.SelectedContentCache;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.annotations.Type;
import org.hibernate.transform.ResultTransformer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"name", "version"})})
public class Application {
    private static final Log log = LogFactory.getLog(Application.class);
    public static final String DETAIL_IS_MASHUP = "isMashup";
    public static final String DETAIL_GLOBAL_LAYOUT = "globalLayout";
    public static final String DETAIL_LAST_SPINUP_TIME = "lastSpinupTime";
    private static Set adminOnlyDetails = new HashSet<String>(Arrays.asList("opmerking"));
    public static final Set<String> preventClearDetails = new HashSet<String>(Arrays.asList("isMashup", "globalLayout"));
    @Id
    private Long id;
    @Basic(optional=false)
    private String name;
    @Column(length=30)
    private String version;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String layout;
    @ElementCollection
    @JoinTable(joinColumns={@JoinColumn(name="application")})
    private Map<String, ClobElement> details = new HashMap<String, ClobElement>();
    @ManyToOne
    private User owner;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="crs.name", column=@Column(name="start_crs")), @AttributeOverride(name="minx", column=@Column(name="start_minx")), @AttributeOverride(name="maxx", column=@Column(name="start_maxx")), @AttributeOverride(name="miny", column=@Column(name="start_miny")), @AttributeOverride(name="maxy", column=@Column(name="start_maxy"))})
    private BoundingBox startExtent;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="crs.name", column=@Column(name="max_crs")), @AttributeOverride(name="minx", column=@Column(name="max_minx")), @AttributeOverride(name="maxx", column=@Column(name="max_maxx")), @AttributeOverride(name="miny", column=@Column(name="max_miny")), @AttributeOverride(name="maxy", column=@Column(name="max_maxy"))})
    private BoundingBox maxExtent;
    private boolean authenticatedRequired;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Level root;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="application")
    private Set<ConfiguredComponent> components = new HashSet<ConfiguredComponent>();
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date authorizationsModified = new Date();
    @Transient
    Map originalToCopy;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="application")
    private List<Bookmark> bookmarks = new ArrayList<Bookmark>();
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="application")
    private List<StartLayer> startLayers = new ArrayList<StartLayer>();
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="application")
    private List<StartLevel> startLevels = new ArrayList<StartLevel>();
    @ElementCollection
    @Column(name="role_name")
    private Set<String> readers = new HashSet<String>();
    @Transient
    private TreeCache treeCache;
    @Transient
    private Boolean isMashup_cached;
    @Transient
    public Map<String, Long> idMap;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public Map<String, ClobElement> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, ClobElement> details) {
        this.details = details;
    }

    public boolean isAuthenticatedRequired() {
        return this.authenticatedRequired;
    }

    public void setAuthenticatedRequired(boolean authenticatedRequired) {
        this.authenticatedRequired = authenticatedRequired;
    }

    public Set<ConfiguredComponent> getComponents() {
        return this.components;
    }

    public void setComponents(Set<ConfiguredComponent> components) {
        this.components = components;
    }

    public BoundingBox getMaxExtent() {
        return this.maxExtent;
    }

    public void setMaxExtent(BoundingBox maxExtent) {
        this.maxExtent = maxExtent;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public Level getRoot() {
        return this.root;
    }

    public void setRoot(Level root) {
        this.root = root;
    }

    public BoundingBox getStartExtent() {
        return this.startExtent;
    }

    public void setStartExtent(BoundingBox startExtent) {
        this.startExtent = startExtent;
    }

    public Date getAuthorizationsModified() {
        return this.authorizationsModified;
    }

    public void setAuthorizationsModified(Date authorizationsModified) {
        this.authorizationsModified = authorizationsModified;
    }

    public List<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    public void setBookmarks(List<Bookmark> bookmarks) {
        this.bookmarks = bookmarks;
    }

    public List<StartLayer> getStartLayers() {
        return this.startLayers;
    }

    public void setStartLayers(List<StartLayer> startLayers) {
        this.startLayers = startLayers;
    }

    public List<StartLevel> getStartLevels() {
        return this.startLevels;
    }

    public void setStartLevels(List<StartLevel> startLevels) {
        this.startLevels = startLevels;
    }

    public Set<String> getReaders() {
        return this.readers;
    }

    public void setReaders(Set<String> readers) {
        this.readers = readers;
    }

    public String getNameWithVersion() {
        String n = this.getName();
        if (this.getVersion() != null) {
            n = n + " v" + this.getVersion();
        }
        return n;
    }

    public TreeCache getTreeCache() {
        return this.treeCache;
    }

    public void setTreeCache(TreeCache treeCache) {
        this.treeCache = treeCache;
    }

    public TreeCache loadTreeCache(EntityManager em) {
        if (this.treeCache == null) {
            this.treeCache = new TreeCache();
            this.treeCache.levels = em.createNamedQuery("getLevelTree").setParameter("rootId", (Object)this.root.getId()).getResultList();
            this.treeCache.childrenByParent = new HashMap<Level, List<Level>>();
            this.treeCache.applicationLayers = new ArrayList<ApplicationLayer>();
            for (Level l : this.treeCache.levels) {
                this.treeCache.applicationLayers.addAll(l.getLayers());
                if (l.getParent() == null) continue;
                List<Level> parentChildren = this.treeCache.childrenByParent.get(l.getParent());
                if (parentChildren == null) {
                    parentChildren = new ArrayList<Level>();
                    this.treeCache.childrenByParent.put(l.getParent(), parentChildren);
                }
                parentChildren.add(l);
            }
        }
        return this.treeCache;
    }

    public void authorizationsModified() {
        this.authorizationsModified = new Date();
    }

    public String toJSON(HttpServletRequest request, boolean validXmlTags, boolean onlyServicesAndLayers, EntityManager em) throws JSONException {
        return this.toJSON(request, validXmlTags, onlyServicesAndLayers, false, false, em);
    }

    public String toJSON(HttpServletRequest request, boolean validXmlTags, boolean onlyServicesAndLayers, boolean includeAppLayerAttributes, boolean includeRelations, EntityManager em) throws JSONException {
        JSONObject o = null;
        SelectedContentCache cache = new SelectedContentCache();
        o = cache.getSelectedContent(request, this, validXmlTags, includeAppLayerAttributes, includeRelations, em);
        o.put("id", (Object)this.id);
        o.put("name", (Object)this.name);
        if (!onlyServicesAndLayers && this.layout != null) {
            o.put("layout", (Object)new JSONObject(this.layout));
        }
        o.put("version", (Object)this.version);
        if (!onlyServicesAndLayers) {
            JSONObject d = new JSONObject();
            o.put("details", (Object)d);
            for (Map.Entry<String, ClobElement> e : this.details.entrySet()) {
                if (adminOnlyDetails.contains(e.getKey())) continue;
                d.put(e.getKey(), (Object)e.getValue());
            }
        }
        if (!onlyServicesAndLayers) {
            if (this.startExtent != null) {
                o.put("startExtent", (Object)this.startExtent.toJSONObject());
            }
            if (this.maxExtent != null) {
                o.put("maxExtent", (Object)this.maxExtent.toJSONObject());
            }
        }
        if (!onlyServicesAndLayers) {
            em.createQuery("from ConfiguredComponent cc left join fetch cc.details where application = :this").setParameter("this", (Object)this).getResultList();
            JSONObject c = new JSONObject();
            o.put("components", (Object)c);
            for (ConfiguredComponent comp : this.components) {
                if (!Authorizations.isConfiguredComponentAuthorized(comp, request, em)) continue;
                c.put(comp.getName(), (Object)comp.toJSON());
            }
        }
        return o.toString(4);
    }

    private void walkAppTreeForJSON(JSONObject levels, JSONObject appLayers, List selectedContent, Level l, boolean parentIsBackground, HttpServletRequest request, boolean validXmlTags, boolean includeAppLayerAttributes, boolean includeRelations, EntityManager em) throws JSONException {
        JSONObject o = l.toJSONObject(false, this, request, em);
        o.put("background", l.isBackground() || parentIsBackground);
        String levelId = l.getId().toString();
        if (validXmlTags) {
            levelId = "level_" + levelId;
        }
        levels.put(levelId, (Object)o);
        StartLevel sl = l.getStartLevels().get(this);
        if (sl != null && sl.getSelectedIndex() != null) {
            selectedContent.add(l);
        }
        for (ApplicationLayer al : l.getLayers()) {
            if (!Authorizations.isAppLayerReadAuthorized(this, al, request, em)) continue;
            JSONObject p = al.toJSONObject(includeAppLayerAttributes, includeRelations, em, this);
            p.put("background", l.isBackground() || parentIsBackground);
            p.put("editAuthorized", Authorizations.isAppLayerWriteAuthorized(this, al, request, em));
            String alId = al.getId().toString();
            if (validXmlTags) {
                alId = "appLayer_" + alId;
            }
            appLayers.put(alId, (Object)p);
            StartLayer startLayer = al.getStartLayers().get(this);
            if (startLayer == null || startLayer.getSelectedIndex() == null) continue;
            selectedContent.add(al);
        }
        List<Level> children = this.treeCache.childrenByParent.get(l);
        if (children != null) {
            Collections.sort(children);
            JSONArray jsonChildren = new JSONArray();
            o.put("children", (Object)jsonChildren);
            for (Level child : children) {
                if (!Authorizations.isLevelReadAuthorized(this, child, request, em)) continue;
                String childId = child.getId().toString();
                if (validXmlTags) {
                    childId = "level_" + childId;
                }
                jsonChildren.put((Object)childId);
                this.walkAppTreeForJSON(levels, appLayers, selectedContent, child, l.isBackground(), request, validXmlTags, includeAppLayerAttributes, includeRelations, em);
            }
        }
    }

    private void visitLevelForUsedServicesLayers(Level l, Map<GeoService, Set<String>> usedLayersByService, HttpServletRequest request, EntityManager em) {
        if (!Authorizations.isLevelReadAuthorized(this, l, request, em)) {
            return;
        }
        for (ApplicationLayer al : l.getLayers()) {
            if (!Authorizations.isAppLayerReadAuthorized(this, al, request, em)) continue;
            GeoService gs = al.getService();
            Set<String> usedLayers = usedLayersByService.get(gs);
            if (usedLayers == null) {
                usedLayers = new HashSet<String>();
                usedLayersByService.put(gs, usedLayers);
            }
            usedLayers.add(al.getLayerName());
        }
        List<Level> children = this.treeCache.childrenByParent.get(l);
        if (children != null) {
            for (Level child : children) {
                this.visitLevelForUsedServicesLayers(child, usedLayersByService, request, em);
            }
        }
    }

    public Boolean isMashup() {
        if (this.getDetails().containsKey(DETAIL_IS_MASHUP)) {
            String mashupValue = this.getDetails().get(DETAIL_IS_MASHUP).getValue();
            this.isMashup_cached = Boolean.valueOf(mashupValue);
        } else {
            this.isMashup_cached = Boolean.FALSE;
        }
        return this.isMashup_cached;
    }

    public Boolean isMashup(Session sess) {
        if (this.isMashup_cached == null) {
            this.isMashup_cached = Boolean.FALSE;
            List items = sess.createSQLQuery("select d.value from application_details d where d.details_key = 'isMashup' and d.application =  :appId").setLong("appId", this.getId().longValue()).setResultTransformer((ResultTransformer)ApplicationDetailsValueTransformer.INSTANCE).list();
            if (items.size() > 0) {
                String mashupValue = ((Map)items.get(0)).get("value").toString();
                this.isMashup_cached = Boolean.valueOf(mashupValue);
            }
        }
        return this.isMashup_cached;
    }

    public Application createMashup(String mashupName, EntityManager em, boolean linkComponents) throws Exception {
        Application source = this;
        if (!em.contains((Object)source)) {
            source = (Application)em.merge((Object)source);
        }
        Application mashup = source.deepCopyAllButLevels(linkComponents);
        mashup.setName(mashup.getName() + "_" + mashupName);
        em.persist((Object)mashup);
        if (mashup.getRoot() != null) {
            mashup.getRoot().processForMashup(mashup, source);
        }
        this.isMashup_cached = Boolean.TRUE;
        mashup.getDetails().put(DETAIL_IS_MASHUP, new ClobElement(this.isMashup_cached + ""));
        return mashup;
    }

    public List<Application> getMashups(EntityManager em) {
        return em.createQuery("from Application where root = :level and id <> :oldId").setParameter("level", (Object)this.getRoot()).setParameter("oldId", (Object)this.getId()).getResultList();
    }

    public Application deepCopy() throws Exception {
        Application copy = this.deepCopyAllButLevels(false);
        copy.originalToCopy = new HashMap();
        if (this.root != null) {
            copy.setRoot(this.root.deepCopy(null, copy.originalToCopy, copy));
        }
        return copy;
    }

    private Application deepCopyAllButLevels(boolean linkComponents) throws Exception {
        Application copy = (Application)BeanUtils.cloneBean((Object)this);
        copy.setId(null);
        copy.setBookmarks(null);
        copy.setTreeCache(null);
        copy.setStartLayers(new ArrayList<StartLayer>());
        copy.setStartLevels(new ArrayList<StartLevel>());
        copy.setReaders(new HashSet<String>());
        copy.setDetails(new HashMap<String, ClobElement>(this.details));
        if (this.startExtent != null) {
            copy.setStartExtent(this.startExtent.clone());
        }
        if (this.maxExtent != null) {
            copy.setMaxExtent(this.maxExtent.clone());
        }
        copy.setComponents(new HashSet<ConfiguredComponent>());
        for (ConfiguredComponent cc : this.components) {
            ConfiguredComponent componentCopy = cc.deepCopy(copy);
            copy.getComponents().add(componentCopy);
            if (!linkComponents) continue;
            componentCopy.setMotherComponent(cc);
            cc.getLinkedComponents().add(componentCopy);
        }
        for (String reader : this.readers) {
            copy.getReaders().add(reader);
        }
        return copy;
    }

    public void transferMashup(Application old, EntityManager em) {
        this.originalToCopy = new HashMap();
        this.loadTreeCache(em);
        this.visitLevelForMashuptransfer(old.getRoot(), this.originalToCopy);
        this.processCopyMap();
    }

    private void visitLevelForMashuptransfer(Level oldLevel, Map originalToCopy) {
        Level newLevel = this.findLevel(oldLevel);
        if (newLevel != null) {
            originalToCopy.put(oldLevel, newLevel);
        }
        for (ApplicationLayer oldLayer : oldLevel.getLayers()) {
            ApplicationLayer newLayer = this.findLayer(oldLayer);
            if (newLayer == null) continue;
            originalToCopy.put(oldLayer, newLayer);
        }
        for (Level oldChild : oldLevel.getChildren()) {
            this.visitLevelForMashuptransfer(oldChild, originalToCopy);
        }
    }

    private ApplicationLayer findLayer(ApplicationLayer oldLayer) {
        List<ApplicationLayer> appLayers = this.treeCache.applicationLayers;
        for (ApplicationLayer appLayer : appLayers) {
            if (!appLayer.getService().equals(oldLayer.getService()) || !appLayer.getLayerName().equals(oldLayer.getLayerName())) continue;
            return appLayer;
        }
        return null;
    }

    private Level findLevel(Level oldLevel) {
        List<Level> levels = this.treeCache.levels;
        for (Level level : levels) {
            if (!level.getName().equals(oldLevel.getName())) continue;
            return level;
        }
        return null;
    }

    @PostPersist
    public void postPersist() {
        if (this.isMashup().booleanValue()) {
            log.debug((Object)"postPersist(): mashup");
            return;
        }
        this.processCopyMap();
    }

    private void processCopyMap() {
        if (this.originalToCopy == null) {
            log.debug((Object)"postPersist(): not a copy");
            return;
        }
        this.idMap = this.getIdMap();
        this.originalToCopy = null;
        log.debug((Object)"Updating component configs");
        for (ConfiguredComponent comp : this.components) {
            if (comp.getConfig() == null) continue;
            log.debug((Object)String.format("Checking component class %s, name %s", comp.getClassName(), comp.getName()));
            boolean changed = false;
            try {
                Long newId;
                int i;
                JSONObject cfg = new JSONObject(comp.getConfig());
                if (cfg.has("layers")) {
                    JSONArray layers = cfg.getJSONArray("layers");
                    for (i = 0; i < layers.length(); ++i) {
                        newId = this.idMap.get(ApplicationLayer.class + "_" + layers.getInt(i));
                        if (newId != null) {
                            log.debug((Object)String.format("Index %d: new id for application layer %d is %d", i, layers.getInt(i), newId));
                            layers.put(i, newId.longValue());
                        } else {
                            log.debug((Object)String.format("Index %d: old id %d was not a valid application layer in original", i, layers.getInt(i)));
                            layers.put(i, -1);
                        }
                        changed = true;
                    }
                }
                if (cfg.has("levels")) {
                    JSONArray levels = cfg.getJSONArray("levels");
                    for (i = 0; i < levels.length(); ++i) {
                        newId = this.idMap.get(Level.class + "_" + levels.getInt(i));
                        if (newId != null) {
                            log.debug((Object)String.format("Index %d: new id for level %d is %d", i, levels.getInt(i), newId));
                            levels.put(i, newId.longValue());
                        } else {
                            log.debug((Object)String.format("Index %d: old id %d was not a valid level in original", i, levels.getInt(i)));
                            levels.put(i, -1);
                        }
                        changed = true;
                    }
                }
                if (!changed) continue;
                log.debug((Object)("Old config: " + comp.getConfig()));
                comp.setConfig(cfg.toString());
                log.debug((Object)("New config: " + comp.getConfig()));
            }
            catch (Exception ex) {
                log.error((Object)String.format("Cannot update persistent object id's in component config on application copy, copied application=%s, component class=%s, component name=%s", this.getNameWithVersion(), comp.getClassName(), comp.getName()), (Throwable)ex);
            }
        }
    }

    private Map<String, Long> getIdMap() {
        HashMap<String, Long> idMap = new HashMap<String, Long>();
        Iterator iterator = this.originalToCopy.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e;
            Map.Entry entry = e = iterator.next();
            Object original = entry.getKey();
            Object copy = entry.getValue();
            log.debug((Object)String.format("postPersist(): original=%s, copy=%s", original, copy));
            if (original instanceof Level) {
                Level oL = (Level)original;
                Level cL = (Level)copy;
                idMap.put(original.getClass() + "_" + oL.getId(), cL.getId());
                continue;
            }
            if (!(original instanceof ApplicationLayer)) continue;
            ApplicationLayer oAl = (ApplicationLayer)original;
            ApplicationLayer cAl = (ApplicationLayer)copy;
            idMap.put(original.getClass() + "_" + oAl.getId(), cAl.getId());
        }
        return idMap;
    }

    public void processBookmarks(Application previousApplication, ActionBeanContext context, EntityManager em) {
        List bookmarkComponents = em.createQuery("FROM ConfiguredComponent where application.id = :app and className = :className", ConfiguredComponent.class).setParameter("app", (Object)previousApplication.getId()).setParameter("className", (Object)"viewer.components.Bookmark").getResultList();
        for (ConfiguredComponent comp : bookmarkComponents) {
            String config = comp.getConfig();
            if (config == null || config.isEmpty()) continue;
            try {
                JSONObject conf = new JSONObject(config);
                if (!conf.optBoolean("copyBookmarkForWorkversion", false)) continue;
                List bookmarks = em.createQuery("FROM Bookmark where application = :app", Bookmark.class).setParameter("app", (Object)previousApplication).getResultList();
                for (Bookmark bookmark : bookmarks) {
                    Bookmark clone = bookmark.clone();
                    clone.setCreatedBy(Bookmark.createCreatedBy(context));
                    clone.setApplication(this);
                    this.processBookmark(clone, this.idMap);
                    em.persist((Object)clone);
                    clone.setCode(bookmark.getCode());
                    em.persist((Object)clone);
                }
            }
            catch (JSONException ex) {
                log.error((Object)"Cannot convert bookmarks.", (Throwable)ex);
            }
        }
        previousApplication = null;
    }

    private void processBookmark(Bookmark bookmark, Map<String, Long> idMap) throws JSONException {
        JSONObject bm = new JSONObject(bookmark.getParams());
        JSONArray params = bm.getJSONArray("params");
        JSONArray newParams = new JSONArray();
        for (int i = 0; i < params.length(); ++i) {
            Long newId;
            int j;
            JSONObject param = params.getJSONObject(i);
            JSONArray value = param.optJSONArray("value");
            if (param.getString("name").equals("layers")) {
                JSONArray newLayers = new JSONArray();
                for (j = 0; j < value.length(); ++j) {
                    Integer layerId = value.getInt(j);
                    newId = idMap.get(ApplicationLayer.class + "_" + layerId);
                    newLayers.put((Object)newId);
                }
                param.put("value", (Object)newLayers);
            } else if (param.getString("name").equals("levelOrder")) {
                JSONArray newLevels = new JSONArray();
                for (j = 0; j < value.length(); ++j) {
                    Integer levelId = value.getInt(j);
                    newId = idMap.get(Level.class + "_" + levelId);
                    newLevels.put((Object)newId);
                }
                param.put("value", (Object)newLevels);
            } else if (param.getString("name").equals("selectedContent")) {
                for (int j2 = 0; j2 < value.length(); ++j2) {
                    JSONObject content = value.getJSONObject(j2);
                    if (!content.optString("type", "level").equals("level")) continue;
                    Long newId2 = idMap.get(Level.class + "_" + content.getString("id"));
                    content.put("id", (Object)newId2);
                }
            }
            newParams.put((Object)param);
        }
        JSONObject newBm = new JSONObject();
        newBm.put("params", (Object)newParams);
        bookmark.setParams(newBm.toString());
    }

    public void removeOldProperties() {
        if (this.details.containsKey("maxWidth")) {
            this.details.remove("maxWidth");
        }
        if (this.details.containsKey("maxHeight")) {
            this.details.remove("maxHeight");
        }
    }

    public void setGlobalLayout(String globalLayout) {
        this.details.put(DETAIL_GLOBAL_LAYOUT, new ClobElement(globalLayout));
    }

    public JSONObject getGlobalLayout() throws JSONException {
        JSONObject globalLayout = new JSONObject();
        if (this.getDetails().containsKey(DETAIL_GLOBAL_LAYOUT)) {
            globalLayout = new JSONObject(this.getDetails().get(DETAIL_GLOBAL_LAYOUT).getValue());
        }
        if (!globalLayout.has("maxWidth") && this.getDetails().containsKey("maxWidth")) {
            globalLayout.put("maxWidth", (Object)this.getDetails().get("maxWidth").getValue());
        }
        if (!globalLayout.has("maxHeight") && this.getDetails().containsKey("maxHeight")) {
            globalLayout.put("maxHeight", (Object)this.getDetails().get("maxHeight").getValue());
        }
        return globalLayout;
    }

    public static class TreeCache {
        List<Level> levels;
        Map<Level, List<Level>> childrenByParent;
        List<ApplicationLayer> applicationLayers;

        public List<ApplicationLayer> getApplicationLayers() {
            return this.applicationLayers;
        }

        public Map<Level, List<Level>> getChildrenByParent() {
            return this.childrenByParent;
        }

        public List<Level> getChildren(Level l) {
            List<Level> children = this.childrenByParent.get(l);
            if (children == null) {
                return Collections.EMPTY_LIST;
            }
            return children;
        }

        public List<Level> getLevels() {
            return this.levels;
        }

        public void initializeLevels(String leftJoins, EntityManager em) {
            List<Level> subList;
            int i = 0;
            do {
                subList = this.levels.subList(i, Math.min(this.levels.size(), i + 500));
                em.createQuery("from Level l " + leftJoins + " where l in (:levels) ").setParameter("levels", subList).getResultList();
            } while ((i += subList.size()) < this.levels.size());
        }

        public void initializeApplicationLayers(String leftJoins, EntityManager em) {
            if (!this.getApplicationLayers().isEmpty()) {
                List<ApplicationLayer> subList;
                int i = 0;
                do {
                    subList = this.applicationLayers.subList(i, Math.min(this.applicationLayers.size(), i + 500));
                    em.createQuery("from ApplicationLayer al " + leftJoins + " where al in (:alayers) ").setParameter("alayers", subList).getResultList();
                } while ((i += subList.size()) < this.applicationLayers.size());
            }
        }
    }
}

