/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.app;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ConfiguredAttribute;
import nl.b3p.viewer.config.app.StartLayer;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.FeatureTypeRelation;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import org.apache.commons.beanutils.BeanUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
public class ApplicationLayer {
    @Id
    private Long id;
    @ManyToOne
    private GeoService service;
    @Basic(optional=false)
    private String layerName;
    @ElementCollection
    @Column(name="role_name")
    private Set<String> readers = new HashSet<String>();
    @ElementCollection
    @Column(name="role_name")
    private Set<String> writers = new HashSet<String>();
    @ElementCollection
    @JoinTable(joinColumns={@JoinColumn(name="application_layer")})
    private Map<String, ClobElement> details = new HashMap<String, ClobElement>();
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(inverseJoinColumns={@JoinColumn(name="attribute_")})
    @OrderColumn(name="list_index")
    private List<ConfiguredAttribute> attributes = new ArrayList<ConfiguredAttribute>();
    @OneToMany(mappedBy="applicationLayer", orphanRemoval=true, cascade={CascadeType.ALL})
    @MapKey(name="application")
    private Map<Application, StartLayer> startLayers = new HashMap<Application, StartLayer>();

    public List<ConfiguredAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<ConfiguredAttribute> attributes) {
        this.attributes = attributes;
    }

    public Map<String, ClobElement> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, ClobElement> details) {
        this.details = details;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Set<String> getReaders() {
        return this.readers;
    }

    public void setReaders(Set<String> readers) {
        this.readers = readers;
    }

    public Set<String> getWriters() {
        return this.writers;
    }

    public void setWriters(Set<String> writers) {
        this.writers = writers;
    }

    public GeoService getService() {
        return this.service;
    }

    public void setService(GeoService service) {
        this.service = service;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public Map<Application, StartLayer> getStartLayers() {
        return this.startLayers;
    }

    public void setStartLayers(Map<Application, StartLayer> startLayers) {
        this.startLayers = startLayers;
    }

    public List<ConfiguredAttribute> getAttributes(SimpleFeatureType sft) {
        return this.getAttributes(sft, false, new ArrayList<ConfiguredAttribute>());
    }

    public List<ConfiguredAttribute> getAttributes(SimpleFeatureType sft, boolean includeJoined) {
        return this.getAttributes(sft, includeJoined, new ArrayList<ConfiguredAttribute>());
    }

    private List<ConfiguredAttribute> getAttributes(SimpleFeatureType sft, boolean includeJoined, List<ConfiguredAttribute> attri) {
        for (ConfiguredAttribute att : this.attributes) {
            if (att.getFeatureType() != null && !att.getFeatureType().getId().equals(sft.getId())) continue;
            if (attri.contains(att)) {
                return attri;
            }
            attri.add(att);
        }
        if (includeJoined) {
            for (FeatureTypeRelation rel : sft.getRelations()) {
                if (!"join".equals(rel.getType())) continue;
                attri = this.getAttributes(rel.getForeignFeatureType(), true, attri);
            }
        }
        return attri;
    }

    public ConfiguredAttribute getAttribute(SimpleFeatureType sft, String name) {
        for (ConfiguredAttribute att : this.attributes) {
            if (!att.getAttributeName().equals(name) || att.getFeatureType() != null && !att.getFeatureType().getId().equals(sft.getId())) continue;
            return att;
        }
        return null;
    }

    public String getDisplayName(EntityManager em) {
        Layer l;
        if (ClobElement.isNotBlank(this.getDetails().get("titleAlias"))) {
            return this.getDetails().get("titleAlias").getValue();
        }
        Layer layer = l = this.getService() == null ? null : this.getService().getLayer(this.getLayerName(), em);
        if (l != null) {
            return l.getDisplayName();
        }
        return this.getLayerName();
    }

    public JSONObject toJSONObject(EntityManager em) throws JSONException {
        return this.toJSONObject(false, false, em, null);
    }

    public JSONObject toJSONObject(boolean includeAttributes, boolean includeRelations, EntityManager em, Application app) throws JSONException {
        StartLayer sl;
        Layer l;
        JSONObject o = new JSONObject();
        o.put("id", (Object)this.getId());
        o.put("layerName", (Object)this.getLayerName());
        if (this.getService() != null) {
            o.put("serviceId", (Object)this.getService().getId());
        }
        o.put("alias", (Object)this.getDisplayName(em));
        Layer layer = l = this.getService() == null ? null : this.getService().getLayer(this.getLayerName(), em);
        if (l != null && l.getFeatureType() != null) {
            o.put("featureType", (Object)l.getFeatureType().getId());
        }
        if (!this.getDetails().isEmpty()) {
            JSONObject d = new JSONObject();
            o.put("details", (Object)d);
            for (Map.Entry<String, ClobElement> e : this.getDetails().entrySet()) {
                d.put(e.getKey(), (Object)e.getValue().getValue());
            }
        }
        if (includeAttributes) {
            this.addAttributesJSON(o, includeRelations, em);
        }
        o.put("checked", (sl = this.getStartLayers().get(app)) != null ? sl.isChecked() : false);
        return o;
    }

    public void addAttributesJSON(JSONObject json, boolean includeRelations, EntityManager em) throws JSONException {
        Layer layer = this.getService().getSingleLayer(this.getLayerName(), em);
        Map<Object, Object> featureTypeAttributes = new HashMap();
        SimpleFeatureType ft = null;
        if (layer != null && (ft = layer.getFeatureType()) != null) {
            featureTypeAttributes = this.makeAttributeDescriptorList(ft);
        }
        Integer geometryAttributeIndex = null;
        JSONArray jattributes = new JSONArray();
        json.put("attributes", (Object)jattributes);
        for (ConfiguredAttribute ca : this.getAttributes()) {
            JSONObject j = ca.toJSONObject();
            AttributeDescriptor ad = (AttributeDescriptor)featureTypeAttributes.get(ca.getFullName());
            if (ad != null) {
                j.put("alias", (Object)ad.getAlias());
                j.put("type", (Object)ad.getType());
                if (ft != null && ca.getAttributeName().equals(ft.getGeometryAttribute()) && ca.getFeatureType() == ft) {
                    geometryAttributeIndex = jattributes.length();
                }
            }
            jattributes.put((Object)j);
        }
        if (ft != null) {
            json.put("geometryAttribute", (Object)ft.getGeometryAttribute());
            if (includeRelations) {
                json.put("relations", (Object)this.getRelationsJSON(em));
            }
        }
        if (geometryAttributeIndex != null) {
            json.put("geometryAttributeIndex", geometryAttributeIndex);
        }
    }

    public JSONArray getRelationsJSON(EntityManager em) throws JSONException {
        JSONArray j = new JSONArray();
        Layer layer = this.getService().getSingleLayer(this.getLayerName(), em);
        if (layer != null && layer.getFeatureType() != null) {
            for (FeatureTypeRelation rel : layer.getFeatureType().getRelations()) {
                JSONObject jRel = rel.toJSONObject();
                j.put((Object)jRel);
            }
        }
        return j;
    }

    private Map<String, AttributeDescriptor> makeAttributeDescriptorList(SimpleFeatureType ft) {
        HashMap<String, AttributeDescriptor> featureTypeAttributes = new HashMap<String, AttributeDescriptor>();
        for (AttributeDescriptor ad : ft.getAttributes()) {
            String name = ft.getId() + ":" + ad.getName();
            if (featureTypeAttributes.containsKey(name)) {
                return featureTypeAttributes;
            }
            featureTypeAttributes.put(name, ad);
        }
        if (ft.getRelations() != null) {
            for (FeatureTypeRelation rel : ft.getRelations()) {
                featureTypeAttributes.putAll(this.makeAttributeDescriptorList(rel.getForeignFeatureType()));
            }
        }
        return featureTypeAttributes;
    }

    void processStartLayers(Application app, ApplicationLayer original, Application copyFrom) throws Exception {
        StartLayer sl = original.getStartLayers().get(copyFrom);
        if (sl != null) {
            this.getStartLayers().put(app, sl.deepCopy(this, app));
        } else if (Objects.equals(app.getId(), copyFrom.getId())) {
            ArrayList<StartLayer> al = new ArrayList<StartLayer>(original.startLayers.values());
            for (int i = 0; i < al.size(); ++i) {
                StartLayer sl2 = (StartLayer)al.get(i);
                this.getStartLayers().put(app, sl2.deepCopy(this, app));
            }
        }
    }

    ApplicationLayer deepCopy(Map originalToCopy, Application app) throws Exception {
        ApplicationLayer copy = (ApplicationLayer)BeanUtils.cloneBean((Object)this);
        originalToCopy.put(this, copy);
        copy.setId(null);
        copy.setReaders(new HashSet<String>(this.readers));
        copy.setWriters(new HashSet<String>(this.writers));
        copy.setDetails(new HashMap<String, ClobElement>(this.details));
        copy.setAttributes(new ArrayList<ConfiguredAttribute>());
        for (ConfiguredAttribute a : this.attributes) {
            copy.getAttributes().add(a.deepCopy());
        }
        copy.setStartLayers(new HashMap<Application, StartLayer>());
        copy.processStartLayers(app, this, app);
        return copy;
    }

    public String toString() {
        return String.format("Application layer [id=%d, service id=%d, layer=%s]", this.id, this.service == null ? null : this.service.getId(), this.layerName);
    }
}

