/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.app;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import nl.b3p.viewer.components.ComponentRegistry;
import nl.b3p.viewer.components.ViewerComponent;
import nl.b3p.viewer.config.app.Application;
import org.apache.commons.beanutils.BeanUtils;
import org.hibernate.annotations.Type;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"name", "application"})})
public class ConfiguredComponent
implements Comparable<ConfiguredComponent> {
    @Id
    private Long id;
    @Basic(optional=false)
    private String name;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String config;
    @Basic(optional=false)
    private String className;
    @ElementCollection
    private Map<String, String> details = new HashMap<String, String>();
    @ManyToOne(optional=false)
    private Application application;
    @ElementCollection
    @Column(name="role_name")
    private Set<String> readers = new HashSet<String>();
    @ManyToOne
    private ConfiguredComponent motherComponent;
    @OneToMany(mappedBy="motherComponent")
    private List<ConfiguredComponent> linkedComponents = new ArrayList<ConfiguredComponent>();
    public static final List<String> classesExcludedFromPushing = new ArrayList<String>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getReaders() {
        return this.readers;
    }

    public void setReaders(Set<String> readers) {
        this.readers = readers;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public ConfiguredComponent getMotherComponent() {
        return this.motherComponent;
    }

    public void setMotherComponent(ConfiguredComponent motherComponent) {
        this.motherComponent = motherComponent;
    }

    public List<ConfiguredComponent> getLinkedComponents() {
        return this.linkedComponents;
    }

    public void setLinkedComponents(List<ConfiguredComponent> linkedComponents) {
        this.linkedComponents = linkedComponents;
    }

    public ViewerComponent getViewerComponent() {
        return ComponentRegistry.getInstance().getViewerComponent(this.className);
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject o = new JSONObject();
        o.put("name", (Object)this.name);
        o.put("className", (Object)this.className);
        JSONObject d = new JSONObject();
        o.put("details", (Object)d);
        for (Map.Entry<String, String> e : this.details.entrySet()) {
            d.put(e.getKey(), (Object)e.getValue());
        }
        o.put("config", (Object)(this.config == null ? new JSONObject() : new JSONObject(this.config)));
        return o;
    }

    @Override
    public int compareTo(ConfiguredComponent rhs) {
        return this.className.compareTo(rhs.getClassName());
    }

    ConfiguredComponent deepCopy(Application app) throws Exception {
        ConfiguredComponent copy = (ConfiguredComponent)BeanUtils.cloneBean((Object)this);
        copy.setId(null);
        copy.setDetails(new HashMap<String, String>(this.details));
        copy.setReaders(new HashSet<String>(this.readers));
        copy.setLinkedComponents(new ArrayList<ConfiguredComponent>());
        copy.setApplication(app);
        return copy;
    }

    static {
        classesExcludedFromPushing.add("viewer.components.HTML");
    }
}

