/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import nl.b3p.geotools.data.arcgis.ArcGISDataStoreFactory;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.services.ArcGISService;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.referencing.CRS;
import org.opengis.filter.Filter;

@Entity
@DiscriminatorValue(value="arcgis")
public class ArcGISFeatureSource
extends FeatureSource {
    private static final Log log = LogFactory.getLog(ArcGISFeatureSource.class);
    public static final String PROTOCOL = "arcgis";

    public DataStore createDataStore() throws Exception {
        return this.createDataStore(null);
    }

    public DataStore createDataStore(Map extraDataStoreParams) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.getLinkedService() != null) {
            Map<String, ClobElement> serviceDetails = this.getLinkedService().getDetails();
            ClobElement assumeVersion = serviceDetails.get("arcgis_assumeVersion");
            if (assumeVersion != null && assumeVersion.getValue() != null) {
                log.debug((Object)("Linked service details specify user assumed version " + assumeVersion + ", passing on to datastore"));
                params.put(ArcGISDataStoreFactory.AGS_ASSUME_VERSION.key, assumeVersion.getValue());
            } else {
                String version = ((ArcGISService)this.getLinkedService()).getCurrentVersion();
                if (version != null) {
                    log.debug((Object)("Linked service details has current version " + version + ", passing on to datastore"));
                    params.put(ArcGISDataStoreFactory.AGS_ASSUME_VERSION.key, version);
                }
            }
            if (!params.containsKey(ArcGISDataStoreFactory.AGS_ASSUME_VERSION.key)) {
                log.debug((Object)"No ArcGIS Server version to pass on to datastore, extra version request will be performed!");
            }
        }
        if (extraDataStoreParams != null) {
            params.putAll(extraDataStoreParams);
            if (extraDataStoreParams.containsKey(ArcGISDataStoreFactory.AGS_ASSUME_VERSION.key)) {
                log.debug((Object)("NOTE: version parameter as determined above overridden to " + params.get(ArcGISDataStoreFactory.AGS_ASSUME_VERSION.key)));
            }
        }
        params.put(ArcGISDataStoreFactory.URL.key, new URL(this.getUrl()));
        params.put(ArcGISDataStoreFactory.USER.key, this.getUsername());
        params.put(ArcGISDataStoreFactory.PASSWD.key, this.getPassword());
        log.debug((Object)("Opening datastore using parameters: " + params));
        params.put(ArcGISDataStoreFactory.CRS.key, CRS.decode((String)"EPSG:28992"));
        DataStore ds = null;
        try {
            ds = new ArcGISDataStoreFactory().createDataStore(params);
        }
        catch (Exception e) {
            params.put(ArcGISDataStoreFactory.PASSWD.key, "xxx");
            throw new Exception("Cannot open datastore using parameters " + params, e);
        }
        if (ds == null) {
            params.put(ArcGISDataStoreFactory.PASSWD.key, "xxx");
            throw new Exception("Cannot open datastore using parameters " + params);
        }
        return ds;
    }

    @Override
    org.geotools.data.FeatureSource openGeoToolsFeatureSource(SimpleFeatureType sft) throws Exception {
        DataStore ds = this.createDataStore();
        return ds.getFeatureSource(sft.getTypeName());
    }

    @Override
    org.geotools.data.FeatureSource openGeoToolsFeatureSource(SimpleFeatureType sft, int timeout) throws Exception {
        HashMap<String, Integer> extraParams = new HashMap<String, Integer>();
        extraParams.put(ArcGISDataStoreFactory.TIMEOUT.key, timeout);
        DataStore ds = this.createDataStore(extraParams);
        return ds.getFeatureSource(sft.getTypeName());
    }

    public org.geotools.data.FeatureSource openGeoToolsFeatureSource(SimpleFeatureType sft, Map extraDataStoreParams) throws Exception {
        DataStore ds = this.createDataStore(extraDataStoreParams);
        return ds.getFeatureSource(sft.getTypeName());
    }

    @Override
    FeatureCollection getFeatures(SimpleFeatureType sft, Filter f, int maxFeatures) throws Exception {
        Query q = null;
        q = f != null ? new Query(sft.getTypeName(), f) : new Query(sft.getTypeName());
        q.setMaxFeatures(maxFeatures);
        org.geotools.data.FeatureSource fs = sft.openGeoToolsFeatureSource();
        FeatureCollection fc = fs.getFeatures(q);
        return fc;
    }
}

