/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import javax.persistence.Embeddable;
import nl.b3p.viewer.config.services.CoordinateReferenceSystem;
import org.geotools.data.ows.CRSEnvelope;
import org.json.JSONException;
import org.json.JSONObject;

@Embeddable
public class BoundingBox
implements Cloneable {
    CoordinateReferenceSystem crs;
    Double minx;
    Double miny;
    Double maxx;
    Double maxy;

    public BoundingBox() {
    }

    public BoundingBox(CRSEnvelope e) {
        this.crs = new CoordinateReferenceSystem(e.getSRSName());
        this.minx = e.getMinX();
        this.miny = e.getMinY();
        this.maxx = e.getMaxX();
        this.maxy = e.getMaxY();
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public Double getMaxx() {
        return this.maxx;
    }

    public void setMaxx(Double maxx) {
        this.maxx = maxx;
    }

    public Double getMaxy() {
        return this.maxy;
    }

    public void setMaxy(Double maxy) {
        this.maxy = maxy;
    }

    public Double getMinx() {
        return this.minx;
    }

    public void setMinx(Double minx) {
        this.minx = minx;
    }

    public Double getMiny() {
        return this.miny;
    }

    public void setMiny(Double miny) {
        this.miny = miny;
    }

    public void setBounds(String bounds) {
        String[] bboxTokens = bounds.split(",");
        this.setMinx(Double.parseDouble(bboxTokens[0].trim()));
        this.setMiny(Double.parseDouble(bboxTokens[1].trim()));
        this.setMaxx(Double.parseDouble(bboxTokens[2].trim()));
        this.setMaxy(Double.parseDouble(bboxTokens[3].trim()));
    }

    public static BoundingBox fromJSONObject(JSONObject obj) {
        BoundingBox bbox = new BoundingBox();
        bbox.setMaxx(obj.getDouble("maxx"));
        bbox.setMaxy(obj.getDouble("maxy"));
        bbox.setMinx(obj.getDouble("minx"));
        bbox.setMiny(obj.getDouble("miny"));
        return bbox;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject o = new JSONObject();
        if (this.crs != null) {
            o.put("crs", (Object)this.crs.getName());
        }
        o.put("minx", (Object)this.minx);
        o.put("maxx", (Object)this.maxx);
        o.put("miny", (Object)this.miny);
        o.put("maxy", (Object)this.maxy);
        return o;
    }

    public BoundingBox clone() throws CloneNotSupportedException {
        BoundingBox clone = (BoundingBox)super.clone();
        if (this.crs != null) {
            this.crs = this.crs.clone();
        }
        return clone;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.crs != null ? this.crs.hashCode() : 0);
        hash = 89 * hash + (this.minx != null ? this.minx.hashCode() : 0);
        hash = 89 * hash + (this.miny != null ? this.miny.hashCode() : 0);
        hash = 89 * hash + (this.maxx != null ? this.maxx.hashCode() : 0);
        hash = 89 * hash + (this.maxy != null ? this.maxy.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        if (!(this.crs == other.crs || this.crs != null && this.crs.equals(other.crs))) {
            return false;
        }
        if (!(this.minx == other.minx || this.minx != null && this.minx.equals(other.minx))) {
            return false;
        }
        if (!(this.miny == other.miny || this.miny != null && this.miny.equals(other.miny))) {
            return false;
        }
        if (!(this.maxx == other.maxx || this.maxx != null && this.maxx.equals(other.maxx))) {
            return false;
        }
        return this.maxy == other.maxy || this.maxy != null && this.maxy.equals(other.maxy);
    }
}

