/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.FeatureSourceUpdateResult;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.UpdateResult;
import nl.b3p.web.WaitPageStatus;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UpdatableFeatureSource
extends FeatureSource {
    private static final Log log = LogFactory.getLog(UpdatableFeatureSource.class);
    private final int updatebatchsize = 50;

    public FeatureSourceUpdateResult update(EntityManager em) throws Exception {
        FeatureSourceUpdateResult result = new FeatureSourceUpdateResult(this);
        try {
            List<SimpleFeatureType> newFeatureTypes = this.createFeatureTypes(result.getWaitPageStatus().subtask("", 80.0f));
            int processed = 0;
            for (SimpleFeatureType newFt : newFeatureTypes) {
                MutableBoolean updated = new MutableBoolean();
                this.addOrUpdateFeatureType(newFt.getTypeName(), newFt, updated);
                MutablePair ftResult = (MutablePair)result.getFeatureTypeStatus().get(newFt.getTypeName());
                if (ftResult == null) {
                    result.getFeatureTypeStatus().put(newFt.getTypeName(), (MutablePair<SimpleFeatureType, UpdateResult.Status>)new MutablePair((Object)newFt, (Object)UpdateResult.Status.NEW));
                } else if (updated.isTrue()) {
                    log.info((Object)("Feature type: " + newFt.getTypeName() + " updated"));
                    ftResult.setRight((Object)UpdateResult.Status.UPDATED);
                } else {
                    ftResult.setRight((Object)UpdateResult.Status.UNMODIFIED);
                }
                if (++processed != 50) continue;
                processed = 0;
                if (!em.getTransaction().isActive()) {
                    em.getTransaction().begin();
                }
                em.persist((Object)this);
                em.getTransaction().commit();
                em.getTransaction().begin();
            }
            if (!em.getTransaction().isActive()) {
                em.getTransaction().begin();
            }
            em.persist((Object)this);
            em.getTransaction().commit();
            em.getTransaction().begin();
            processed = 0;
            Iterator<SimpleFeatureType> it = this.getFeatureTypes().iterator();
            while (it.hasNext()) {
                SimpleFeatureType oldFt = it.next();
                boolean stillExists = false;
                for (SimpleFeatureType newFt : newFeatureTypes) {
                    if (!newFt.getTypeName().equals(oldFt.getTypeName())) continue;
                    stillExists = true;
                    break;
                }
                if (!stillExists) {
                    it.remove();
                }
                if (processed != 50) continue;
                processed = 0;
                if (!em.getTransaction().isActive()) {
                    em.getTransaction().begin();
                }
                em.persist((Object)this);
                em.getTransaction().commit();
                em.getTransaction().begin();
            }
            result.setStatus(UpdateResult.Status.UPDATED);
        }
        catch (Exception e) {
            result.failedWithException(e);
        }
        return result;
    }

    public abstract List<SimpleFeatureType> createFeatureTypes(WaitPageStatus var1) throws Exception;
}

