/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import nl.b3p.viewer.config.services.AttributeDescriptor;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.UpdatableFeatureSource;
import nl.b3p.web.WaitPageStatus;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.feature.FeatureCollection;
import org.json.JSONException;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;

@Entity
@DiscriminatorValue(value="wfs")
public class WFSFeatureSource
extends UpdatableFeatureSource {
    private static final Log log = LogFactory.getLog(WFSFeatureSource.class);
    public static final String PROTOCOL = "wfs";
    public static final Integer TIMEOUT = 60000;

    public WFSFeatureSource() {
    }

    public WFSFeatureSource(Map params) throws JSONException {
        this.setUrl(params.get(WFSDataStoreFactory.URL.key).toString());
        this.setUsername((String)params.get(WFSDataStoreFactory.USERNAME.key));
        this.setPassword((String)params.get(WFSDataStoreFactory.PASSWORD.key));
    }

    public void loadFeatureTypes() throws Exception {
        this.loadFeatureTypes(new WaitPageStatus());
    }

    public void loadFeatureTypes(WaitPageStatus status) throws Exception {
        this.getFeatureTypes().addAll(this.createFeatureTypes(status));
    }

    public List<SimpleFeatureType> createFeatureTypes() throws Exception {
        return this.createFeatureTypes(new WaitPageStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SimpleFeatureType> createFeatureTypes(WaitPageStatus status) throws Exception {
        status.setCurrentAction("Ophalen informatie...");
        ArrayList<SimpleFeatureType> createdFeatureTypes = new ArrayList<SimpleFeatureType>();
        DataStore store = null;
        try {
            store = this.createDataStore();
            this.setName(store.getInfo().getTitle());
            status.setProgress(10);
            status.setCurrentAction("Lijst van type-namen ophalen...");
            String[] typeNames = store.getTypeNames();
            status.setProgress(20);
            if (typeNames.length != 0) {
                double progress = 20.0;
                double progressPerTypeName = 80.0 / (double)typeNames.length;
                for (String typeName : typeNames) {
                    status.setCurrentAction("Inladen schema van type \"" + typeName + "\"...");
                    log.debug((Object)("Loading feature source " + typeName + " for WFS url " + this.getUrl()));
                    SimpleFeatureSource gtFs = store.getFeatureSource(typeName);
                    SimpleFeatureType sft = new SimpleFeatureType();
                    sft.setTypeName(typeName);
                    sft.setFeatureSource(this);
                    sft.setWriteable(false);
                    if (gtFs.getInfo() != null) {
                        String title = gtFs.getInfo().getTitle();
                        sft.setDescription(StringUtils.isBlank((CharSequence)title) ? null : title);
                    }
                    org.opengis.feature.simple.SimpleFeatureType gtFt = (org.opengis.feature.simple.SimpleFeatureType)gtFs.getSchema();
                    for (org.opengis.feature.type.AttributeDescriptor gtAtt : gtFt.getAttributeDescriptors()) {
                        AttributeDescriptor att = new AttributeDescriptor();
                        sft.getAttributes().add(att);
                        att.setName(gtAtt.getLocalName());
                        AttributeType gtType = gtAtt.getType();
                        String binding = gtType.getBinding().getName();
                        String type = "";
                        if (binding.equals("com.vividsolutions.jts.geom.MultiPolygon")) {
                            type = "multipolygon";
                        } else if (binding.equals("com.vividsolutions.jts.geom.Polygon")) {
                            type = "polygon";
                        } else if (binding.equals("com.vividsolutions.jts.geom.Geometry")) {
                            type = "geometry";
                        } else if (binding.equals("com.vividsolutions.jts.geom.LineString")) {
                            type = "linestring";
                        } else if (binding.equals("com.vividsolutions.jts.geom.Point")) {
                            type = "point";
                        } else if (binding.equals("com.vividsolutions.jts.geom.MultiLineString")) {
                            type = "multilinestring";
                        } else if (binding.equals("com.vividsolutions.jts.geom.MultiPoint")) {
                            type = "multipoint";
                        } else if (binding.equals("java.lang.Boolean")) {
                            type = "boolean";
                        } else if (binding.equals("java.lang.Long")) {
                            type = "integer";
                        } else if (binding.equals("java.lang.String")) {
                            type = "string";
                        } else if (binding.equals("java.lang.Integer")) {
                            type = "integer";
                        } else if (binding.equals("java.lang.Short")) {
                            type = "integer";
                        } else if (binding.equals("java.lang.Double")) {
                            type = "double";
                        } else if (binding.equals("java.lang.Float")) {
                            type = "double";
                        } else if (binding.equals("java.sql.Timestamp")) {
                            type = "timestamp";
                        } else if (binding.equals("java.sql.Date")) {
                            type = "date";
                        } else if (binding.equals("java.math.BigDecimal")) {
                            type = "double";
                        }
                        if (sft.getGeometryAttribute() == null && gtType instanceof GeometryType) {
                            sft.setGeometryAttribute(att.getName());
                        }
                        att.setType(type);
                    }
                    createdFeatureTypes.add(sft);
                    status.setProgress((int)(progress += progressPerTypeName));
                }
            }
        }
        finally {
            status.setProgress(100);
            status.setCurrentAction("Service ingeladen");
            status.setFinished(true);
            if (store != null) {
                store.dispose();
            }
        }
        return createdFeatureTypes;
    }

    public DataStore createDataStore() throws Exception {
        return this.createDataStore(null);
    }

    public DataStore createDataStore(Map extraDataStoreParams) throws Exception {
        String wfsUrl;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(WFSDataStoreFactory.TIMEOUT.key, TIMEOUT);
        if (extraDataStoreParams != null) {
            params.putAll(extraDataStoreParams);
        }
        if (!(wfsUrl = this.getUrl()).endsWith("&") && !wfsUrl.endsWith("?")) {
            wfsUrl = wfsUrl + (wfsUrl.indexOf("?") >= 0 ? "&" : "?");
        }
        if (!(wfsUrl = wfsUrl + "REQUEST=GetCapabilities&SERVICE=WFS").toUpperCase().contains("VERSION")) {
            wfsUrl = wfsUrl + "&VERSION=1.1.0";
        }
        params.put(WFSDataStoreFactory.URL.key, wfsUrl);
        params.put(WFSDataStoreFactory.USERNAME.key, this.getUsername());
        params.put(WFSDataStoreFactory.PASSWORD.key, this.getPassword());
        log.debug((Object)("Opening datastore using parameters: " + params));
        try {
            DataStore ds = DataStoreFinder.getDataStore(params);
            if (ds == null) {
                params.put(WFSDataStoreFactory.PASSWORD.key, "xxx");
                throw new Exception("Cannot open datastore using parameters " + params);
            }
            return ds;
        }
        catch (Exception e) {
            params.put(WFSDataStoreFactory.PASSWORD.key, "xxx");
            throw new Exception("Cannot open datastore using parameters " + params, e);
        }
    }

    @Override
    public FeatureSource openGeoToolsFeatureSource(SimpleFeatureType sft) throws Exception {
        return this.openGeoToolsFeatureSource(sft, null);
    }

    @Override
    public FeatureSource openGeoToolsFeatureSource(SimpleFeatureType sft, int timeout) throws Exception {
        HashMap<String, Integer> extraParams = new HashMap<String, Integer>();
        extraParams.put(WFSDataStoreFactory.TIMEOUT.key, timeout);
        DataStore ds = this.createDataStore(extraParams);
        return ds.getFeatureSource(sft.getTypeName());
    }

    public FeatureSource openGeoToolsFeatureSource(SimpleFeatureType sft, Map extraDataStoreParams) throws Exception {
        DataStore ds = this.createDataStore(extraDataStoreParams);
        return ds.getFeatureSource(sft.getTypeName());
    }

    @Override
    FeatureCollection getFeatures(SimpleFeatureType sft, Filter f, int maxFeatures) throws Exception {
        Query q = null;
        q = f != null ? new Query(sft.getTypeName(), f) : new Query(sft.getTypeName());
        q.setMaxFeatures(maxFeatures);
        FeatureCollection fc = sft.openGeoToolsFeatureSource().getFeatures(q);
        return fc;
    }
}

