/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.app;

import java.util.List;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.Level;
import nl.b3p.viewer.config.app.StartLayer;
import nl.b3p.viewer.config.app.StartLevel;
import nl.b3p.viewer.util.TestUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public class ApplicationTest
extends TestUtil {
    private static final Log log = LogFactory.getLog(ApplicationTest.class);

    @Test
    public void testDeepCopy() throws Exception {
        this.initData(true);
        int expectedStartLayerSize = this.app.getStartLayers().size();
        int expectedStartLevelSize = this.app.getStartLevels().size();
        Application copy = this.app.deepCopy();
        copy.setVersion("666");
        this.entityManager.detach((Object)this.app);
        this.entityManager.persist((Object)copy);
        this.entityManager.getTransaction().commit();
        this.entityManager.getTransaction().begin();
        Application toTest = (Application)this.entityManager.find(Application.class, (Object)copy.getId());
        Assert.assertFalse((boolean)this.app.getId().equals(toTest.getId()));
        Assert.assertEquals((long)expectedStartLayerSize, (long)toTest.getStartLayers().size());
        Assert.assertEquals((long)expectedStartLevelSize, (long)toTest.getStartLevels().size());
        for (StartLayer startLayer : toTest.getStartLayers()) {
            Assert.assertEquals((Object)toTest.getId(), (Object)startLayer.getApplication().getId());
        }
        for (StartLevel startLevel : toTest.getStartLevels()) {
            Assert.assertEquals((Object)toTest.getId(), (Object)startLevel.getApplication().getId());
        }
        this.app = (Application)this.entityManager.merge((Object)this.app);
    }

    @Test
    public void testDeepCopyReaders() throws Exception {
        this.initData(true);
        Application copy = this.app.deepCopy();
        Assert.assertEquals((long)2L, (long)copy.getReaders().size());
        for (String reader : this.app.getReaders()) {
            Assert.assertTrue((boolean)copy.getReaders().contains(reader));
        }
    }

    @Test
    public void testDeleteApplications() throws Exception {
        this.initData(true);
        Application application = (Application)this.entityManager.find(Application.class, (Object)this.app.getId());
        Application copy = application.deepCopy();
        this.entityManager.detach((Object)application);
        copy.setVersion("123");
        this.entityManager.persist((Object)copy);
        application = (Application)this.entityManager.merge((Object)application);
    }

    @Test
    public void testMakeMashupLinkComponents() throws Exception {
        block6: {
            this.initData(true);
            try {
                int expectedStartLayerSize = this.app.getStartLayers().size();
                int expectedStartLevelSize = this.app.getStartLevels().size();
                int expectedRootStartLevelSize = this.app.getRoot().getStartLevels().size() * 2;
                Application mashup = this.app.createMashup("mashup", this.entityManager, true);
                this.entityManager.persist((Object)mashup);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                Assert.assertFalse((boolean)this.app.getId().equals(mashup.getId()));
                Assert.assertEquals((long)expectedStartLayerSize, (long)mashup.getStartLayers().size());
                Assert.assertEquals((long)expectedStartLevelSize, (long)mashup.getStartLevels().size());
                for (StartLayer startLayer : mashup.getStartLayers()) {
                    Assert.assertEquals((Object)mashup.getId(), (Object)startLayer.getApplication().getId());
                }
                for (StartLevel startLevel : mashup.getStartLevels()) {
                    Assert.assertEquals((Object)mashup.getId(), (Object)startLevel.getApplication().getId());
                }
                Assert.assertEquals((long)expectedRootStartLevelSize, (long)this.app.getRoot().getStartLevels().size());
                Assert.assertEquals((Object)this.app.getRoot(), (Object)mashup.getRoot());
                Application.TreeCache tc = mashup.loadTreeCache(this.entityManager);
                List levels = tc.getLevels();
                List appLayers = tc.getApplicationLayers();
                for (ApplicationLayer appLayer : appLayers) {
                    Assert.assertTrue((boolean)appLayer.getStartLayers().containsKey(mashup));
                }
                for (Level level : levels) {
                    if (level.getParent() == null) continue;
                    Assert.assertTrue((boolean)level.getStartLevels().containsKey(mashup));
                }
            }
            catch (Exception e) {
                log.error((Object)"Fout", (Throwable)e);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testMakeMashupDontDuplicateStartLayers() {
        block6: {
            this.initData(true);
            try {
                int expectedStartLayerSize = this.app.getStartLayers().size();
                Application mashup = this.app.createMashup("mashup", this.entityManager, false);
                this.entityManager.persist((Object)mashup);
                Application secondMashup = this.app.createMashup("mashup2", this.entityManager, false);
                this.entityManager.persist((Object)secondMashup);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                Assert.assertFalse((boolean)this.app.getId().equals(mashup.getId()));
                Assert.assertEquals((long)expectedStartLayerSize, (long)mashup.getStartLayers().size());
                for (StartLayer startLayer : mashup.getStartLayers()) {
                    Assert.assertEquals((Object)mashup.getId(), (Object)startLayer.getApplication().getId());
                }
                Application.TreeCache tc = mashup.loadTreeCache(this.entityManager);
                List appLayers = tc.getApplicationLayers();
                for (ApplicationLayer appLayer : appLayers) {
                    Assert.assertTrue((boolean)appLayer.getStartLayers().containsKey(mashup));
                }
                Assert.assertFalse((boolean)this.app.getId().equals(secondMashup.getId()));
                Assert.assertEquals((long)expectedStartLayerSize, (long)secondMashup.getStartLayers().size());
                for (StartLayer startLayer : secondMashup.getStartLayers()) {
                    Assert.assertEquals((Object)secondMashup.getId(), (Object)startLayer.getApplication().getId());
                }
                Application.TreeCache tc2 = secondMashup.loadTreeCache(this.entityManager);
                List appLayers2 = tc2.getApplicationLayers();
                for (ApplicationLayer appLayer : appLayers2) {
                    Assert.assertTrue((boolean)appLayer.getStartLayers().containsKey(secondMashup));
                }
            }
            catch (Exception e) {
                log.error((Object)"Fout", (Throwable)e);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testMakeMashupDontDuplicateStartLevels() {
        block4: {
            this.initData(true);
            try {
                int expectedStartLevelSize = this.app.getStartLevels().size();
                int expectedRootStartLevelSize = this.app.getRoot().getStartLevels().size() * 2;
                Application mashup = this.app.createMashup("mashup", this.entityManager, false);
                this.entityManager.persist((Object)mashup);
                Application secondMashup = this.app.createMashup("mashup2", this.entityManager, false);
                this.entityManager.persist((Object)secondMashup);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                Assert.assertFalse((boolean)this.app.getId().equals(mashup.getId()));
                Assert.assertEquals((long)expectedStartLevelSize, (long)mashup.getStartLevels().size());
                Assert.assertEquals((long)expectedRootStartLevelSize, (long)this.app.getRoot().getStartLevels().size());
                Assert.assertEquals((Object)this.app.getRoot(), (Object)mashup.getRoot());
                for (StartLevel startLevel : mashup.getStartLevels()) {
                    Assert.assertEquals((Object)mashup.getId(), (Object)startLevel.getApplication().getId());
                }
                Assert.assertFalse((boolean)this.app.getId().equals(secondMashup.getId()));
                Assert.assertEquals((long)expectedStartLevelSize, (long)secondMashup.getStartLevels().size());
                Assert.assertEquals((long)expectedRootStartLevelSize, (long)this.app.getRoot().getStartLevels().size());
                Assert.assertEquals((Object)this.app.getRoot(), (Object)secondMashup.getRoot());
                for (StartLevel startLevel : secondMashup.getStartLevels()) {
                    Assert.assertEquals((Object)secondMashup.getId(), (Object)startLevel.getApplication().getId());
                }
                Application.TreeCache treeCache = secondMashup.loadTreeCache(this.entityManager);
            }
            catch (Exception e) {
                log.error((Object)"Fout", (Throwable)e);
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testMakeMashupDontLinkComponents() throws Exception {
        block6: {
            this.initData(true);
            try {
                int expectedStartLayerSize = this.app.getStartLayers().size();
                int expectedStartLevelSize = this.app.getStartLevels().size();
                int expectedRootStartLevelSize = this.app.getRoot().getStartLevels().size() * 2;
                Application mashup = this.app.createMashup("mashup", this.entityManager, false);
                this.entityManager.persist((Object)mashup);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                Assert.assertFalse((boolean)this.app.getId().equals(mashup.getId()));
                Assert.assertEquals((long)expectedStartLayerSize, (long)mashup.getStartLayers().size());
                Assert.assertEquals((long)expectedStartLevelSize, (long)mashup.getStartLevels().size());
                for (StartLayer startLayer : mashup.getStartLayers()) {
                    Assert.assertEquals((Object)mashup.getId(), (Object)startLayer.getApplication().getId());
                }
                for (StartLevel startLevel : mashup.getStartLevels()) {
                    Assert.assertEquals((Object)mashup.getId(), (Object)startLevel.getApplication().getId());
                }
                Assert.assertEquals((long)expectedRootStartLevelSize, (long)this.app.getRoot().getStartLevels().size());
                Assert.assertEquals((Object)this.app.getRoot(), (Object)mashup.getRoot());
                Application.TreeCache tc = mashup.loadTreeCache(this.entityManager);
                List levels = tc.getLevels();
                List appLayers = tc.getApplicationLayers();
                for (ApplicationLayer appLayer : appLayers) {
                    Assert.assertTrue((boolean)appLayer.getStartLayers().containsKey(mashup));
                }
                for (Level level : levels) {
                    if (level.getParent() == null) continue;
                    Assert.assertTrue((boolean)level.getStartLevels().containsKey(mashup));
                }
            }
            catch (Exception e) {
                log.error((Object)"Fout", (Throwable)e);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testMakeMashupOfApplicationWithExistingMashup() throws Exception {
        block6: {
            this.initData(true);
            try {
                int expectedStartLayerSize = this.app.getStartLayers().size();
                int expectedStartLevelSize = this.app.getStartLevels().size();
                int expectedRootStartLevelSize = this.app.getRoot().getStartLevels().size() * 3;
                Application mashup1 = this.app.createMashup("mashup", this.entityManager, false);
                this.entityManager.persist((Object)mashup1);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                Application mashup = this.app.createMashup("mashup2", this.entityManager, false);
                this.entityManager.persist((Object)mashup);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                Assert.assertFalse((boolean)this.app.getId().equals(mashup.getId()));
                Assert.assertEquals((long)expectedStartLayerSize, (long)mashup.getStartLayers().size());
                Assert.assertEquals((long)expectedStartLevelSize, (long)mashup.getStartLevels().size());
                for (StartLayer startLayer : mashup.getStartLayers()) {
                    Assert.assertEquals((Object)mashup.getId(), (Object)startLayer.getApplication().getId());
                }
                for (StartLevel startLevel : mashup.getStartLevels()) {
                    Assert.assertEquals((Object)mashup.getId(), (Object)startLevel.getApplication().getId());
                }
                Assert.assertEquals((long)expectedRootStartLevelSize, (long)this.app.getRoot().getStartLevels().size());
                Assert.assertEquals((Object)this.app.getRoot(), (Object)mashup.getRoot());
                Application.TreeCache tc = mashup.loadTreeCache(this.entityManager);
                List levels = tc.getLevels();
                List appLayers = tc.getApplicationLayers();
                for (ApplicationLayer appLayer : appLayers) {
                    Assert.assertTrue((boolean)appLayer.getStartLayers().containsKey(mashup));
                }
                for (Level level : levels) {
                    if (level.getParent() == null) continue;
                    Assert.assertTrue((boolean)level.getStartLevels().containsKey(mashup));
                }
            }
            catch (Exception e) {
                log.error((Object)"Fout", (Throwable)e);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }
}

