/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.config.services;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nl.b3p.viewer.config.ClobElement;
import nl.b3p.viewer.config.services.BoundingBox;
import nl.b3p.viewer.config.services.CoordinateReferenceSystem;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.TileMatrix;
import nl.b3p.viewer.config.services.TileMatrixSet;
import nl.b3p.viewer.config.services.TileService;
import nl.b3p.viewer.config.services.TileSet;
import nl.b3p.viewer.util.TestUtil;
import nl.b3p.web.WaitPageStatus;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TileServiceTest
extends TestUtil {
    private TileService instance = new TileService();
    private static final String PDOK_WMTS = "http://geodata.nationaalgeoregister.nl/tiles/service/wmts?request=getcapabilities";
    private static final int PDOK_WMTS_LAYERCOUNT = 41;
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    DocumentBuilder builder = null;
    XPathFactory xPathfactory = XPathFactory.newInstance();
    XPath xpath = this.xPathfactory.newXPath();

    public TileServiceTest() throws ParserConfigurationException {
        this.builder = this.factory.newDocumentBuilder();
    }

    @Test
    public void testLoadFromUrl() {
        String url = "http://www.openbasiskaart.nl/mapcache/tms/1.0.0/osm-nb@rd";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ServiceName", "osm");
        params.put("resolutions", "1,2,4");
        params.put("serviceBbox", "16,32,18,34");
        params.put("crs", "28992");
        params.put("imageExtension", "png");
        params.put("tileSize", 256);
        params.put("tilingProtocol", "TMS");
        WaitPageStatus status = new WaitPageStatus();
        GeoService result = this.instance.loadFromUrl(url, params, status, this.entityManager);
        Assert.assertEquals((Object)"tiled", (Object)result.getProtocol());
        Assert.assertEquals((Object)url, (Object)result.getUrl());
        TileService ts = (TileService)result;
        Assert.assertEquals((Object)"osm", (Object)ts.getTilingLayer().getName());
        Assert.assertEquals((Object)"TMS", (Object)ts.getTilingProtocol());
        Assert.assertEquals((Object)ts.getUrl(), (Object)url);
        Layer l = ts.getTilingLayer();
        TileSet tileSet = l.getTileset();
        Assert.assertEquals((long)3L, (long)tileSet.getResolutions().size());
        Assert.assertEquals((long)256L, (long)tileSet.getHeight());
        Assert.assertEquals((Object)"osm", (Object)tileSet.getName());
        Assert.assertEquals((Object)"png", (Object)((ClobElement)l.getDetails().get("image_extension")).getValue());
        Assert.assertEquals((long)0L, (long)ts.getMatrixSets().size());
        JSONObject serviceObj = ts.toJSONObject(false, this.entityManager);
        Assert.assertTrue((boolean)serviceObj.has("matrixSets"));
        JSONArray matrixSets = serviceObj.getJSONArray("matrixSets");
        Assert.assertEquals((long)0L, (long)matrixSets.length());
    }

    @Test
    public void testLoadBRTWMTSFromURL() throws MalformedURLException {
        URL u = new URL(PDOK_WMTS);
        String url = u.toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tilingProtocol", "WMTS");
        params.put("ServiceName", "Web Map Tile Service - GeoWebCache");
        WaitPageStatus status = new WaitPageStatus();
        GeoService result = this.instance.loadFromUrl(url, params, status, this.entityManager);
        Assert.assertEquals((Object)"https://geodata.nationaalgeoregister.nl/tiles/service/wmts?", (Object)result.getUrl());
        Layer topLayer = result.getTopLayer();
        Assert.assertEquals((long)41L, (long)topLayer.getChildren().size());
        Layer brt = (Layer)topLayer.getChildren().get(0);
        Assert.assertEquals((Object)"brtachtergrondkaart", (Object)brt.getName());
        JSONArray styles = new JSONArray(((ClobElement)brt.getDetails().get("wms.styles")).getValue());
        JSONObject style = (JSONObject)styles.get(0);
        Assert.assertEquals((Object)"", (Object)style.getString("identifier"));
        Assert.assertEquals((long)1L, (long)brt.getBoundingBoxes().size());
        BoundingBox bbox = (BoundingBox)brt.getBoundingBoxes().get(new CoordinateReferenceSystem("urn:ogc:def:crs:EPSG::28992"));
        Assert.assertEquals((double)595401.9, (double)bbox.getMaxx(), (double)0.1);
        Assert.assertEquals((double)903401.9, (double)bbox.getMaxy(), (double)0.1);
        Assert.assertEquals((double)-370406.0, (double)bbox.getMinx(), (double)0.1);
        Assert.assertEquals((double)5328.8, (double)bbox.getMiny(), (double)0.1);
        JSONObject serviceObj = result.toJSONObject(false, this.entityManager);
        Assert.assertTrue((boolean)serviceObj.has("matrixSets"));
        JSONArray matrixSets = serviceObj.getJSONArray("matrixSets");
        Assert.assertEquals((long)4L, (long)matrixSets.length());
        JSONObject matrix = matrixSets.getJSONObject(1);
        JSONArray matrices = matrix.getJSONArray("matrices");
        Assert.assertEquals((long)15L, (long)matrices.length());
        Assert.assertTrue((boolean)serviceObj.has("layers"));
        JSONObject layers = serviceObj.getJSONObject("layers");
        JSONObject jsonLayer = layers.getJSONObject("brtachtergrondkaart");
        Assert.assertNotNull((Object)jsonLayer);
        Assert.assertTrue((boolean)jsonLayer.has("bbox"));
    }

    @Test
    public void testLoadArcGisWMTSFromURL() throws MalformedURLException {
        URL u = new URL("https://tiles.arcgis.com/tiles/nSZVuSZjHpEZZbRo/arcgis/rest/services/Historische_tijdreis_1950/MapServer/WMTS?request=getcapabilities");
        String url = u.toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tilingProtocol", "WMTS");
        WaitPageStatus status = new WaitPageStatus();
        GeoService result = this.instance.loadFromUrl(url, params, status, this.entityManager);
        Assert.assertEquals((Object)"https://tiles.arcgis.com/tiles/nSZVuSZjHpEZZbRo/arcgis/rest/services/Historische_tijdreis_1950/MapServer/WMTS?", (Object)result.getUrl());
        Layer topLayer = result.getTopLayer();
        Assert.assertEquals((long)1L, (long)topLayer.getChildren().size());
        Layer tijdreis = (Layer)topLayer.getChildren().get(0);
        Assert.assertEquals((Object)"Historische_tijdreis_1950", (Object)tijdreis.getName());
        JSONArray styles = new JSONArray(((ClobElement)tijdreis.getDetails().get("wms.styles")).getValue());
        JSONObject style = (JSONObject)styles.get(0);
        Assert.assertEquals((Object)"default", (Object)style.getString("identifier"));
        Assert.assertEquals((long)1L, (long)tijdreis.getBoundingBoxes().size());
        BoundingBox bbox = (BoundingBox)tijdreis.getBoundingBoxes().get(new CoordinateReferenceSystem("urn:ogc:def:crs:EPSG::28992"));
        Assert.assertEquals((double)-7170.5, (double)bbox.getMiny(), (double)0.1);
        Assert.assertEquals((double)-22869.1, (double)bbox.getMinx(), (double)0.1);
        Assert.assertEquals((double)312667.7, (double)bbox.getMaxx(), (double)0.1);
        Assert.assertEquals((double)662419.8, (double)bbox.getMaxy(), (double)0.1);
        JSONObject serviceObj = result.toJSONObject(false, this.entityManager);
        Assert.assertTrue((boolean)serviceObj.has("matrixSets"));
        JSONArray matrixSets = serviceObj.getJSONArray("matrixSets");
        Assert.assertEquals((long)1L, (long)matrixSets.length());
        JSONObject matrix = matrixSets.getJSONObject(0);
        JSONArray matrices = matrix.getJSONArray("matrices");
        Assert.assertEquals((long)12L, (long)matrices.length());
        Assert.assertTrue((boolean)serviceObj.has("layers"));
        JSONObject layers = serviceObj.getJSONObject("layers");
        JSONObject jsonLayer = layers.getJSONObject("Historische_tijdreis_1950");
        Assert.assertNotNull((Object)jsonLayer);
        Assert.assertTrue((boolean)jsonLayer.has("bbox"));
    }

    @Test
    public void testLoadTopoWMTSFromURL() throws MalformedURLException {
        URL u = new URL(PDOK_WMTS);
        String url = u.toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tilingProtocol", "WMTS");
        params.put("ServiceName", "Web Map Tile Service - GeoWebCache");
        WaitPageStatus status = new WaitPageStatus();
        GeoService result = this.instance.loadFromUrl(url, params, status, this.entityManager);
        Layer topLayer = result.getTopLayer();
        Assert.assertEquals((long)41L, (long)topLayer.getChildren().size());
        Assert.assertEquals((Object)"https://geodata.nationaalgeoregister.nl/tiles/service/wmts?", (Object)result.getUrl());
        Layer brt = (Layer)topLayer.getChildren().get(0);
        Assert.assertEquals((Object)"brtachtergrondkaart", (Object)brt.getName());
        Assert.assertEquals((long)1L, (long)brt.getBoundingBoxes().size());
        BoundingBox bbox = ((TileMatrixSet)brt.getMatrixSets().get(0)).getBbox();
        Assert.assertEquals((double)595401.91, (double)bbox.getMaxx(), (double)0.01);
        Assert.assertEquals((double)903402.0, (double)bbox.getMaxy(), (double)0.01);
        Assert.assertEquals((double)-285401.92, (double)bbox.getMinx(), (double)0.01);
        Assert.assertEquals((double)22598.16, (double)bbox.getMiny(), (double)0.01);
        JSONObject serviceObj = result.toJSONObject(false, this.entityManager);
        Assert.assertTrue((boolean)serviceObj.has("matrixSets"));
        JSONArray matrixSets = serviceObj.getJSONArray("matrixSets");
        Assert.assertEquals((long)4L, (long)matrixSets.length());
        JSONObject matrix = matrixSets.getJSONObject(1);
        JSONArray matrices = matrix.getJSONArray("matrices");
        Assert.assertEquals((long)15L, (long)matrices.length());
        Assert.assertTrue((boolean)serviceObj.has("layers"));
        JSONObject layers = serviceObj.getJSONObject("layers");
        JSONObject jsonLayer = layers.getJSONObject("brtachtergrondkaart");
        Assert.assertNotNull((Object)jsonLayer);
        Assert.assertTrue((boolean)jsonLayer.has("bbox"));
    }

    @Test
    @Ignore(value="Meine knows why..")
    public void testLoadLufoWMTSFromURL() throws MalformedURLException {
        URL u = new URL("http://webservices.gbo-provincies.nl/lufo/services/wmts?request=GetCapabilities");
        String url = u.toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tilingProtocol", "WMTS");
        params.put("ServiceName", "luchtfoto");
        WaitPageStatus status = new WaitPageStatus();
        GeoService result = this.instance.loadFromUrl(url, params, status, this.entityManager);
        Layer topLayer = result.getTopLayer();
        Assert.assertEquals((long)12L, (long)topLayer.getChildren().size());
        Assert.assertEquals((Object)"http://webservices.gbo-provincies.nl/lufo/services/wmts?", (Object)result.getUrl());
        Layer actueelWinter = (Layer)topLayer.getChildren().get(0);
        Assert.assertEquals((Object)"actueel_winter", (Object)actueelWinter.getName());
        Assert.assertEquals((long)1L, (long)actueelWinter.getBoundingBoxes().size());
        BoundingBox bbox = ((TileMatrixSet)actueelWinter.getMatrixSets().get(0)).getBbox();
        Assert.assertEquals((double)595401.92, (double)bbox.getMaxx(), (double)0.01);
        Assert.assertEquals((double)903401.92, (double)bbox.getMaxy(), (double)0.01);
        Assert.assertEquals((double)-285401.92, (double)bbox.getMinx(), (double)0.01);
        Assert.assertEquals((double)22598.08, (double)bbox.getMiny(), (double)0.01);
        JSONObject serviceObj = result.toJSONObject(false, this.entityManager);
        Assert.assertTrue((boolean)serviceObj.has("matrixSets"));
        JSONArray matrixSets = serviceObj.getJSONArray("matrixSets");
        Assert.assertEquals((long)1L, (long)matrixSets.length());
        JSONObject matrix = matrixSets.getJSONObject(0);
        JSONArray matrices = matrix.getJSONArray("matrices");
        Assert.assertEquals((long)16L, (long)matrices.length());
        Assert.assertTrue((boolean)serviceObj.has("layers"));
        JSONObject layers = serviceObj.getJSONObject("layers");
        JSONObject jsonLayer = layers.getJSONObject("actueel_winter");
        Assert.assertNotNull((Object)jsonLayer);
        Assert.assertTrue((boolean)jsonLayer.has("bbox"));
    }

    private void compareWMTS(GeoService result, String url) {
        Assert.assertEquals((Object)"tiled", (Object)result.getProtocol());
        Assert.assertEquals((Object)"http://localhost:8084/geoserver/gwc/service/wmts?", (Object)result.getUrl());
        TileService ts = (TileService)result;
        Assert.assertEquals((Object)"Web Map Tile Service - GeoWebCache", (Object)ts.getName());
        Assert.assertEquals((Object)"WMTS", (Object)ts.getTilingProtocol());
        Layer l = ts.getTilingLayer();
        Assert.assertEquals((Object)"image/png", (Object)((ClobElement)l.getDetails().get("image_extension")).getValue());
        Layer topLayer = ts.getTopLayer();
        Assert.assertEquals((long)1L, (long)topLayer.getChildren().size());
        Layer layer = (Layer)topLayer.getChildren().get(0);
        Assert.assertEquals((Object)"test:gemeente", (Object)layer.getName());
        Assert.assertEquals((Object)"gem_2014_new", (Object)layer.getTitle());
        JSONArray styles = new JSONArray(((ClobElement)layer.getDetails().get("wms.styles")).getValue());
        JSONObject style = (JSONObject)styles.get(0);
        Assert.assertEquals((Object)"", (Object)style.getString("identifier"));
        Assert.assertNotNull((Object)ts.getMatrixSets());
        Assert.assertEquals((long)6L, (long)ts.getMatrixSets().size());
        Assert.assertEquals((long)16L, (long)((TileMatrixSet)ts.getMatrixSets().get(1)).getMatrices().size());
        Assert.assertEquals((Object)"epsg:28992", (Object)((TileMatrixSet)layer.getMatrixSets().get(0)).getIdentifier());
        Assert.assertEquals((long)16L, (long)((TileMatrixSet)layer.getMatrixSets().get(0)).getMatrices().size());
        JSONObject serviceObj = ts.toJSONObject(false, this.entityManager);
        Assert.assertTrue((boolean)serviceObj.has("matrixSets"));
        JSONArray matrixSets = serviceObj.getJSONArray("matrixSets");
        Assert.assertEquals((long)6L, (long)matrixSets.length());
        JSONObject matrix = matrixSets.getJSONObject(1);
        JSONArray matrices = matrix.getJSONArray("matrices");
        Assert.assertEquals((long)16L, (long)matrices.length());
        Assert.assertTrue((boolean)serviceObj.has("layers"));
        JSONObject layers = serviceObj.getJSONObject("layers");
        JSONObject jsonLayer = layers.getJSONObject("test:gemeente");
        Assert.assertNotNull((Object)jsonLayer);
        Assert.assertTrue((!jsonLayer.has("bbox") ? 1 : 0) != 0);
    }

    @Test
    public void testParseMultipleTileMatrixSets() throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        URL u = TileServiceTest.class.getResource("singleLayer.xml");
        String url = u.toString();
        Document doc = this.builder.parse(url);
        List sets = this.instance.parseMatrixSets(this.xpath, doc);
        Assert.assertNotNull((Object)sets);
        Assert.assertEquals((long)6L, (long)sets.size());
    }

    @Test
    public void testParseTileMatrixSet() throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        URL u = TileServiceTest.class.getResource("tilematrixset.xml");
        String url = u.toString();
        Document doc = this.builder.parse(url);
        TileMatrixSet tms = this.instance.parseTileMatrixSet(this.xpath, doc.getChildNodes().item(0));
        Assert.assertNotNull((Object)tms);
        Assert.assertEquals((Object)"GlobalCRS84Pixel", (Object)tms.getIdentifier());
        Assert.assertEquals((Object)"urn:ogc:def:crs:EPSG::4326", (Object)tms.getCrs());
        Assert.assertNotNull((Object)tms.getBbox());
        Assert.assertEquals((Object)"urn:ogc:def:crs:EPSG::4326", (Object)tms.getBbox().getCrs().getName());
        Assert.assertEquals((double)-180.0, (double)tms.getBbox().getMaxy(), (double)0.01);
        Assert.assertEquals((double)new Double(90.0), (double)tms.getBbox().getMinx(), (double)0.01);
        Assert.assertEquals((double)-2.003768834E7, (double)tms.getBbox().getMiny(), (double)0.01);
        Assert.assertEquals((double)4.007510668E7, (double)tms.getBbox().getMaxx(), (double)0.01);
        List matrices = tms.getMatrices();
        Assert.assertNotNull((Object)matrices);
        Assert.assertEquals((long)18L, (long)matrices.size());
        TileMatrix first = (TileMatrix)matrices.get(0);
        Assert.assertNotNull((Object)first);
        Assert.assertEquals((Object)"GlobalCRS84Pixel:0", (Object)first.getIdentifier());
        Assert.assertEquals((Object)"7.951392199519542E8", (Object)first.getScaleDenominator());
        Assert.assertEquals((Object)"90.0 -180.0", (Object)first.getTopLeftCorner());
        Assert.assertEquals((long)256L, (long)first.getTileHeight());
        Assert.assertEquals((long)256L, (long)first.getTileWidth());
        Assert.assertEquals((long)1L, (long)first.getMatrixHeight());
        Assert.assertEquals((long)1L, (long)first.getMatrixWidth());
        Assert.assertEquals((Object)"", (Object)first.getTitle());
        Assert.assertEquals((Object)"", (Object)first.getDescription());
    }
}

