/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.app.ConfiguredAttribute;
import nl.b3p.viewer.config.app.ConfiguredComponent;
import nl.b3p.viewer.config.app.Level;
import nl.b3p.viewer.config.app.StartLayer;
import nl.b3p.viewer.config.app.StartLevel;
import nl.b3p.viewer.config.metadata.Metadata;
import nl.b3p.viewer.config.services.FeatureSource;
import nl.b3p.viewer.config.services.GeoService;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.config.services.SimpleFeatureType;
import nl.b3p.viewer.config.services.WFSFeatureSource;
import nl.b3p.viewer.config.services.WMSService;
import nl.b3p.viewer.util.LoggingTestUtil;
import nl.b3p.viewer.util.databaseupdate.ScriptRunner;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.junit.After;
import org.junit.Before;

public abstract class TestUtil
extends LoggingTestUtil {
    protected EntityManager entityManager;
    protected static int TEST_VERSION_NUMBER = 666;
    public Long applicationId = 1L;
    public static String originalVersion = null;
    public ApplicationLayer testAppLayer;
    public Level testLevel;
    public StartLayer testStartLayer;
    public StartLevel testStartLevel;
    public ConfiguredComponent testComponent;
    public Application app;
    private static final Log log = LogFactory.getLog(TestUtil.class);
    protected String layerName = "Test_omgeving:unittest";
    protected String geometryAttribute = "geom";
    protected String url = "https://flamingo5.b3p.nl/geoserver/Test_omgeving/ows";
    protected List<ConfiguredAttribute> attributes = new ArrayList<ConfiguredAttribute>();

    @Before
    public void setUp() throws Exception {
        String persistenceUnit = System.getProperty("test.persistence.unit");
        HashMap<String, String> config = new HashMap<String, String>();
        String testname = this.testName.getMethodName();
        testname = testname.replaceAll(":", "-");
        testname = testname.replaceAll(" ", "");
        String randomizer = RandomStringUtils.randomAlphabetic((int)8);
        config.put("javax.persistence.jdbc.url", "jdbc:hsqldb:mem:unittest-hsqldb_" + testname + "_" + randomizer + "/db;shutdown=true");
        this.entityManager = Persistence.createEntityManagerFactory((String)persistenceUnit, config).createEntityManager();
        if (!this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        this.loadTestData();
        if (!this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
    }

    @After
    public void closeTransaction() {
        if (this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().commit();
        }
        if (this.entityManager.isOpen()) {
            this.entityManager.close();
        }
    }

    public <T> void persistEntityTest(T entity, Class<T> clazz) {
        this.entityManager.persist(entity);
        this.entityManager.getTransaction().commit();
        this.entityManager.getTransaction().begin();
    }

    public void loadTestData() throws URISyntaxException, IOException, SQLException {
        Application app = (Application)this.entityManager.find(Application.class, (Object)this.applicationId);
        if (app == null) {
            InputStreamReader f = new InputStreamReader(TestUtil.class.getResourceAsStream("testdata.sql"));
            this.executeScript(f);
        }
        Metadata version = (Metadata)this.entityManager.createQuery("From Metadata where configKey = :v", Metadata.class).setParameter("v", (Object)"database_version").getSingleResult();
        originalVersion = version.getConfigValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeScript(Reader f) throws IOException, SQLException {
        try (Connection conn = null;){
            Session session = (Session)this.entityManager.getDelegate();
            conn = session.connection();
            ScriptRunner sr = new ScriptRunner(conn, true, true);
            sr.runScript(f, false);
            conn.commit();
            this.entityManager.flush();
        }
    }

    public void initData(boolean addToStartmap) {
        this.app = new Application();
        this.app.setName("testapp");
        this.app.setVersion("154");
        this.app.getReaders().add("pietje");
        this.app.getReaders().add("puk");
        this.persistEntityTest(this.app, Application.class);
        Level root = new Level();
        root.setName("root");
        this.app.setRoot(root);
        this.entityManager.persist((Object)this.app);
        this.persistEntityTest(root, Level.class);
        this.testLevel = new Level();
        this.testLevel.setName("testLevel");
        this.testLevel.setParent(root);
        root.getChildren().add(this.testLevel);
        this.persistEntityTest(this.testLevel, Level.class);
        this.testStartLevel = new StartLevel();
        this.testStartLevel.setApplication(this.app);
        this.testStartLevel.setLevel(this.testLevel);
        this.testLevel.getStartLevels().put(this.app, this.testStartLevel);
        this.app.getStartLevels().add(this.testStartLevel);
        this.persistEntityTest(this.testStartLevel, StartLevel.class);
        if (addToStartmap) {
            WFSFeatureSource fs = new WFSFeatureSource();
            fs.setName("pietje");
            fs.setUrl(this.url);
            this.persistEntityTest(fs, FeatureSource.class);
            SimpleFeatureType sft = new SimpleFeatureType();
            sft.setTypeName(this.layerName);
            sft.setGeometryAttribute(this.geometryAttribute);
            sft.setFeatureSource((FeatureSource)fs);
            this.persistEntityTest(sft, SimpleFeatureType.class);
            fs.getFeatureTypes().add(sft);
            this.persistEntityTest(fs, FeatureSource.class);
            Layer rlayer = new Layer();
            rlayer.setName("root");
            this.persistEntityTest(rlayer, Layer.class);
            Layer l = new Layer();
            l.setName(this.layerName);
            l.setFeatureType(sft);
            l.setParent(rlayer);
            this.persistEntityTest(l, Layer.class);
            rlayer.getChildren().add(l);
            this.persistEntityTest(rlayer, Layer.class);
            WMSService gs = new WMSService();
            gs.setName("gsname");
            gs.setUrl(this.url);
            gs.setTopLayer(rlayer);
            this.persistEntityTest(gs, GeoService.class);
            rlayer.setService((GeoService)gs);
            l.setService((GeoService)gs);
            this.testAppLayer = new ApplicationLayer();
            this.testAppLayer.setLayerName(this.layerName);
            this.testAppLayer.setService((GeoService)gs);
            this.testAppLayer.setAttributes(this.attributes);
            this.testLevel.getLayers().add(this.testAppLayer);
            this.testStartLayer = new StartLayer();
            this.testStartLayer.setApplicationLayer(this.testAppLayer);
            this.testStartLayer.setApplication(this.app);
            this.testStartLayer.setSelectedIndex(Integer.valueOf(16));
            this.app.getStartLayers().add(this.testStartLayer);
            this.testAppLayer.getStartLayers().put(this.app, this.testStartLayer);
            this.persistEntityTest(this.testAppLayer, ApplicationLayer.class);
            this.testStartLevel.setSelectedIndex(Integer.valueOf(9));
            this.entityManager.persist((Object)this.testStartLevel);
            this.entityManager.persist((Object)this.testAppLayer);
            this.entityManager.persist((Object)this.app);
            this.persistEntityTest(this.testStartLayer, StartLayer.class);
        }
        this.testComponent = new ConfiguredComponent();
        this.testComponent.setApplication(this.app);
        this.testComponent.setClassName("viewer.components.Bookmark");
        this.testComponent.setConfig("{value: 'aapnootmies'}");
        this.testComponent.setName("testClassName1");
        this.app.getComponents().add(this.testComponent);
        this.persistEntityTest(this.testComponent, ConfiguredComponent.class);
        this.entityManager.getTransaction().commit();
        this.entityManager.getTransaction().begin();
    }
}

